/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.List;
import org.apache.jempbox.xmp.ResourceEvent;
import org.apache.jempbox.xmp.ResourceRef;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaMediaManagement;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.image.xmp.XMPPacketScanner;
import org.apache.tika.utils.DateUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JempboxExtractor {
    private static final String DEFAULT_XMP_CHARSET = StandardCharsets.UTF_8.name();
    private XMPPacketScanner scanner = new XMPPacketScanner();
    private Metadata metadata;

    public JempboxExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parse(InputStream file) throws IOException, TikaException {
        ByteArrayOutputStream xmpraw = new ByteArrayOutputStream();
        if (!this.scanner.parse(file, xmpraw)) {
            return;
        }
        XMPMetadata xmp = null;
        try (ByteArrayInputStream decoded = new ByteArrayInputStream(xmpraw.toByteArray());){
            Document dom = new ParseContext().getDocumentBuilder().parse(decoded);
            if (dom != null) {
                xmp = new XMPMetadata(dom);
            }
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
        JempboxExtractor.extractDublinCore(xmp, this.metadata);
        JempboxExtractor.extractXMPMM(xmp, this.metadata);
    }

    public static void extractDublinCore(XMPMetadata xmpMetadata, Metadata metadata) {
        if (xmpMetadata == null) {
            return;
        }
        XMPSchemaDublinCore dc = null;
        try {
            dc = xmpMetadata.getDublinCoreSchema();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dc == null) {
            return;
        }
        if (dc.getTitle() != null) {
            metadata.set(TikaCoreProperties.TITLE, dc.getTitle());
        }
        if (dc.getDescription() != null) {
            metadata.set(TikaCoreProperties.DESCRIPTION, dc.getDescription());
        }
        if (dc.getCreators() != null && dc.getCreators().size() > 0) {
            metadata.set(TikaCoreProperties.CREATOR, JempboxExtractor.joinCreators(dc.getCreators()));
        }
        if (dc.getSubjects() != null && dc.getSubjects().size() > 0) {
            for (String keyword : dc.getSubjects()) {
                metadata.add(TikaCoreProperties.KEYWORDS, keyword);
            }
        }
    }

    protected static String joinCreators(List<String> creators) {
        if (creators == null || creators.size() == 0) {
            return "";
        }
        if (creators.size() == 1) {
            return creators.get(0);
        }
        StringBuffer c = new StringBuffer();
        for (String s : creators) {
            c.append(", ").append(s);
        }
        return c.substring(2);
    }

    public static void extractXMPMM(XMPMetadata xmp, Metadata metadata) {
        if (xmp == null) {
            return;
        }
        XMPSchemaMediaManagement mmSchema = null;
        try {
            mmSchema = xmp.getMediaManagementSchema();
        }
        catch (IOException e) {
            return;
        }
        if (mmSchema != null) {
            JempboxExtractor.addMetadata(metadata, XMPMM.DOCUMENTID, mmSchema.getDocumentID());
            ResourceRef derivedFrom = mmSchema.getDerivedFrom();
            if (derivedFrom != null) {
                try {
                    JempboxExtractor.addMetadata(metadata, XMPMM.DERIVED_FROM_DOCUMENTID, derivedFrom.getDocumentID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    JempboxExtractor.addMetadata(metadata, XMPMM.DERIVED_FROM_INSTANCEID, derivedFrom.getInstanceID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (mmSchema.getHistory() != null) {
                for (ResourceEvent stevt : mmSchema.getHistory()) {
                    String instanceId = null;
                    String action = null;
                    Calendar when = null;
                    String softwareAgent = null;
                    try {
                        instanceId = stevt.getInstanceID();
                        action = stevt.getAction();
                        when = stevt.getWhen();
                        softwareAgent = stevt.getSoftwareAgent();
                    }
                    catch (IOException | NullPointerException exception) {
                        // empty catch block
                    }
                    if (instanceId == null || instanceId.trim().length() <= 0) continue;
                    action = action == null ? "" : action;
                    String dateString = when == null ? "" : DateUtils.formatDate((Calendar)when);
                    softwareAgent = softwareAgent == null ? "" : softwareAgent;
                    metadata.add(XMPMM.HISTORY_EVENT_INSTANCEID, instanceId);
                    metadata.add(XMPMM.HISTORY_ACTION, action);
                    metadata.add(XMPMM.HISTORY_WHEN, dateString);
                    metadata.add(XMPMM.HISTORY_SOFTWARE_AGENT, softwareAgent);
                }
            }
        }
    }

    private static void addMetadata(Metadata m, Property p, String value) {
        if (value != null) {
            m.add(p, value);
        }
    }
}

