/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import nxt.Account;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingParams;
import nxt.PhasingPoll;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.VoteWeighting;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Logger;

public final class AccountRestrictions {
    private static final DbKey.LongKeyFactory<PhasingOnly> phasingControlDbKeyFactory = new DbKey.LongKeyFactory<PhasingOnly>("account_id"){

        @Override
        public DbKey newKey(PhasingOnly phasingOnly) {
            return phasingOnly.dbKey;
        }
    };
    private static final VersionedEntityDbTable<PhasingOnly> phasingControlTable = new VersionedEntityDbTable<PhasingOnly>("account_control_phasing", phasingControlDbKeyFactory){

        @Override
        protected PhasingOnly load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingOnly(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingOnly phasingOnly) throws SQLException {
            phasingOnly.save(connection);
        }
    };

    static void init() {
    }

    static void checkTransaction(Transaction transaction, boolean bl) throws NxtException.NotCurrentlyValidException {
        Account account = Account.getAccount(transaction.getSenderId());
        if (account == null) {
            throw new NxtException.NotCurrentlyValidException("Account " + Long.toUnsignedString(transaction.getSenderId()) + " does not exist yet");
        }
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            PhasingOnly phasingOnly = PhasingOnly.get(transaction.getSenderId());
            phasingOnly.checkTransaction(transaction, bl);
        }
    }

    static boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        Account account = Account.getAccount(transaction.getSenderId());
        if (!account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return false;
        }
        if (PhasingOnly.get(transaction.getSenderId()).getMaxFees() == 0L) {
            return false;
        }
        return transaction.getType() != TransactionType.AccountControl.SET_PHASING_ONLY && TransactionType.isDuplicate(TransactionType.AccountControl.SET_PHASING_ONLY, Long.toUnsignedString(account.getId()), map, true);
    }

    public static final class PhasingOnly {
        private final DbKey dbKey;
        private final long accountId;
        private PhasingParams phasingParams;
        private long maxFees;
        private short minDuration;
        private short maxDuration;

        public static PhasingOnly get(long l) {
            return (PhasingOnly)phasingControlTable.getBy(new DbClause.LongClause("account_id", l).and(new DbClause.ByteClause("voting_model", DbClause.Op.NE, VoteWeighting.VotingModel.NONE.getCode())));
        }

        public static int getCount() {
            return phasingControlTable.getCount();
        }

        public static DbIterator<PhasingOnly> getAll(int n, int n2) {
            return phasingControlTable.getAll(n, n2);
        }

        static void set(Account account, Attachment.SetPhasingOnly setPhasingOnly) {
            PhasingParams phasingParams = setPhasingOnly.getPhasingParams();
            if (phasingParams.getVoteWeighting().getVotingModel() == VoteWeighting.VotingModel.NONE) {
                account.removeControl(Account.ControlType.PHASING_ONLY);
                PhasingOnly phasingOnly = PhasingOnly.get(account.getId());
                phasingOnly.phasingParams = phasingParams;
                phasingControlTable.delete(phasingOnly);
                PhasingOnly.unset(account);
            } else {
                account.addControl(Account.ControlType.PHASING_ONLY);
                PhasingOnly phasingOnly = PhasingOnly.get(account.getId());
                if (phasingOnly == null) {
                    phasingOnly = new PhasingOnly(account.getId(), phasingParams, setPhasingOnly.getMaxFees(), setPhasingOnly.getMinDuration(), setPhasingOnly.getMaxDuration());
                } else {
                    phasingOnly.phasingParams = phasingParams;
                    phasingOnly.maxFees = setPhasingOnly.getMaxFees();
                    phasingOnly.minDuration = setPhasingOnly.getMinDuration();
                    phasingOnly.maxDuration = setPhasingOnly.getMaxDuration();
                }
                phasingControlTable.insert(phasingOnly);
            }
        }

        static void unset(Account account) {
            account.removeControl(Account.ControlType.PHASING_ONLY);
            PhasingOnly phasingOnly = PhasingOnly.get(account.getId());
            phasingControlTable.delete(phasingOnly);
        }

        private PhasingOnly(long l, PhasingParams phasingParams, long l2, short s, short s2) {
            this.accountId = l;
            this.dbKey = phasingControlDbKeyFactory.newKey(this.accountId);
            this.phasingParams = phasingParams;
            this.maxFees = l2;
            this.minDuration = s;
            this.maxDuration = s2;
        }

        private PhasingOnly(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.accountId = resultSet.getLong("account_id");
            this.dbKey = dbKey;
            Long[] longArray = (Long[])DbUtils.getArray(resultSet, "whitelist", Long[].class);
            this.phasingParams = new PhasingParams(resultSet.getByte("voting_model"), resultSet.getLong("holding_id"), resultSet.getLong("quorum"), resultSet.getLong("min_balance"), resultSet.getByte("min_balance_model"), longArray == null ? Convert.EMPTY_LONG : Convert.toArray(longArray));
            this.maxFees = resultSet.getLong("max_fees");
            this.minDuration = resultSet.getShort("min_duration");
            this.maxDuration = resultSet.getShort("max_duration");
        }

        public long getAccountId() {
            return this.accountId;
        }

        public PhasingParams getPhasingParams() {
            return this.phasingParams;
        }

        public long getMaxFees() {
            return this.maxFees;
        }

        public short getMinDuration() {
            return this.minDuration;
        }

        public short getMaxDuration() {
            return this.maxDuration;
        }

        private void checkTransaction(Transaction transaction, boolean bl) throws NxtException.AccountControlException {
            if (!bl && this.maxFees > 0L && Math.addExact(transaction.getFeeNQT(), PhasingPoll.getSenderPhasedTransactionFees(transaction.getSenderId())) > this.maxFees) {
                throw new NxtException.AccountControlException(String.format("Maximum total fees limit of %f NXT exceeded", (double)this.maxFees / 1.0E8));
            }
            if (transaction.getType() == TransactionType.Messaging.PHASING_VOTE_CASTING) {
                return;
            }
            try {
                this.phasingParams.checkApprovable();
            }
            catch (NxtException.NotCurrentlyValidException notCurrentlyValidException) {
                Logger.logDebugMessage("Account control no longer valid: " + notCurrentlyValidException.getMessage());
                return;
            }
            Appendix.Phasing phasing = transaction.getPhasing();
            if (phasing == null) {
                throw new NxtException.AccountControlException("Non-phased transaction when phasing account control is enabled");
            }
            if (!this.phasingParams.equals(phasing.getParams())) {
                throw new NxtException.AccountControlException("Phasing parameters mismatch phasing account control. Expected: " + this.phasingParams.toString() + " . Actual: " + phasing.getParams().toString());
            }
            if (!bl) {
                int n = phasing.getFinishHeight() - Nxt.getBlockchain().getHeight();
                if (this.maxDuration > 0 && n > this.maxDuration || this.minDuration > 0 && n < this.minDuration) {
                    throw new NxtException.AccountControlException("Invalid phasing duration " + n);
                }
            }
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO account_control_phasing (account_id, whitelist, voting_model, quorum, min_balance, holding_id, min_balance_model, max_fees, min_duration, max_duration, height, latest) KEY (account_id, height) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.accountId);
                DbUtils.setArrayEmptyToNull(preparedStatement, ++n, Convert.toArray(this.phasingParams.getWhitelist()));
                preparedStatement.setByte(++n, this.phasingParams.getVoteWeighting().getVotingModel().getCode());
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.phasingParams.getQuorum());
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.phasingParams.getVoteWeighting().getMinBalance());
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.phasingParams.getVoteWeighting().getHoldingId());
                preparedStatement.setByte(++n, this.phasingParams.getVoteWeighting().getMinBalanceModel().getCode());
                preparedStatement.setLong(++n, this.maxFees);
                preparedStatement.setShort(++n, this.minDuration);
                preparedStatement.setShort(++n, this.maxDuration);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }
    }
}

