/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import nxt.Attachment;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;

public final class Alias {
    private static final DbKey.LongKeyFactory<Alias> aliasDbKeyFactory = new DbKey.LongKeyFactory<Alias>("id"){

        @Override
        public DbKey newKey(Alias alias) {
            return alias.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Alias> aliasTable = new VersionedEntityDbTable<Alias>("alias", aliasDbKeyFactory){

        @Override
        protected Alias load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Alias(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Alias alias) throws SQLException {
            alias.save(connection);
        }

        @Override
        protected String defaultSort() {
            return " ORDER BY alias_name_lower ";
        }
    };
    private static final DbKey.LongKeyFactory<Offer> offerDbKeyFactory = new DbKey.LongKeyFactory<Offer>("id"){

        @Override
        public DbKey newKey(Offer offer) {
            return offer.dbKey;
        }
    };
    private static final VersionedEntityDbTable<Offer> offerTable = new VersionedEntityDbTable<Offer>("alias_offer", offerDbKeyFactory){

        @Override
        protected Offer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Offer(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Offer offer) throws SQLException {
            offer.save(connection);
        }
    };
    private long accountId;
    private final long id;
    private final DbKey dbKey;
    private final String aliasName;
    private String aliasURI;
    private int timestamp;

    public static int getCount() {
        return aliasTable.getCount();
    }

    public static int getAccountAliasCount(long l) {
        return aliasTable.getCount(new DbClause.LongClause("account_id", l));
    }

    public static DbIterator<Alias> getAliasesByOwner(long l, int n, int n2) {
        return aliasTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public static Alias getAlias(String string) {
        return (Alias)aliasTable.getBy(new DbClause.StringClause("alias_name_lower", string.toLowerCase(Locale.ROOT)));
    }

    public static DbIterator<Alias> getAliasesLike(String string, int n, int n2) {
        return aliasTable.getManyBy(new DbClause.LikeClause("alias_name_lower", string.toLowerCase(Locale.ROOT)), n, n2);
    }

    public static Alias getAlias(long l) {
        return (Alias)aliasTable.get(aliasDbKeyFactory.newKey(l));
    }

    public static Offer getOffer(Alias alias) {
        return (Offer)offerTable.getBy(new DbClause.LongClause("id", alias.getId()).and(new DbClause.LongClause("price", DbClause.Op.NE, Long.MAX_VALUE)));
    }

    static void deleteAlias(String string) {
        Alias alias = Alias.getAlias(string);
        Offer offer = Alias.getOffer(alias);
        if (offer != null) {
            offer.priceNQT = Long.MAX_VALUE;
            offerTable.delete(offer);
        }
        aliasTable.delete(alias);
    }

    static void addOrUpdateAlias(Transaction transaction, Attachment.MessagingAliasAssignment messagingAliasAssignment) {
        Alias alias = Alias.getAlias(messagingAliasAssignment.getAliasName());
        if (alias == null) {
            alias = new Alias(transaction, messagingAliasAssignment);
        } else {
            alias.accountId = transaction.getSenderId();
            alias.aliasURI = messagingAliasAssignment.getAliasURI();
            alias.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        }
        aliasTable.insert(alias);
    }

    static void sellAlias(Transaction transaction, Attachment.MessagingAliasSell messagingAliasSell) {
        String string = messagingAliasSell.getAliasName();
        long l = messagingAliasSell.getPriceNQT();
        long l2 = transaction.getRecipientId();
        if (l > 0L) {
            Alias alias = Alias.getAlias(string);
            Offer offer = Alias.getOffer(alias);
            if (offer == null) {
                offerTable.insert(new Offer(alias.id, l, l2));
            } else {
                offer.priceNQT = l;
                offer.buyerId = l2;
                offerTable.insert(offer);
            }
        } else {
            Alias.changeOwner(l2, string);
        }
    }

    static void changeOwner(long l, String string) {
        Alias alias = Alias.getAlias(string);
        alias.accountId = l;
        alias.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        aliasTable.insert(alias);
        Offer offer = Alias.getOffer(alias);
        if (offer != null) {
            offer.priceNQT = Long.MAX_VALUE;
            offerTable.delete(offer);
        }
    }

    static void init() {
    }

    private Alias(Transaction transaction, Attachment.MessagingAliasAssignment messagingAliasAssignment) {
        this.id = transaction.getId();
        this.dbKey = aliasDbKeyFactory.newKey(this.id);
        this.accountId = transaction.getSenderId();
        this.aliasName = messagingAliasAssignment.getAliasName();
        this.aliasURI = messagingAliasAssignment.getAliasURI();
        this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
    }

    private Alias(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.aliasName = resultSet.getString("alias_name");
        this.aliasURI = resultSet.getString("alias_uri");
        this.timestamp = resultSet.getInt("timestamp");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO alias (id, account_id, alias_name, alias_name_lower, alias_uri, timestamp, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setString(++n, this.aliasName);
            preparedStatement.setString(++n, this.aliasName.toLowerCase(Locale.ROOT));
            preparedStatement.setString(++n, this.aliasURI);
            preparedStatement.setInt(++n, this.timestamp);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getAliasURI() {
        return this.aliasURI;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public static class Offer {
        private long priceNQT;
        private long buyerId;
        private final long aliasId;
        private final DbKey dbKey;

        private Offer(long l, long l2, long l3) {
            this.priceNQT = l2;
            this.buyerId = l3;
            this.aliasId = l;
            this.dbKey = offerDbKeyFactory.newKey(this.aliasId);
        }

        private Offer(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.aliasId = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.priceNQT = resultSet.getLong("price");
            this.buyerId = resultSet.getLong("buyer_id");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO alias_offer (id, price, buyer_id, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.aliasId);
                preparedStatement.setLong(++n, this.priceNQT);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.buyerId);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.aliasId;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        public long getBuyerId() {
            return this.buyerId;
        }
    }
}

