/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Appendix;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockImpl;
import nxt.BlockchainImpl;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Db;
import nxt.Generator;
import nxt.Genesis;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingPoll;
import nxt.PrunableMessage;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionProcessor;
import nxt.TransactionProcessorImpl;
import nxt.TransactionType;
import nxt.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.db.DerivedDbTable;
import nxt.db.FilteringIterator;
import nxt.db.FullTextTrigger;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

final class BlockchainProcessorImpl
implements BlockchainProcessor {
    private static final NavigableMap<Integer, byte[]> checksums;
    private static final boolean LOG_DOWNLOADING_STATS = true;
    private int statsTotalTxCount;
    private int[] statsTxByType = new int[8];
    private long statsProcessingTime;
    private static final BlockchainProcessorImpl instance;
    private final BlockchainImpl blockchain = BlockchainImpl.getInstance();
    private final ExecutorService networkService = Executors.newCachedThreadPool();
    private final List<DerivedDbTable> derivedTables = new CopyOnWriteArrayList<DerivedDbTable>();
    private final boolean trimDerivedTables = Nxt.getBooleanProperty("nxt.trimDerivedTables");
    private final int defaultNumberOfForkConfirmations = Nxt.getIntProperty(Constants.isTestnet ? "nxt.testnetNumberOfForkConfirmations" : "nxt.numberOfForkConfirmations");
    private final boolean simulateEndlessDownload = Nxt.getBooleanProperty("nxt.simulateEndlessDownload");
    private int initialScanHeight;
    private volatile int lastTrimHeight;
    private volatile int lastRestoreTime = 0;
    private final Set<Long> prunableTransactions = new HashSet<Long>();
    private final Listeners<Block, BlockchainProcessor.Event> blockListeners = new Listeners();
    private volatile Peer lastBlockchainFeeder;
    private volatile int lastBlockchainFeederHeight;
    private volatile boolean getMoreBlocks = true;
    private volatile boolean isShuttingDown;
    private volatile boolean isTrimming;
    private volatile boolean isScanning;
    private volatile boolean isDownloading;
    private volatile boolean isProcessingBlock;
    private volatile boolean isRestoring;
    private volatile boolean alreadyInitialized = false;
    private final Runnable getMoreBlocksThread = new Runnable(){
        private final JSONStreamAware getCumulativeDifficultyRequest;
        private boolean peerHasMore;
        private List<Peer> connectedPublicPeers;
        private List<Long> chainBlockIds;
        private long totalTime;
        private long totalBlocks;
        {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"requestType", (Object)"getCumulativeDifficulty");
            this.getCumulativeDifficultyRequest = JSON.prepareRequest(jSONObject);
            this.totalTime = 1L;
        }

        @Override
        public void run() {
            try {
                int n;
                do {
                    if (!BlockchainProcessorImpl.this.getMoreBlocks) {
                        return;
                    }
                    n = BlockchainProcessorImpl.this.blockchain.getHeight();
                    this.downloadPeer();
                } while (BlockchainProcessorImpl.this.blockchain.getHeight() != n);
                if (BlockchainProcessorImpl.this.isDownloading && !BlockchainProcessorImpl.this.simulateEndlessDownload) {
                    Logger.logMessage("Finished blockchain download");
                    BlockchainProcessorImpl.this.isDownloading = false;
                }
                n = Nxt.getEpochTime();
                if (!BlockchainProcessorImpl.this.isRestoring && !BlockchainProcessorImpl.this.prunableTransactions.isEmpty() && n - BlockchainProcessorImpl.this.lastRestoreTime > 3600) {
                    BlockchainProcessorImpl.this.isRestoring = true;
                    BlockchainProcessorImpl.this.lastRestoreTime = n;
                    BlockchainProcessorImpl.this.networkService.submit(new RestorePrunableDataTask());
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.logDebugMessage("Blockchain download thread interrupted");
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString(), throwable);
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadPeer() throws InterruptedException {
            try {
                long l = System.currentTimeMillis();
                int n = BlockchainProcessorImpl.this.blockchain.getHeight() > Constants.LAST_CHECKSUM_BLOCK - 720 ? BlockchainProcessorImpl.this.defaultNumberOfForkConfirmations : Math.min(1, BlockchainProcessorImpl.this.defaultNumberOfForkConfirmations);
                this.connectedPublicPeers = Peers.getPublicPeers(Peer.State.CONNECTED, true);
                if (this.connectedPublicPeers.size() <= n) {
                    return;
                }
                this.peerHasMore = true;
                Peer peer = Peers.getWeightedPeer(this.connectedPublicPeers);
                if (peer == null) {
                    return;
                }
                JSONObject jSONObject = peer.send(this.getCumulativeDifficultyRequest);
                if (jSONObject == null) {
                    return;
                }
                BigInteger bigInteger = BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty();
                String string = (String)jSONObject.get((Object)"cumulativeDifficulty");
                if (string == null) {
                    return;
                }
                BigInteger bigInteger2 = new BigInteger(string);
                if (bigInteger2.compareTo(bigInteger) < 0) {
                    return;
                }
                if (jSONObject.get((Object)"blockchainHeight") != null) {
                    BlockchainProcessorImpl.this.lastBlockchainFeeder = peer;
                    BlockchainProcessorImpl.this.lastBlockchainFeederHeight = ((Long)jSONObject.get((Object)"blockchainHeight")).intValue();
                }
                if (bigInteger2.equals(bigInteger)) {
                    return;
                }
                long l2 = 2680262203532249785L;
                if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != 2680262203532249785L) {
                    l2 = this.getCommonMilestoneBlockId(peer);
                }
                if (l2 == 0L || !this.peerHasMore) {
                    return;
                }
                this.chainBlockIds = this.getBlockIdsAfterCommon(peer, l2, false);
                if (this.chainBlockIds.size() < 2 || !this.peerHasMore) {
                    return;
                }
                long l3 = this.chainBlockIds.get(0);
                BlockImpl blockImpl = BlockchainProcessorImpl.this.blockchain.getBlock(l3);
                if (blockImpl == null || BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() >= 720) {
                    if (blockImpl != null) {
                        Logger.logDebugMessage(peer + " advertised chain with better difficulty, but the last common block is at height " + blockImpl.getHeight());
                    }
                    return;
                }
                if (BlockchainProcessorImpl.this.simulateEndlessDownload) {
                    BlockchainProcessorImpl.this.isDownloading = true;
                    return;
                }
                if (!BlockchainProcessorImpl.this.isDownloading && BlockchainProcessorImpl.this.lastBlockchainFeederHeight - blockImpl.getHeight() > 10) {
                    Logger.logMessage("Blockchain download in progress");
                    BlockchainProcessorImpl.this.isDownloading = true;
                }
                BlockchainProcessorImpl.this.blockchain.updateLock();
                try {
                    if (bigInteger2.compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) {
                        return;
                    }
                    long l4 = BlockchainProcessorImpl.this.blockchain.getLastBlock().getId();
                    this.downloadBlockchain(peer, blockImpl, blockImpl.getHeight());
                    if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() <= 10) {
                        return;
                    }
                    int n2 = 0;
                    for (Peer peer2 : this.connectedPublicPeers) {
                        String string2;
                        JSONObject jSONObject2;
                        if (n2 >= n) break;
                        if (peer.getHost().equals(peer2.getHost())) continue;
                        this.chainBlockIds = this.getBlockIdsAfterCommon(peer2, l3, true);
                        if (this.chainBlockIds.isEmpty()) continue;
                        long l5 = this.chainBlockIds.get(0);
                        if (l5 == BlockchainProcessorImpl.this.blockchain.getLastBlock().getId()) {
                            ++n2;
                            continue;
                        }
                        BlockImpl blockImpl2 = BlockchainProcessorImpl.this.blockchain.getBlock(l5);
                        if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl2.getHeight() >= 720 || (jSONObject2 = peer.send(this.getCumulativeDifficultyRequest)) == null || (string2 = (String)jSONObject.get((Object)"cumulativeDifficulty")) == null || new BigInteger(string2).compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) continue;
                        Logger.logDebugMessage("Found a peer with better difficulty");
                        this.downloadBlockchain(peer2, blockImpl2, blockImpl.getHeight());
                    }
                    Logger.logDebugMessage("Got " + n2 + " confirmations");
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != l4) {
                        long l6 = System.currentTimeMillis() - l;
                        this.totalTime += l6;
                        int n3 = BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight();
                        this.totalBlocks += (long)n3;
                        Logger.logMessage("Downloaded " + n3 + " blocks in " + l6 / 1000L + " s, " + this.totalBlocks * 1000L / this.totalTime + " per s, " + this.totalTime * (long)(BlockchainProcessorImpl.this.lastBlockchainFeederHeight - BlockchainProcessorImpl.this.blockchain.getHeight()) / (this.totalBlocks * 1000L * 60L) + " min left");
                        Logger.logMessage("Tx total: " + BlockchainProcessorImpl.this.statsTotalTxCount + " by type: " + Arrays.toString(BlockchainProcessorImpl.this.statsTxByType) + " processing time: " + BlockchainProcessorImpl.this.statsProcessingTime + "ms");
                        BlockchainProcessorImpl.this.statsTotalTxCount = 0;
                        Arrays.fill(BlockchainProcessorImpl.this.statsTxByType, 0);
                        BlockchainProcessorImpl.this.statsProcessingTime = 0L;
                    } else {
                        Logger.logDebugMessage("Did not accept peer's blocks, back to our own fork");
                    }
                }
                finally {
                    BlockchainProcessorImpl.this.blockchain.updateUnlock();
                }
            }
            catch (NxtException.StopException stopException) {
                Logger.logMessage("Blockchain download stopped: " + stopException.getMessage());
                throw new InterruptedException("Blockchain download stopped");
            }
            catch (Exception exception) {
                Logger.logMessage("Error in blockchain download thread", exception);
            }
        }

        private long getCommonMilestoneBlockId(Peer peer) {
            String string = null;
            block0: while (true) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"requestType", (Object)"getMilestoneBlockIds");
                if (string == null) {
                    jSONObject.put((Object)"lastBlockId", (Object)BlockchainProcessorImpl.this.blockchain.getLastBlock().getStringId());
                } else {
                    jSONObject.put((Object)"lastMilestoneBlockId", string);
                }
                JSONObject jSONObject2 = peer.send(JSON.prepareRequest(jSONObject));
                if (jSONObject2 == null) {
                    return 0L;
                }
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"milestoneBlockIds");
                if (jSONArray == null) {
                    return 0L;
                }
                if (jSONArray.isEmpty()) {
                    return 2680262203532249785L;
                }
                if (jSONArray.size() > 20) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many milestoneBlockIds, blacklisting");
                    peer.blacklist("Too many milestoneBlockIds");
                    return 0L;
                }
                if (Boolean.TRUE.equals(jSONObject2.get((Object)"last"))) {
                    this.peerHasMore = false;
                }
                Iterator iterator = jSONArray.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Object e = iterator.next();
                    long l = Convert.parseUnsignedLong((String)e);
                    if (BlockDb.hasBlock(l)) {
                        if (string == null && jSONArray.size() > 1) {
                            this.peerHasMore = false;
                        }
                        return l;
                    }
                    string = (String)e;
                }
                break;
            }
        }

        private List<Long> getBlockIdsAfterCommon(Peer peer, long l, boolean bl) {
            boolean bl2;
            long l2 = l;
            ArrayList<Long> arrayList = new ArrayList<Long>(720);
            boolean bl3 = false;
            int n = bl ? 720 : 1440;
            block0: do {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"requestType", (Object)"getNextBlockIds");
                jSONObject.put((Object)"blockId", (Object)Long.toUnsignedString(l2));
                jSONObject.put((Object)"limit", (Object)n);
                JSONObject jSONObject2 = peer.send(JSON.prepareRequest(jSONObject));
                if (jSONObject2 == null) {
                    return Collections.emptyList();
                }
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"nextBlockIds");
                if (jSONArray == null || jSONArray.size() == 0) break;
                if (jSONArray.size() > n) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many nextBlockIds, blacklisting");
                    peer.blacklist("Too many nextBlockIds");
                    return Collections.emptyList();
                }
                bl2 = true;
                int n2 = 0;
                for (Object e : jSONArray) {
                    long l3 = Convert.parseUnsignedLong((String)e);
                    if (bl2) {
                        if (BlockDb.hasBlock(l3)) {
                            l2 = l3;
                            bl3 = true;
                        } else {
                            arrayList.add(l2);
                            arrayList.add(l3);
                            bl2 = false;
                        }
                    } else {
                        arrayList.add(l3);
                        if (arrayList.size() >= 720) continue block0;
                    }
                    if (!bl || ++n2 < 720) continue;
                    continue block0;
                }
            } while (bl2 && !bl);
            if (arrayList.isEmpty() && bl3) {
                arrayList.add(l2);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadBlockchain(Peer peer, Block block, int n) throws InterruptedException {
            Object object;
            Object object2;
            Object object3;
            int n2;
            HashMap<Long, PeerBlock> hashMap = new HashMap<Long, PeerBlock>();
            ArrayList<GetNextBlocks> arrayList = new ArrayList<GetNextBlocks>();
            int n3 = 36;
            int n4 = this.chainBlockIds.size() - 1;
            for (n2 = 0; n2 < n4; n2 += n3) {
                arrayList.add(new GetNextBlocks(this.chainBlockIds, n2, Math.min(n2 + n3, n4)));
            }
            n2 = ThreadLocalRandom.current().nextInt(this.connectedPublicPeers.size());
            long l = 0L;
            Peer peer2 = null;
            block8: while (!arrayList.isEmpty()) {
                for (GetNextBlocks getNextBlocks : arrayList) {
                    if (getNextBlocks.getRequestCount() > 1) break block8;
                    if (getNextBlocks.getStart() == 0 || getNextBlocks.getRequestCount() != 0) {
                        object3 = peer;
                    } else {
                        if (n2 >= this.connectedPublicPeers.size()) {
                            n2 = 0;
                        }
                        object3 = this.connectedPublicPeers.get(n2++);
                    }
                    if (getNextBlocks.getPeer() == object3) break block8;
                    getNextBlocks.setPeer((Peer)object3);
                    object2 = BlockchainProcessorImpl.this.networkService.submit(getNextBlocks);
                    getNextBlocks.setFuture((Future<List<BlockImpl>>)object2);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    BlockImpl blockImpl;
                    GetNextBlocks getNextBlocks;
                    getNextBlocks = (GetNextBlocks)object.next();
                    try {
                        object3 = getNextBlocks.getFuture().get();
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException.getMessage(), executionException);
                    }
                    if (object3 == null) {
                        getNextBlocks.getPeer().deactivate();
                        continue;
                    }
                    object2 = getNextBlocks.getPeer();
                    int n5 = getNextBlocks.getStart() + 1;
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext() && (blockImpl = (BlockImpl)iterator.next()).getId() == this.chainBlockIds.get(n5).longValue()) {
                        hashMap.put(blockImpl.getId(), new PeerBlock((Peer)object2, blockImpl));
                        ++n5;
                    }
                    if (n5 > getNextBlocks.getStop()) {
                        object.remove();
                    } else {
                        getNextBlocks.setStart(n5 - 1);
                    }
                    if (getNextBlocks.getResponseTime() <= l) continue;
                    l = getNextBlocks.getResponseTime();
                    peer2 = getNextBlocks.getPeer();
                }
            }
            if (peer2 != null && this.connectedPublicPeers.size() >= Peers.maxNumberOfConnectedPublicPeers && this.chainBlockIds.size() > 360) {
                Logger.logDebugMessage(peer2.getHost() + " took " + l + " ms, disconnecting");
                peer2.deactivate();
            }
            BlockchainProcessorImpl.this.blockchain.writeLock();
            try {
                int n6;
                object = new ArrayList();
                for (n6 = 1; n6 < this.chainBlockIds.size() && BlockchainProcessorImpl.this.blockchain.getHeight() - n < 720 && (object3 = (PeerBlock)hashMap.get(this.chainBlockIds.get(n6))) != null && BlockchainProcessorImpl.this.getMoreBlocks; ++n6) {
                    object2 = ((PeerBlock)object3).getBlock();
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() == ((BlockImpl)object2).getPreviousBlockId()) {
                        try {
                            long l2 = System.currentTimeMillis();
                            BlockchainProcessorImpl.this.pushBlock((BlockImpl)object2);
                            BlockchainProcessorImpl.this.statsProcessingTime = BlockchainProcessorImpl.this.statsProcessingTime + (System.currentTimeMillis() - l2);
                        }
                        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                            ((PeerBlock)object3).getPeer().blacklist(blockNotAcceptedException);
                        }
                        continue;
                    }
                    object.add(object2);
                }
                n6 = BlockchainProcessorImpl.this.blockchain.getHeight() - n;
                if (!object.isEmpty() && n6 < 720) {
                    Logger.logDebugMessage("Will process a fork of " + object.size() + " blocks, mine is " + n6);
                    this.processFork(peer, (List<BlockImpl>)object, block);
                }
            }
            finally {
                BlockchainProcessorImpl.this.blockchain.writeUnlock();
            }
        }

        private void processFork(Peer peer, List<BlockImpl> list, Block block) {
            BigInteger bigInteger = BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty();
            List<BlockImpl> list2 = BlockchainProcessorImpl.this.popOffTo(block);
            int n = 0;
            if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() == block.getId()) {
                for (BlockImpl object2 : list) {
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != object2.getPreviousBlockId()) continue;
                    try {
                        BlockchainProcessorImpl.this.pushBlock(object2);
                        ++n;
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        peer.blacklist(blockNotAcceptedException);
                        break;
                    }
                }
            }
            if (n > 0 && BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty().compareTo(bigInteger) < 0) {
                Logger.logDebugMessage("Pop off caused by peer " + peer.getHost() + ", blacklisting");
                peer.blacklist("Pop off");
                List<BlockImpl> list3 = BlockchainProcessorImpl.this.popOffTo(block);
                n = 0;
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    BlockImpl blockImpl = (BlockImpl)iterator.next();
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
            if (n == 0) {
                Logger.logDebugMessage("Didn't accept any blocks, pushing back my previous blocks");
                for (int i = list2.size() - 1; i >= 0; --i) {
                    BlockImpl blockImpl = list2.remove(i);
                    try {
                        BlockchainProcessorImpl.this.pushBlock(blockImpl);
                        continue;
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        Logger.logErrorMessage("Popped off block no longer acceptable: " + blockImpl.getJSONObject().toJSONString(), blockNotAcceptedException);
                        break;
                    }
                }
            } else {
                Logger.logDebugMessage("Switched to peer's fork");
                for (BlockImpl blockImpl : list2) {
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
        }
    };
    private final Listener<Block> checksumListener = block -> {
        byte[] byArray;
        byte[] byArray2 = (byte[])checksums.get(block.getHeight());
        if (byArray2 == null) {
            return;
        }
        int n = block.getHeight();
        int n2 = checksums.lowerKey(n);
        if (n == Constants.TRANSPARENT_FORGING_BLOCK) {
            MessageDigest messageDigest = Crypto.sha256();
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM transaction WHERE height > ? AND height <= ? ORDER BY id ASC, timestamp ASC");){
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n);
                try (DbIterator<TransactionImpl> dbIterator = this.blockchain.getTransactions(connection, preparedStatement);){
                    while (dbIterator.hasNext()) {
                        messageDigest.update(dbIterator.next().bytes());
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            byArray = messageDigest.digest();
        } else {
            byArray = Crypto.sha256().digest(block.getBytes());
        }
        if (byArray2.length == 0) {
            Logger.logMessage("Checksum calculated:\n" + Arrays.toString(byArray));
        } else if (!Arrays.equals(byArray, byArray2)) {
            Logger.logErrorMessage("Checksum failed at block " + n + ": " + Arrays.toString(byArray));
            if (this.isScanning) {
                throw new RuntimeException("Invalid checksum, interrupting rescan");
            }
            this.popOffTo(n2);
        } else {
            Logger.logMessage("Checksum passed at block " + n);
        }
    };
    private static final Comparator<Transaction> finishingTransactionsComparator;
    private static final Comparator<UnconfirmedTransaction> transactionArrivalComparator;

    static BlockchainProcessorImpl getInstance() {
        return instance;
    }

    private BlockchainProcessorImpl() {
        int n = Nxt.getIntProperty("nxt.trimFrequency");
        this.blockListeners.addListener((T block) -> {
            if (block.getHeight() % 5000 == 0) {
                Logger.logMessage("processed block " + block.getHeight());
            }
            if (this.trimDerivedTables && block.getHeight() % n == 0) {
                this.doTrimDerivedTables();
            }
        }, BlockchainProcessor.Event.BLOCK_SCANNED);
        this.blockListeners.addListener((T block) -> {
            if (this.trimDerivedTables && block.getHeight() % n == 0 && !this.isTrimming) {
                this.isTrimming = true;
                this.networkService.submit(() -> {
                    try {
                        this.trimDerivedTables();
                    }
                    finally {
                        this.isTrimming = false;
                    }
                });
            }
            if (block.getHeight() % 5000 == 0) {
                Logger.logMessage("received block " + block.getHeight());
                if (!this.isDownloading || block.getHeight() % 50000 == 0) {
                    Logger.logMessage("Analyzing tables");
                    this.networkService.submit(Db.db::analyzeTables);
                }
            }
        }, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener((T block) -> Db.db.analyzeTables(), BlockchainProcessor.Event.RESCAN_END);
        int n2 = Nxt.getIntProperty("nxt.stopDownloadHeight");
        if (n2 > 0) {
            this.blockListeners.addListener((T block) -> {
                if (block.getHeight() == n2) {
                    this.setGetMoreBlocks(false);
                    Peers.disableNetworking();
                    throw new NxtException.StopException(String.format("Reached height %d, stopping download and going offline", n2));
                }
            }, BlockchainProcessor.Event.BLOCK_PUSHED);
        }
        ThreadPool.runBeforeStart(() -> {
            this.alreadyInitialized = true;
            if (this.addGenesisBlock()) {
                this.scan(0, false);
            } else if (Nxt.getBooleanProperty("nxt.forceScan")) {
                this.scan(0, Nxt.getBooleanProperty("nxt.forceValidate"));
            } else {
                int n;
                boolean bl;
                boolean bl2;
                try (Connection connection = Db.db.getConnection();
                     Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT * FROM scan");){
                    resultSet.next();
                    bl2 = resultSet.getBoolean("rescan");
                    bl = resultSet.getBoolean("validate");
                    n = resultSet.getInt("height");
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
                if (bl2) {
                    this.scan(n, bl);
                }
            }
        }, false);
        if (!Constants.isLightClient && !Constants.isOffline) {
            ThreadPool.scheduleThread("GetMoreBlocks", this.getMoreBlocksThread, 1);
        }
    }

    @Override
    public boolean addListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.addListener(listener, event);
    }

    @Override
    public boolean removeListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.removeListener(listener, event);
    }

    @Override
    public void registerDerivedTable(DerivedDbTable derivedDbTable) {
        if (this.alreadyInitialized) {
            throw new IllegalStateException("Too late to register table " + derivedDbTable + ", must have done it in Nxt.Init");
        }
        this.derivedTables.add(derivedDbTable);
    }

    @Override
    public void trimDerivedTables() {
        try {
            Db.db.beginTransaction();
            this.doTrimDerivedTables();
            Db.db.commitTransaction();
        }
        catch (Exception exception) {
            Logger.logMessage(exception.toString(), exception);
            Db.db.rollbackTransaction();
            throw exception;
        }
        finally {
            Db.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTrimDerivedTables() {
        this.lastTrimHeight = Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0);
        if (this.lastTrimHeight > 0) {
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                if (this.isShuttingDown) break;
                this.blockchain.readLock();
                try {
                    long l = System.currentTimeMillis();
                    derivedDbTable.trim(this.lastTrimHeight);
                    l = System.currentTimeMillis() - l;
                    if (l > 300L) {
                        Logger.logDebugMessage("Trimming " + derivedDbTable + " took " + l + "ms");
                    }
                    Db.db.commitTransaction();
                }
                finally {
                    this.blockchain.readUnlock();
                }
            }
        }
    }

    List<DerivedDbTable> getDerivedTables() {
        return this.derivedTables;
    }

    @Override
    public Peer getLastBlockchainFeeder() {
        return this.lastBlockchainFeeder;
    }

    @Override
    public int getLastBlockchainFeederHeight() {
        return this.lastBlockchainFeederHeight;
    }

    @Override
    public boolean isScanning() {
        return this.isScanning;
    }

    @Override
    public int getInitialScanHeight() {
        return this.initialScanHeight;
    }

    @Override
    public boolean isDownloading() {
        return this.isDownloading;
    }

    @Override
    public boolean isProcessingBlock() {
        return this.isProcessingBlock;
    }

    @Override
    public int getMinRollbackHeight() {
        return this.trimDerivedTables ? (this.lastTrimHeight > 0 ? this.lastTrimHeight : Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0)) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeerBlock(JSONObject jSONObject) throws NxtException {
        BlockImpl blockImpl = BlockImpl.parseBlock(jSONObject);
        BlockImpl blockImpl2 = this.blockchain.getLastBlock();
        if (blockImpl.getPreviousBlockId() == blockImpl2.getId()) {
            this.pushBlock(blockImpl);
        } else if (blockImpl.getPreviousBlockId() == blockImpl2.getPreviousBlockId() && blockImpl.getTimestamp() < blockImpl2.getTimestamp()) {
            this.blockchain.writeLock();
            try {
                if (blockImpl2.getId() != this.blockchain.getLastBlock().getId()) {
                    return;
                }
                BlockImpl blockImpl3 = this.blockchain.getBlock(blockImpl2.getPreviousBlockId());
                blockImpl2 = this.popOffTo(blockImpl3).get(0);
                try {
                    this.pushBlock(blockImpl);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl2.getTransactions());
                    Logger.logDebugMessage("Last block " + blockImpl2.getStringId() + " was replaced by " + blockImpl.getStringId());
                }
                catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                    Logger.logDebugMessage("Replacement block failed to be accepted, pushing back our last block");
                    this.pushBlock(blockImpl2);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getTransactions());
                }
            }
            finally {
                this.blockchain.writeUnlock();
            }
        }
    }

    public List<BlockImpl> popOffTo(int n) {
        if (n <= 0) {
            this.fullReset();
        } else if (n < this.blockchain.getHeight()) {
            return this.popOffTo(this.blockchain.getBlockAtHeight(n));
        }
        return Collections.emptyList();
    }

    @Override
    public void fullReset() {
        this.blockchain.writeLock();
        try {
            try {
                this.setGetMoreBlocks(false);
                this.scheduleScan(0, false);
                BlockDb.deleteAll();
                if (this.addGenesisBlock()) {
                    this.scan(0, false);
                }
            }
            finally {
                this.setGetMoreBlocks(true);
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    @Override
    public void setGetMoreBlocks(boolean bl) {
        this.getMoreBlocks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int restorePrunedData() {
        Object object;
        Db.db.beginTransaction();
        try {
            object = Db.db.getConnection();
            Throwable throwable = null;
            try {
                int n = Nxt.getEpochTime();
                int n2 = Math.max(1, n - Constants.MAX_PRUNABLE_LIFETIME);
                int n3 = Math.max(n2, n - Constants.MIN_PRUNABLE_LIFETIME) - 1;
                List<TransactionDb.PrunableTransaction> list = TransactionDb.findPrunableTransactions((Connection)object, n2, n3);
                list.forEach(prunableTransaction -> {
                    long l = prunableTransaction.getId();
                    if (prunableTransaction.hasPrunableAttachment() && prunableTransaction.getTransactionType().isPruned(l) || PrunableMessage.isPruned(l, prunableTransaction.hasPrunablePlainMessage(), prunableTransaction.hasPrunableEncryptedMessage())) {
                        Set<Long> set = this.prunableTransactions;
                        synchronized (set) {
                            this.prunableTransactions.add(l);
                        }
                    }
                });
                if (!this.prunableTransactions.isEmpty()) {
                    this.lastRestoreTime = 0;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            Db.db.endTransaction();
        }
        object = this.prunableTransactions;
        synchronized (object) {
            return this.prunableTransactions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction restorePrunedTransaction(long l) {
        Appendix.AbstractAppendix abstractAppendix2;
        TransactionImpl transactionImpl = TransactionDb.findTransaction(l);
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Transaction not found");
        }
        boolean bl = false;
        for (Appendix.AbstractAppendix abstractAppendix2 : transactionImpl.getAppendages(true)) {
            if (!(abstractAppendix2 instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)abstractAppendix2)).hasPrunableData()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return transactionImpl;
        }
        List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && peer.getAnnouncedAddress() != null);
        if (list.isEmpty()) {
            Logger.logDebugMessage("Cannot find any archive peers");
            return null;
        }
        abstractAppendix2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)Long.toUnsignedString(l));
        abstractAppendix2.put("requestType", "getTransactions");
        abstractAppendix2.put("transactionIds", jSONArray);
        JSONStreamAware jSONStreamAware = JSON.prepareRequest((JSONObject)abstractAppendix2);
        for (Peer peer2 : list) {
            JSONArray jSONArray2;
            if (peer2.getState() != Peer.State.CONNECTED) {
                Peers.connectPeer(peer2);
            }
            if (peer2.getState() != Peer.State.CONNECTED) continue;
            Logger.logDebugMessage("Connected to archive peer " + peer2.getHost());
            JSONObject jSONObject = peer2.send(jSONStreamAware);
            if (jSONObject == null || (jSONArray2 = (JSONArray)jSONObject.get((Object)"transactions")) == null || jSONArray2.isEmpty()) continue;
            try {
                List<Transaction> list2 = Nxt.getTransactionProcessor().restorePrunableData(jSONArray2);
                if (list2.isEmpty()) continue;
                Set<Long> set = this.prunableTransactions;
                synchronized (set) {
                    this.prunableTransactions.remove(l);
                }
                return list2.get(0);
            }
            catch (NxtException.NotValidException notValidException) {
                Logger.logErrorMessage("Peer " + peer2.getHost() + " returned invalid prunable transaction", notValidException);
                peer2.blacklist(notValidException);
            }
        }
        return null;
    }

    void shutdown() {
        this.isShuttingDown = true;
        ThreadPool.shutdownExecutor("networkService", this.networkService, 10);
    }

    private void addBlock(BlockImpl blockImpl) {
        try (Connection connection = Db.db.getConnection();){
            BlockDb.saveBlock(connection, blockImpl);
            this.blockchain.setLastBlock(blockImpl);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private boolean addGenesisBlock() {
        if (BlockDb.hasBlock(2680262203532249785L, 0)) {
            Logger.logMessage("Genesis block already in database");
            BlockImpl blockImpl = BlockDb.findLastBlock();
            this.blockchain.setLastBlock(blockImpl);
            if (blockImpl.getHeight() > 0 && blockImpl.getHeight() < Constants.MIGRATION_HEIGHT) {
                Logger.logDebugMessage("Will pop-off block " + blockImpl.getStringId());
                blockImpl = BlockDb.findBlock(blockImpl.getPreviousBlockId());
            }
            BlockDb.deleteBlocksFromHeight(blockImpl.getHeight() + 1);
            this.popOffTo(blockImpl);
            Logger.logMessage("Last block height: " + blockImpl.getHeight());
            return false;
        }
        Logger.logMessage("Genesis block not in database, starting from scratch");
        try {
            Object object;
            ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
            for (int i = 0; i < Genesis.GENESIS_RECIPIENTS.length; ++i) {
                object = new TransactionImpl.BuilderImpl(0, Genesis.CREATOR_PUBLIC_KEY, (long)Genesis.GENESIS_AMOUNTS[i] * 100000000L, 0L, 0, Attachment.ORDINARY_PAYMENT).isGenesisBlock(true).timestamp(0).recipientId(Genesis.GENESIS_RECIPIENTS[i]).signature(Genesis.GENESIS_SIGNATURES[i]).height(0).ecBlockHeight(0).ecBlockId(0L).build();
                arrayList.add((TransactionImpl)object);
            }
            arrayList.sort(Comparator.comparingLong(Transaction::getId));
            MessageDigest messageDigest = Crypto.sha256();
            for (TransactionImpl transactionImpl : arrayList) {
                messageDigest.update(transactionImpl.bytes());
            }
            object = new BlockImpl(-1, 0, 0L, 100000000000000000L, 0L, arrayList.size() * 128, messageDigest.digest(), Genesis.CREATOR_PUBLIC_KEY, new byte[64], Genesis.GENESIS_BLOCK_SIGNATURE, null, arrayList);
            ((BlockImpl)object).setPrevious(null);
            this.addBlock((BlockImpl)object);
            return true;
        }
        catch (NxtException.ValidationException validationException) {
            Logger.logMessage(validationException.getMessage());
            throw new RuntimeException(validationException.toString(), validationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushBlock(BlockImpl blockImpl) throws BlockchainProcessor.BlockNotAcceptedException {
        int n = Nxt.getEpochTime();
        this.blockchain.writeLock();
        try {
            BlockImpl blockImpl2 = null;
            try {
                Db.db.beginTransaction();
                blockImpl2 = this.blockchain.getLastBlock();
                this.validate(blockImpl, blockImpl2, n);
                long l = Generator.getNextHitTime(blockImpl2.getId(), n);
                if (l > 0L && (long)blockImpl.getTimestamp() > l + 1L) {
                    String string = "Rejecting block " + blockImpl.getStringId() + " at height " + blockImpl2.getHeight() + " block timestamp " + blockImpl.getTimestamp() + " next hit time " + l + " current time " + n;
                    Logger.logDebugMessage(string);
                    Generator.setDelay(-Constants.FORGING_SPEEDUP);
                    throw new BlockchainProcessor.BlockOutOfOrderException(string, blockImpl);
                }
                HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
                this.validatePhasedTransactions(blockImpl2.getHeight(), arrayList, arrayList2, hashMap);
                this.validateTransactions(blockImpl, blockImpl2, n, hashMap, blockImpl2.getHeight() >= Constants.LAST_CHECKSUM_BLOCK);
                blockImpl.setPrevious(blockImpl2);
                this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                TransactionProcessorImpl.getInstance().requeueAllUnconfirmedTransactions();
                try {
                    this.addBlock(blockImpl);
                    this.accept(blockImpl, arrayList, arrayList2, hashMap);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logInfoMessage("Failed to accept an already validated block", exception);
                    Db.db.rollbackTransaction();
                    BlockDb.deleteBlocksFrom(blockImpl.getId());
                    this.blockchain.setLastBlock(blockImpl2);
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.popOffTo(blockImpl2.getHeight());
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                    throw exception;
                }
            }
            finally {
                Db.db.endTransaction();
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        }
        finally {
            this.blockchain.writeUnlock();
        }
        if (blockImpl.getTimestamp() >= n - 600) {
            Peers.sendToSomePeers(blockImpl);
        }
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    private void validatePhasedTransactions(int n, List<TransactionImpl> list, List<TransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) {
        if (n >= Constants.PHASING_BLOCK) {
            try (DbIterator<TransactionImpl> dbIterator = PhasingPoll.getFinishingTransactions(n + 1);){
                for (TransactionImpl transactionImpl : dbIterator) {
                    if (n > Constants.SHUFFLING_BLOCK && PhasingPoll.getResult(transactionImpl.getId()) != null) continue;
                    try {
                        transactionImpl.validate();
                        if (!transactionImpl.attachmentIsDuplicate(map, false)) {
                            list.add(transactionImpl);
                            continue;
                        }
                        Logger.logDebugMessage("At height " + n + " phased transaction " + transactionImpl.getStringId() + " is duplicate, will not apply");
                        list2.add(transactionImpl);
                    }
                    catch (NxtException.ValidationException validationException) {
                        Logger.logDebugMessage("At height " + n + " phased transaction " + transactionImpl.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", will not apply");
                        list2.add(transactionImpl);
                    }
                }
            }
        }
    }

    private void validate(BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (blockImpl2.getId() != blockImpl.getPreviousBlockId()) {
            throw new BlockchainProcessor.BlockOutOfOrderException("Previous block id doesn't match", blockImpl);
        }
        if (blockImpl2.getHeight() >= Constants.MIGRATION_HEIGHT && blockImpl2.getVersion() == 4) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Blockchain migration performed at height " + blockImpl2.getHeight(), blockImpl);
        }
        if (!this.isValidBlockVersion(blockImpl, blockImpl2)) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid version " + blockImpl.getVersion(), blockImpl);
        }
        if (blockImpl.getTimestamp() > n + 15) {
            Logger.logWarningMessage("Received block " + blockImpl.getStringId() + " from the future, timestamp " + blockImpl.getTimestamp() + " generator " + Long.toUnsignedString(blockImpl.getGeneratorId()) + " current time " + n + ", system clock may be off");
            throw new BlockchainProcessor.BlockOutOfOrderException("Invalid timestamp: " + blockImpl.getTimestamp() + " current time is " + n, blockImpl);
        }
        if (blockImpl.getTimestamp() <= blockImpl2.getTimestamp()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block timestamp " + blockImpl.getTimestamp() + " is before previous block timestamp " + blockImpl2.getTimestamp(), blockImpl);
        }
        if (blockImpl.getVersion() != 1 && !Arrays.equals(Crypto.sha256().digest(blockImpl2.bytes()), blockImpl.getPreviousBlockHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Previous block hash doesn't match", blockImpl);
        }
        if (blockImpl.getId() == 0L || BlockDb.hasBlock(blockImpl.getId(), blockImpl2.getHeight())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Duplicate block or invalid id", blockImpl);
        }
        if (!blockImpl.verifyGenerationSignature() && !Generator.allowsFakeForging(blockImpl.getGeneratorPublicKey())) {
            Account account = Account.getAccount(blockImpl.getGeneratorId());
            long l = account == null ? 0L : account.getEffectiveBalanceNXT();
            throw new BlockchainProcessor.BlockNotAcceptedException("Generation signature verification failed, effective balance " + l, blockImpl);
        }
        if (!blockImpl.verifyBlockSignature()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block signature verification failed", blockImpl);
        }
        if (blockImpl.getTransactions().size() > 255) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid block transaction count " + blockImpl.getTransactions().size(), blockImpl);
        }
        if (blockImpl.getPayloadLength() > 44880 || blockImpl.getPayloadLength() < 0) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid block payload length " + blockImpl.getPayloadLength(), blockImpl);
        }
    }

    private void validateTransactions(BlockImpl blockImpl, BlockImpl blockImpl2, int n, Map<TransactionType, Map<String, Integer>> map, boolean bl) throws BlockchainProcessor.BlockNotAcceptedException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        MessageDigest messageDigest = Crypto.sha256();
        boolean bl2 = false;
        for (TransactionImpl transactionImpl : blockImpl.getTransactions()) {
            if (transactionImpl.getTimestamp() > n + 15) {
                throw new BlockchainProcessor.BlockOutOfOrderException("Invalid transaction timestamp: " + transactionImpl.getTimestamp() + ", current time is " + n, blockImpl);
            }
            if (!transactionImpl.verifySignature()) {
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction signature verification failed at height " + blockImpl2.getHeight(), transactionImpl);
            }
            if (bl) {
                if (transactionImpl.getTimestamp() > blockImpl.getTimestamp() + 15 || transactionImpl.getExpiration() < blockImpl.getTimestamp() && blockImpl2.getHeight() != 303) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction timestamp " + transactionImpl.getTimestamp() + ", current time is " + n + ", block timestamp is " + blockImpl.getTimestamp(), transactionImpl);
                }
                if (TransactionDb.hasTransaction(transactionImpl.getId(), blockImpl2.getHeight())) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is already in the blockchain", transactionImpl);
                }
                if (transactionImpl.referencedTransactionFullHash() != null && (blockImpl2.getHeight() < Constants.REFERENCED_TRANSACTION_FULL_HASH_BLOCK && !TransactionDb.hasTransaction(Convert.fullHashToId(transactionImpl.referencedTransactionFullHash()), blockImpl2.getHeight()) || blockImpl2.getHeight() >= Constants.REFERENCED_TRANSACTION_FULL_HASH_BLOCK && !this.hasAllReferencedTransactions(transactionImpl, transactionImpl.getTimestamp(), 0))) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Missing or invalid referenced transaction " + transactionImpl.getReferencedTransactionFullHash(), transactionImpl);
                }
                if (transactionImpl.getVersion() != this.getTransactionVersion(blockImpl2.getHeight())) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction version " + transactionImpl.getVersion() + " at height " + blockImpl2.getHeight(), transactionImpl);
                }
                if (transactionImpl.getId() == 0L) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction id 0", transactionImpl);
                }
                try {
                    transactionImpl.validate();
                }
                catch (NxtException.ValidationException validationException) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException(validationException.getMessage(), transactionImpl);
                }
            }
            if (transactionImpl.attachmentIsDuplicate(map, true)) {
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is a duplicate", transactionImpl);
            }
            if (!bl2) {
                for (Appendix.AbstractAppendix abstractAppendix : transactionImpl.getAppendages()) {
                    if (!(abstractAppendix instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)abstractAppendix)).hasPrunableData()) continue;
                    bl2 = true;
                    break;
                }
            }
            l2 += transactionImpl.getAmountNQT();
            l3 += transactionImpl.getFeeNQT();
            l += (long)transactionImpl.getFullSize();
            messageDigest.update(transactionImpl.bytes());
        }
        if (l2 != blockImpl.getTotalAmountNQT() || l3 != blockImpl.getTotalFeeNQT()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Total amount or fee don't match transaction totals", blockImpl);
        }
        if (!Arrays.equals(messageDigest.digest(), blockImpl.getPayloadHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Payload hash doesn't match", blockImpl);
        }
        if (bl2 ? l > (long)blockImpl.getPayloadLength() : l != (long)blockImpl.getPayloadLength()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Transaction payload length " + l + " does not match block payload length " + blockImpl.getPayloadLength(), blockImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(BlockImpl blockImpl, List<TransactionImpl> list, List<TransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) throws BlockchainProcessor.TransactionNotAcceptedException {
        try {
            this.isProcessingBlock = true;
            for (TransactionImpl transactionImpl2 : blockImpl.getTransactions()) {
                ++this.statsTotalTxCount;
                byte by = transactionImpl2.getType().getType();
                this.statsTxByType[by] = this.statsTxByType[by] + 1;
                if (transactionImpl2.applyUnconfirmed()) continue;
                throw new BlockchainProcessor.TransactionNotAcceptedException("Double spending", transactionImpl2);
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_APPLY);
            blockImpl.apply();
            list.forEach(transactionImpl -> transactionImpl.getPhasing().countVotes((TransactionImpl)transactionImpl));
            list2.forEach(transactionImpl -> transactionImpl.getPhasing().reject((TransactionImpl)transactionImpl));
            int n = Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME;
            int n2 = 0;
            for (TransactionImpl object : blockImpl.getTransactions()) {
                try {
                    object.apply();
                    if (object.getTimestamp() > n) {
                        for (Appendix.AbstractAppendix validationException : object.getAppendages(true)) {
                            if (!(validationException instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)validationException)).hasPrunableData()) continue;
                            Set<Long> set = this.prunableTransactions;
                            synchronized (set) {
                                this.prunableTransactions.add(object.getId());
                            }
                            this.lastRestoreTime = 0;
                            break;
                        }
                    }
                    if (++n2 % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    throw new BlockchainProcessor.TransactionNotAcceptedException((Throwable)runtimeException, object);
                }
            }
            if (blockImpl.getHeight() > Constants.SHUFFLING_BLOCK) {
                TreeSet<Transaction> treeSet = new TreeSet<Transaction>(finishingTransactionsComparator);
                blockImpl.getTransactions().forEach(transactionImpl -> {
                    PhasingPoll.getLinkedPhasedTransactions(transactionImpl.fullHash()).forEach(transaction -> {
                        if (transaction.getPhasing().getFinishHeight() > blockImpl.getHeight()) {
                            treeSet.add((TransactionImpl)transaction);
                        }
                    });
                    if (transactionImpl.getType() == TransactionType.Messaging.PHASING_VOTE_CASTING && !transactionImpl.attachmentIsPhased()) {
                        Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transactionImpl.getAttachment();
                        messagingPhasingVoteCasting.getTransactionFullHashes().forEach(byArray -> {
                            PhasingPoll phasingPoll = PhasingPoll.getPoll(Convert.fullHashToId(byArray));
                            if (phasingPoll.allowEarlyFinish() && phasingPoll.getFinishHeight() > blockImpl.getHeight()) {
                                treeSet.add(TransactionDb.findTransaction(phasingPoll.getId()));
                            }
                        });
                    }
                });
                list.forEach(transactionImpl -> {
                    PhasingPoll.PhasingPollResult phasingPollResult;
                    if (transactionImpl.getType() == TransactionType.Messaging.PHASING_VOTE_CASTING && (phasingPollResult = PhasingPoll.getResult(transactionImpl.getId())) != null && phasingPollResult.isApproved()) {
                        Attachment.MessagingPhasingVoteCasting messagingPhasingVoteCasting = (Attachment.MessagingPhasingVoteCasting)transactionImpl.getAttachment();
                        messagingPhasingVoteCasting.getTransactionFullHashes().forEach(byArray -> {
                            PhasingPoll phasingPoll = PhasingPoll.getPoll(Convert.fullHashToId(byArray));
                            if (phasingPoll.allowEarlyFinish() && phasingPoll.getFinishHeight() > blockImpl.getHeight()) {
                                treeSet.add(TransactionDb.findTransaction(phasingPoll.getId()));
                            }
                        });
                    }
                });
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    TransactionImpl runtimeException = (TransactionImpl)iterator.next();
                    if (PhasingPoll.getResult(runtimeException.getId()) != null) continue;
                    try {
                        runtimeException.validate();
                        runtimeException.getPhasing().tryCountVotes(runtimeException, map);
                        if (++n2 % Constants.BATCH_COMMIT_SIZE != 0) continue;
                        Db.db.commitTransaction();
                    }
                    catch (NxtException.ValidationException validationException) {
                        Logger.logDebugMessage("At height " + blockImpl.getHeight() + " phased transaction " + runtimeException.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", cannot finish early");
                    }
                }
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
            if (blockImpl.getTransactions().size() > 0) {
                TransactionProcessorImpl.getInstance().notifyListeners(blockImpl.getTransactions(), TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
            }
            AccountLedger.commitEntries();
        }
        finally {
            this.isProcessingBlock = false;
            AccountLedger.clearEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<BlockImpl> popOffTo(Block block) {
        this.blockchain.writeLock();
        try {
            Object object;
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    List<BlockImpl> list = this.popOffTo(block);
                    return list;
                }
                finally {
                    Db.db.endTransaction();
                }
            }
            if (block.getHeight() < this.getMinRollbackHeight()) {
                Logger.logMessage("Rollback to height " + block.getHeight() + " not supported, will do a full rescan");
                this.popOffWithRescan(block.getHeight() + 1);
                List<BlockImpl> list = Collections.emptyList();
                return list;
            }
            if (!this.blockchain.hasBlock(block.getId())) {
                Logger.logDebugMessage("Block " + block.getStringId() + " not found in blockchain, nothing to pop off");
                List<BlockImpl> list = Collections.emptyList();
                return list;
            }
            ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>();
            try {
                object = this.blockchain.getLastBlock();
                ((BlockImpl)object).loadTransactions();
                Logger.logDebugMessage("Rollback from block " + ((BlockImpl)object).getStringId() + " at height " + ((BlockImpl)object).getHeight() + " to " + block.getStringId() + " at " + block.getHeight());
                while (((BlockImpl)object).getId() != block.getId() && ((BlockImpl)object).getId() != 2680262203532249785L) {
                    arrayList.add((BlockImpl)object);
                    object = this.popLastBlock();
                }
                for (DerivedDbTable derivedDbTable : this.derivedTables) {
                    derivedDbTable.popOffTo(block.getHeight());
                }
                Db.db.clearCache();
                Db.db.commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Error popping off to " + block.getHeight() + ", " + runtimeException.toString(), runtimeException);
                Db.db.rollbackTransaction();
                BlockImpl blockImpl = BlockDb.findLastBlock();
                this.blockchain.setLastBlock(blockImpl);
                Iterator<DerivedDbTable> iterator = this.derivedTables.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        Db.db.clearCache();
                        Db.db.commitTransaction();
                        throw runtimeException;
                    }
                    DerivedDbTable derivedDbTable = iterator.next();
                    derivedDbTable.popOffTo(blockImpl.getHeight());
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    private BlockImpl popLastBlock() {
        BlockImpl blockImpl = this.blockchain.getLastBlock();
        if (blockImpl.getId() == 2680262203532249785L) {
            throw new RuntimeException("Cannot pop off genesis block");
        }
        BlockImpl blockImpl2 = BlockDb.deleteBlocksFrom(blockImpl.getId());
        blockImpl2.loadTransactions();
        this.blockchain.setLastBlock(blockImpl2);
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_POPPED);
        return blockImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popOffWithRescan(int n) {
        this.blockchain.writeLock();
        try {
            try {
                this.scheduleScan(0, false);
                BlockImpl blockImpl = BlockDb.deleteBlocksFrom(BlockDb.findBlockIdAtHeight(n));
                this.blockchain.setLastBlock(blockImpl);
                this.popOffTo(blockImpl);
                Logger.logDebugMessage("Deleted blocks starting from height %s", n);
            }
            finally {
                this.scan(0, false);
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    private int getBlockVersion(int n) {
        if (n < Constants.MIGRATION_SIGNALING_BLOCK) {
            return n < Constants.TRANSPARENT_FORGING_BLOCK ? 1 : (n < Constants.NQT_BLOCK ? 2 : 3);
        }
        if (n < Constants.MIGRATION_DECISION_BLOCK) {
            return 4;
        }
        Block block = Nxt.getBlockchain().getLastBlock();
        if (block.getVersion() == 4) {
            return 4;
        }
        return 3;
    }

    private boolean isValidBlockVersion(BlockImpl blockImpl, BlockImpl blockImpl2) {
        int n = blockImpl.getVersion();
        int n2 = blockImpl2.getHeight();
        if (n2 < Constants.MIGRATION_SIGNALING_BLOCK) {
            return n == this.getBlockVersion(n2);
        }
        if (n2 < Constants.MIGRATION_DECISION_BLOCK) {
            if (n == 3) {
                return blockImpl2.getVersion() != 4;
            }
            return n == 4;
        }
        if (blockImpl2.getVersion() == 4) {
            return n == 4;
        }
        return n == 3;
    }

    private int getTransactionVersion(int n) {
        return n < Constants.DIGITAL_GOODS_STORE_BLOCK ? 0 : 1;
    }

    SortedSet<UnconfirmedTransaction> selectUnconfirmedTransactions(Map<TransactionType, Map<String, Integer>> map, Block block, int n) {
        ArrayList<UnconfirmedTransaction> arrayList = new ArrayList<UnconfirmedTransaction>();
        try (Iterable<UnconfirmedTransaction> iterable = new FilteringIterator<UnconfirmedTransaction>(TransactionProcessorImpl.getInstance().getAllUnconfirmedTransactions(), unconfirmedTransaction -> this.hasAllReferencedTransactions(unconfirmedTransaction.getTransaction(), unconfirmedTransaction.getTimestamp(), 0));){
            for (UnconfirmedTransaction object : iterable) {
                arrayList.add(object);
            }
        }
        iterable = new TreeSet<UnconfirmedTransaction>(transactionArrivalComparator);
        int n2 = 0;
        while (n2 <= 44880 && iterable.size() <= 255) {
            int n3 = iterable.size();
            for (UnconfirmedTransaction unconfirmedTransaction2 : arrayList) {
                int n4 = unconfirmedTransaction2.getTransaction().getFullSize();
                if (iterable.contains(unconfirmedTransaction2) || n2 + n4 > 44880 || unconfirmedTransaction2.getVersion() != this.getTransactionVersion(block.getHeight()) || n > 0 && (unconfirmedTransaction2.getTimestamp() > n + 15 || unconfirmedTransaction2.getExpiration() < n)) continue;
                try {
                    unconfirmedTransaction2.getTransaction().validate();
                }
                catch (NxtException.ValidationException validationException) {
                    continue;
                }
                if (unconfirmedTransaction2.getTransaction().attachmentIsDuplicate(map, true)) continue;
                iterable.add((UnconfirmedTransaction)unconfirmedTransaction2);
                n2 += n4;
            }
            if (iterable.size() != n3) continue;
            break;
        }
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateBlock(String string, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
        if (this.blockchain.getHeight() >= Constants.PHASING_BLOCK) {
            object6 = PhasingPoll.getFinishingTransactions(this.blockchain.getHeight() + 1);
            object5 = null;
            try {
                object4 = ((DbIterator)object6).iterator();
                while (object4.hasNext()) {
                    object3 = (TransactionImpl)object4.next();
                    try {
                        ((TransactionImpl)object3).validate();
                        ((TransactionImpl)object3).attachmentIsDuplicate(hashMap, false);
                    }
                    catch (NxtException.ValidationException validationException) {}
                }
            }
            catch (Throwable throwable) {
                object5 = throwable;
                throw throwable;
            }
            finally {
                if (object6 != null) {
                    if (object5 != null) {
                        try {
                            ((DbIterator)object6).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object5).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object6).close();
                    }
                }
            }
        }
        object6 = this.blockchain.getLastBlock();
        TransactionProcessorImpl.getInstance().processWaitingTransactions();
        object5 = this.selectUnconfirmedTransactions(hashMap, (Block)object6, n);
        object4 = new ArrayList();
        object3 = Crypto.sha256();
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        Object object7 = object5.iterator();
        while (object7.hasNext()) {
            object2 = (UnconfirmedTransaction)object7.next();
            object = ((UnconfirmedTransaction)object2).getTransaction();
            object4.add(object);
            ((MessageDigest)object3).update(((TransactionImpl)object).bytes());
            l += ((TransactionImpl)object).getAmountNQT();
            l2 += ((TransactionImpl)object).getFeeNQT();
            n2 += ((TransactionImpl)object).getFullSize();
        }
        object7 = ((MessageDigest)object3).digest();
        ((MessageDigest)object3).update(((BlockImpl)object6).getGenerationSignature());
        object2 = Crypto.getPublicKey(string);
        object = ((MessageDigest)object3).digest((byte[])object2);
        byte[] byArray = Crypto.sha256().digest(((BlockImpl)object6).bytes());
        BlockImpl blockImpl = new BlockImpl(this.getBlockVersion(((BlockImpl)object6).getHeight()), n, ((BlockImpl)object6).getId(), l, l2, n2, (byte[])object7, (byte[])object2, (byte[])object, byArray, (List<TransactionImpl>)object4, string);
        try {
            this.pushBlock(blockImpl);
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_GENERATED);
            Logger.logDebugMessage("Account " + Long.toUnsignedString(blockImpl.getGeneratorId()) + " generated block " + blockImpl.getStringId() + " at height " + blockImpl.getHeight() + " timestamp " + blockImpl.getTimestamp() + " fee " + (float)blockImpl.getTotalFeeNQT() / 1.0E8f);
        }
        catch (BlockchainProcessor.TransactionNotAcceptedException transactionNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + transactionNotAcceptedException.getMessage());
            TransactionProcessorImpl.getInstance().processWaitingTransactions();
            TransactionImpl transactionImpl = transactionNotAcceptedException.getTransaction();
            Logger.logDebugMessage("Removing invalid transaction: " + transactionImpl.getStringId());
            this.blockchain.writeLock();
            try {
                TransactionProcessorImpl.getInstance().removeUnconfirmedTransaction(transactionImpl);
            }
            finally {
                this.blockchain.writeUnlock();
            }
            throw transactionNotAcceptedException;
        }
        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + blockNotAcceptedException.getMessage());
            throw blockNotAcceptedException;
        }
    }

    private boolean hasAllReferencedTransactions(TransactionImpl transactionImpl, int n, int n2) {
        if (transactionImpl.referencedTransactionFullHash() == null) {
            return n - transactionImpl.getTimestamp() < 5184000 && n2 < 10;
        }
        TransactionImpl transactionImpl2 = TransactionDb.findTransactionByFullHash(transactionImpl.referencedTransactionFullHash());
        return transactionImpl2 != null && transactionImpl2.getHeight() < transactionImpl.getHeight() && this.hasAllReferencedTransactions(transactionImpl2, n, n2 + 1);
    }

    void scheduleScan(int n, boolean bl) {
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE scan SET rescan = TRUE, height = ?, validate = ?");){
            preparedStatement.setInt(1, n);
            preparedStatement.setBoolean(2, bl);
            preparedStatement.executeUpdate();
            Logger.logDebugMessage("Scheduled scan starting from height " + n + (bl ? ", with validation" : ""));
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public void scan(int n, boolean bl) {
        this.scan(n, bl, false);
    }

    @Override
    public void fullScanWithShutdown() {
        this.scan(0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scan(int n, boolean bl, boolean bl2) {
        this.blockchain.writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    if (bl) {
                        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                    }
                    this.scan(n, bl, bl2);
                    Db.db.commitTransaction();
                    return;
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                    this.blockListeners.removeListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                }
            }
            this.scheduleScan(n, bl);
            if (n > 0 && n < this.getMinRollbackHeight()) {
                Logger.logMessage("Rollback to height less than " + this.getMinRollbackHeight() + " not supported, will do a full scan");
                n = 0;
            }
            if (n < 0) {
                n = 0;
            }
            Logger.logMessage("Scanning blockchain starting from height " + n + "...");
            if (bl) {
                Logger.logDebugMessage("Also verifying signatures and validating transactions...");
            }
            try (Connection connection = Db.db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE " + (n > 0 ? "height >= ? AND " : "") + " db_id >= ? ORDER BY db_id ASC LIMIT 50000");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("UPDATE scan SET rescan = FALSE, height = 0, validate = FALSE");){
                this.isScanning = true;
                this.initialScanHeight = this.blockchain.getHeight();
                if (n > this.blockchain.getHeight() + 1) {
                    Logger.logMessage("Rollback height " + (n - 1) + " exceeds current blockchain height of " + this.blockchain.getHeight() + ", no scan needed");
                    preparedStatement2.executeUpdate();
                    Db.db.commitTransaction();
                    return;
                }
                if (n == 0) {
                    Logger.logDebugMessage("Dropping all full text search indexes");
                    FullTextTrigger.dropAll(connection);
                    this.lastTrimHeight = 0;
                }
                for (DerivedDbTable derivedDbTable : this.derivedTables) {
                    if (n == 0) {
                        derivedDbTable.truncate();
                        continue;
                    }
                    derivedDbTable.rollback(n - 1);
                }
                Db.db.clearCache();
                Db.db.commitTransaction();
                Logger.logDebugMessage("Rolled back derived tables");
                Object object = BlockDb.findBlockAtHeight(n);
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_BEGIN);
                long l = ((BlockImpl)object).getId();
                if (n == 0) {
                    this.blockchain.setLastBlock((BlockImpl)object);
                    Account.addOrGetAccount(1739068987193023818L).apply(Genesis.CREATOR_PUBLIC_KEY);
                } else {
                    this.blockchain.setLastBlock(BlockDb.findBlockAtHeight(n - 1));
                }
                if (bl2) {
                    Logger.logMessage("Scan will be performed at next start");
                    new Thread(() -> System.exit(0)).start();
                    return;
                }
                int n2 = 1;
                if (n > 0) {
                    preparedStatement.setInt(n2++, n);
                }
                long l2 = Long.MIN_VALUE;
                boolean bl3 = true;
                block78: while (bl3) {
                    bl3 = false;
                    preparedStatement.setLong(n2, l2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (resultSet.next()) {
                            Object object2;
                            try {
                                l2 = resultSet.getLong("db_id");
                                object = BlockDb.loadBlock(connection, resultSet, true);
                                ((BlockImpl)object).loadTransactions();
                                if (((BlockImpl)object).getId() != l) throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                if (((BlockImpl)object).getHeight() > this.blockchain.getHeight() + 1) {
                                    throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                }
                                int n3 = Nxt.getEpochTime();
                                object2 = new HashMap();
                                ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
                                ArrayList<TransactionImpl> arrayList2 = new ArrayList<TransactionImpl>();
                                this.validatePhasedTransactions(this.blockchain.getHeight(), arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                if (l != 2680262203532249785L) {
                                    this.validateTransactions((BlockImpl)object, this.blockchain.getLastBlock(), n3, (Map<TransactionType, Map<String, Integer>>)object2, bl);
                                }
                                if (bl && l != 2680262203532249785L) {
                                    this.validate((BlockImpl)object, this.blockchain.getLastBlock(), n3);
                                    byte[] byArray = ((BlockImpl)object).bytes();
                                    JSONObject jSONObject = (JSONObject)JSONValue.parse((String)((BlockImpl)object).getJSONObject().toJSONString());
                                    if (!Arrays.equals(byArray, BlockImpl.parseBlock(jSONObject).bytes())) {
                                        throw new NxtException.NotValidException("Block JSON cannot be parsed back to the same block");
                                    }
                                    for (TransactionImpl transactionImpl : ((BlockImpl)object).getTransactions()) {
                                        byte[] byArray2 = transactionImpl.bytes();
                                        if (((BlockImpl)object).getHeight() > Constants.NQT_BLOCK && !Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(byArray2).build().bytes())) {
                                            throw new NxtException.NotValidException("Transaction bytes cannot be parsed back to the same transaction: " + transactionImpl.getJSONObject().toJSONString());
                                        }
                                        JSONObject jSONObject2 = (JSONObject)JSONValue.parse((String)transactionImpl.getJSONObject().toJSONString());
                                        if (Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(jSONObject2).build().bytes())) continue;
                                        throw new NxtException.NotValidException("Transaction JSON cannot be parsed back to the same transaction: " + transactionImpl.getJSONObject().toJSONString());
                                    }
                                }
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                                this.blockchain.setLastBlock((BlockImpl)object);
                                this.accept((BlockImpl)object, arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                Db.db.clearCache();
                                Db.db.commitTransaction();
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BLOCK_SCANNED);
                                bl3 = true;
                                l = ((BlockImpl)object).getNextBlockId();
                            }
                            catch (RuntimeException | NxtException exception) {
                                Db.db.rollbackTransaction();
                                Logger.logDebugMessage(exception.toString(), exception);
                                Logger.logDebugMessage("Applying block " + Long.toUnsignedString(l) + " at height " + ((BlockImpl)object).getHeight() + " failed, deleting from database");
                                object2 = BlockDb.deleteBlocksFrom(l);
                                this.blockchain.setLastBlock((BlockImpl)object2);
                                this.popOffTo((Block)object2);
                                if (resultSet == null) break block78;
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block78;
                                }
                                resultSet.close();
                                break block78;
                            }
                        }
                        ++l2;
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
                if (n == 0) {
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.createSearchIndex(connection);
                    }
                }
                preparedStatement2.executeUpdate();
                Db.db.commitTransaction();
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_END);
                Logger.logMessage("...done at height " + this.blockchain.getHeight());
                if (n == 0 && bl) {
                    Logger.logMessage("SUCCESSFULLY PERFORMED FULL RESCAN WITH VALIDATION");
                }
                this.lastRestoreTime = 0;
                return;
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            finally {
                this.isScanning = false;
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        byte[] byArray8;
        byte[] byArray9;
        byte[] byArray10;
        byte[] byArray11;
        byte[] byArray12;
        byte[] byArray13;
        byte[] byArray14;
        byte[] byArray15;
        byte[] byArray16;
        byte[] byArray17;
        TreeMap<Integer, byte[]> treeMap = new TreeMap<Integer, byte[]>();
        treeMap.put(0, null);
        treeMap.put(Constants.TRANSPARENT_FORGING_BLOCK, new byte[]{-122, -111, -35, 76, 59, 79, -75, 117, 34, 2, -70, -65, -38, 59, 0, 57, 120, 0, -107, 11, 97, -48, 21, 36, 48, -94, 88, 54, -14, 60, -101, -80});
        Integer n = Constants.NQT_BLOCK;
        if (Constants.isTestnet) {
            byte[] byArray18 = new byte[32];
            byArray18[0] = -107;
            byArray18[1] = -59;
            byArray18[2] = 50;
            byArray18[3] = -54;
            byArray18[4] = 78;
            byArray18[5] = -8;
            byArray18[6] = -125;
            byArray18[7] = 121;
            byArray18[8] = -13;
            byArray18[9] = -43;
            byArray18[10] = -57;
            byArray18[11] = -76;
            byArray18[12] = 100;
            byArray18[13] = 35;
            byArray18[14] = -125;
            byArray18[15] = -74;
            byArray18[16] = 32;
            byArray18[17] = -40;
            byArray18[18] = 82;
            byArray18[19] = -4;
            byArray18[20] = 39;
            byArray18[21] = -28;
            byArray18[22] = -115;
            byArray18[23] = 68;
            byArray18[24] = -37;
            byArray18[25] = -66;
            byArray18[26] = -48;
            byArray18[27] = 18;
            byArray18[28] = -82;
            byArray18[29] = -105;
            byArray18[30] = 46;
            byArray17 = byArray18;
            byArray18[31] = 27;
        } else {
            byte[] byArray19 = new byte[32];
            byArray19[0] = 100;
            byArray19[1] = 53;
            byArray19[2] = 55;
            byArray19[3] = 64;
            byArray19[4] = 31;
            byArray19[5] = 3;
            byArray19[6] = -110;
            byArray19[7] = 0;
            byArray19[8] = -109;
            byArray19[9] = -18;
            byArray19[10] = -71;
            byArray19[11] = 59;
            byArray19[12] = 27;
            byArray19[13] = -102;
            byArray19[14] = 107;
            byArray19[15] = 29;
            byArray19[16] = -95;
            byArray19[17] = -24;
            byArray19[18] = 8;
            byArray19[19] = 103;
            byArray19[20] = -23;
            byArray19[21] = 58;
            byArray19[22] = 118;
            byArray19[23] = 39;
            byArray19[24] = 77;
            byArray19[25] = -54;
            byArray19[26] = -70;
            byArray19[27] = 38;
            byArray19[28] = -112;
            byArray19[29] = 95;
            byArray19[30] = -38;
            byArray17 = byArray19;
            byArray19[31] = 78;
        }
        treeMap.put(n, byArray17);
        Integer n2 = Constants.MONETARY_SYSTEM_BLOCK;
        if (Constants.isTestnet) {
            byte[] byArray20 = new byte[32];
            byArray20[0] = 116;
            byArray20[1] = 120;
            byArray20[2] = -28;
            byArray20[3] = -75;
            byArray20[4] = -6;
            byArray20[5] = -5;
            byArray20[6] = -32;
            byArray20[7] = 85;
            byArray20[8] = 121;
            byArray20[9] = -85;
            byArray20[10] = 19;
            byArray20[11] = 57;
            byArray20[12] = 33;
            byArray20[13] = -46;
            byArray20[14] = -73;
            byArray20[15] = 22;
            byArray20[16] = 113;
            byArray20[17] = -123;
            byArray20[18] = 37;
            byArray20[19] = -89;
            byArray20[20] = 16;
            byArray20[21] = -11;
            byArray20[22] = -67;
            byArray20[23] = -72;
            byArray20[24] = 125;
            byArray20[25] = -66;
            byArray20[26] = -96;
            byArray20[27] = -67;
            byArray20[28] = 24;
            byArray20[29] = -85;
            byArray20[30] = 19;
            byArray16 = byArray20;
            byArray20[31] = 74;
        } else {
            byte[] byArray21 = new byte[32];
            byArray21[0] = -66;
            byArray21[1] = -111;
            byArray21[2] = -19;
            byArray21[3] = -122;
            byArray21[4] = -109;
            byArray21[5] = 50;
            byArray21[6] = -79;
            byArray21[7] = 93;
            byArray21[8] = -81;
            byArray21[9] = 38;
            byArray21[10] = -41;
            byArray21[11] = -51;
            byArray21[12] = -8;
            byArray21[13] = 68;
            byArray21[14] = -53;
            byArray21[15] = -102;
            byArray21[16] = 4;
            byArray21[17] = 15;
            byArray21[18] = -29;
            byArray21[19] = -114;
            byArray21[20] = -25;
            byArray21[21] = -6;
            byArray21[22] = 60;
            byArray21[23] = -20;
            byArray21[24] = 100;
            byArray21[25] = 43;
            byArray21[26] = -113;
            byArray21[27] = 29;
            byArray21[28] = -97;
            byArray21[29] = 73;
            byArray21[30] = -73;
            byArray16 = byArray21;
            byArray21[31] = 21;
        }
        treeMap.put(n2, byArray16);
        Integer n3 = Constants.PHASING_BLOCK;
        if (Constants.isTestnet) {
            byte[] byArray22 = new byte[32];
            byArray22[0] = 121;
            byArray22[1] = 27;
            byArray22[2] = -60;
            byArray22[3] = 121;
            byArray22[4] = -90;
            byArray22[5] = -82;
            byArray22[6] = 38;
            byArray22[7] = -30;
            byArray22[8] = 24;
            byArray22[9] = -47;
            byArray22[10] = 54;
            byArray22[11] = -78;
            byArray22[12] = -98;
            byArray22[13] = -118;
            byArray22[14] = -47;
            byArray22[15] = -76;
            byArray22[16] = -22;
            byArray22[17] = 10;
            byArray22[18] = -123;
            byArray22[19] = 29;
            byArray22[20] = -47;
            byArray22[21] = 111;
            byArray22[22] = 120;
            byArray22[23] = 25;
            byArray22[24] = -53;
            byArray22[25] = 104;
            byArray22[26] = 46;
            byArray22[27] = -122;
            byArray22[28] = -48;
            byArray22[29] = -77;
            byArray22[30] = -54;
            byArray15 = byArray22;
            byArray22[31] = -106;
        } else {
            byte[] byArray23 = new byte[32];
            byArray23[0] = 5;
            byArray23[1] = -83;
            byArray23[2] = -113;
            byArray23[3] = -76;
            byArray23[4] = 59;
            byArray23[5] = 125;
            byArray23[6] = -32;
            byArray23[7] = 19;
            byArray23[8] = -59;
            byArray23[9] = 79;
            byArray23[10] = 120;
            byArray23[11] = 117;
            byArray23[12] = 62;
            byArray23[13] = -76;
            byArray23[14] = -9;
            byArray23[15] = -98;
            byArray23[16] = -127;
            byArray23[17] = 28;
            byArray23[18] = 86;
            byArray23[19] = -114;
            byArray23[20] = -106;
            byArray23[21] = 43;
            byArray23[22] = -70;
            byArray23[23] = -18;
            byArray23[24] = -2;
            byArray23[25] = 17;
            byArray23[26] = 83;
            byArray23[27] = 35;
            byArray23[28] = -62;
            byArray23[29] = -7;
            byArray23[30] = 73;
            byArray15 = byArray23;
            byArray23[31] = 112;
        }
        treeMap.put(n3, byArray15);
        Integer n4 = Constants.CHECKSUM_BLOCK_16;
        if (Constants.isTestnet) {
            byte[] byArray24 = new byte[32];
            byArray24[0] = -103;
            byArray24[1] = -91;
            byArray24[2] = 78;
            byArray24[3] = 93;
            byArray24[4] = -94;
            byArray24[5] = -57;
            byArray24[6] = 51;
            byArray24[7] = -75;
            byArray24[8] = 118;
            byArray24[9] = -66;
            byArray24[10] = 33;
            byArray24[11] = 21;
            byArray24[12] = -108;
            byArray24[13] = 33;
            byArray24[14] = 127;
            byArray24[15] = 103;
            byArray24[16] = -59;
            byArray24[17] = -88;
            byArray24[18] = -128;
            byArray24[19] = -34;
            byArray24[20] = -11;
            byArray24[21] = -55;
            byArray24[22] = 5;
            byArray24[23] = -83;
            byArray24[24] = -104;
            byArray24[25] = 48;
            byArray24[26] = -46;
            byArray24[27] = -56;
            byArray24[28] = 79;
            byArray24[29] = -43;
            byArray24[30] = 54;
            byArray14 = byArray24;
            byArray24[31] = 53;
        } else {
            byte[] byArray25 = new byte[32];
            byArray25[0] = 77;
            byArray25[1] = -31;
            byArray25[2] = 73;
            byArray25[3] = 24;
            byArray25[4] = -4;
            byArray25[5] = -38;
            byArray25[6] = -65;
            byArray25[7] = -38;
            byArray25[8] = 109;
            byArray25[9] = -18;
            byArray25[10] = -33;
            byArray25[11] = -74;
            byArray25[12] = 77;
            byArray25[13] = -71;
            byArray25[14] = -67;
            byArray25[15] = -85;
            byArray25[16] = 37;
            byArray25[17] = 89;
            byArray25[18] = 101;
            byArray25[19] = -29;
            byArray25[20] = -110;
            byArray25[21] = 18;
            byArray25[22] = 59;
            byArray25[23] = -128;
            byArray25[24] = 83;
            byArray25[25] = 89;
            byArray25[26] = 92;
            byArray25[27] = -54;
            byArray25[28] = -71;
            byArray25[29] = 48;
            byArray25[30] = -4;
            byArray14 = byArray25;
            byArray25[31] = -97;
        }
        treeMap.put(n4, byArray14);
        Integer n5 = Constants.CHECKSUM_BLOCK_17;
        if (Constants.isTestnet) {
            byte[] byArray26 = new byte[32];
            byArray26[0] = 123;
            byArray26[1] = -114;
            byArray26[2] = -84;
            byArray26[3] = -30;
            byArray26[4] = 35;
            byArray26[5] = -15;
            byArray26[6] = 15;
            byArray26[7] = 58;
            byArray26[8] = 48;
            byArray26[9] = 27;
            byArray26[10] = 88;
            byArray26[11] = 110;
            byArray26[12] = 127;
            byArray26[13] = 110;
            byArray26[14] = -15;
            byArray26[15] = -79;
            byArray26[16] = -48;
            byArray26[17] = -61;
            byArray26[18] = 54;
            byArray26[19] = 10;
            byArray26[20] = 50;
            byArray26[21] = 97;
            byArray26[22] = 121;
            byArray26[23] = -4;
            byArray26[24] = 70;
            byArray26[25] = 103;
            byArray26[26] = 40;
            byArray26[27] = 78;
            byArray26[28] = 7;
            byArray26[29] = -27;
            byArray26[30] = 119;
            byArray13 = byArray26;
            byArray26[31] = 112;
        } else {
            byte[] byArray27 = new byte[32];
            byArray27[0] = -88;
            byArray27[1] = 29;
            byArray27[2] = -104;
            byArray27[3] = -26;
            byArray27[4] = -23;
            byArray27[5] = 51;
            byArray27[6] = 120;
            byArray27[7] = -48;
            byArray27[8] = 92;
            byArray27[9] = -87;
            byArray27[10] = -122;
            byArray27[11] = 10;
            byArray27[12] = 6;
            byArray27[13] = 66;
            byArray27[14] = 1;
            byArray27[15] = 70;
            byArray27[16] = -97;
            byArray27[17] = -55;
            byArray27[18] = -88;
            byArray27[19] = 65;
            byArray27[20] = -39;
            byArray27[21] = -68;
            byArray27[22] = -113;
            byArray27[23] = 1;
            byArray27[24] = -114;
            byArray27[25] = 23;
            byArray27[26] = 119;
            byArray27[27] = -43;
            byArray27[28] = 13;
            byArray27[29] = -40;
            byArray27[30] = -77;
            byArray13 = byArray27;
            byArray27[31] = -79;
        }
        treeMap.put(n5, byArray13);
        Integer n6 = Constants.CHECKSUM_BLOCK_18;
        if (Constants.isTestnet) {
            byte[] byArray28 = new byte[32];
            byArray28[0] = 12;
            byArray28[1] = -98;
            byArray28[2] = -32;
            byArray28[3] = -18;
            byArray28[4] = -27;
            byArray28[5] = 53;
            byArray28[6] = -72;
            byArray28[7] = -87;
            byArray28[8] = 11;
            byArray28[9] = -119;
            byArray28[10] = 69;
            byArray28[11] = 126;
            byArray28[12] = -59;
            byArray28[13] = 80;
            byArray28[14] = -17;
            byArray28[15] = -12;
            byArray28[16] = -122;
            byArray28[17] = 114;
            byArray28[18] = 14;
            byArray28[19] = -120;
            byArray28[20] = 114;
            byArray28[21] = -53;
            byArray28[22] = -8;
            byArray28[23] = 33;
            byArray28[24] = -90;
            byArray28[25] = 25;
            byArray28[26] = 57;
            byArray28[27] = -75;
            byArray28[28] = 60;
            byArray28[29] = 9;
            byArray28[30] = -1;
            byArray12 = byArray28;
            byArray28[31] = -99;
        } else {
            byte[] byArray29 = new byte[32];
            byArray29[0] = 52;
            byArray29[1] = 91;
            byArray29[2] = 45;
            byArray29[3] = 66;
            byArray29[4] = 87;
            byArray29[5] = -88;
            byArray29[6] = 35;
            byArray29[7] = -58;
            byArray29[8] = 44;
            byArray29[9] = -78;
            byArray29[10] = -52;
            byArray29[11] = 40;
            byArray29[12] = -100;
            byArray29[13] = 46;
            byArray29[14] = -127;
            byArray29[15] = -127;
            byArray29[16] = 103;
            byArray29[17] = 104;
            byArray29[18] = -51;
            byArray29[19] = 30;
            byArray29[20] = 40;
            byArray29[21] = 57;
            byArray29[22] = 89;
            byArray29[23] = 104;
            byArray29[24] = 44;
            byArray29[25] = -119;
            byArray29[26] = 47;
            byArray29[27] = 63;
            byArray29[28] = -47;
            byArray29[29] = 1;
            byArray29[30] = 79;
            byArray12 = byArray29;
            byArray29[31] = 108;
        }
        treeMap.put(n6, byArray12);
        Integer n7 = Constants.CHECKSUM_BLOCK_19;
        if (Constants.isTestnet) {
            byte[] byArray30 = new byte[32];
            byArray30[0] = -52;
            byArray30[1] = -86;
            byArray30[2] = 109;
            byArray30[3] = 11;
            byArray30[4] = -86;
            byArray30[5] = 25;
            byArray30[6] = 4;
            byArray30[7] = -103;
            byArray30[8] = 1;
            byArray30[9] = -23;
            byArray30[10] = 62;
            byArray30[11] = 100;
            byArray30[12] = 10;
            byArray30[13] = -33;
            byArray30[14] = -100;
            byArray30[15] = 50;
            byArray30[16] = 7;
            byArray30[17] = -105;
            byArray30[18] = 33;
            byArray30[19] = 9;
            byArray30[20] = 72;
            byArray30[21] = -31;
            byArray30[22] = 119;
            byArray30[23] = 111;
            byArray30[24] = 99;
            byArray30[25] = 56;
            byArray30[26] = -64;
            byArray30[27] = -16;
            byArray30[28] = -80;
            byArray30[29] = -19;
            byArray30[30] = 121;
            byArray11 = byArray30;
            byArray30[31] = 31;
        } else {
            byte[] byArray31 = new byte[32];
            byArray31[0] = -117;
            byArray31[1] = 52;
            byArray31[2] = 50;
            byArray31[3] = -104;
            byArray31[4] = -114;
            byArray31[5] = 30;
            byArray31[6] = -43;
            byArray31[7] = -68;
            byArray31[8] = 88;
            byArray31[9] = 117;
            byArray31[10] = -122;
            byArray31[11] = 70;
            byArray31[12] = -120;
            byArray31[13] = 57;
            byArray31[14] = -21;
            byArray31[15] = -100;
            byArray31[16] = -69;
            byArray31[17] = -2;
            byArray31[18] = -94;
            byArray31[19] = 85;
            byArray31[20] = 125;
            byArray31[21] = -6;
            byArray31[22] = -95;
            byArray31[23] = -31;
            byArray31[24] = -49;
            byArray31[25] = -98;
            byArray31[26] = -46;
            byArray31[27] = 114;
            byArray31[28] = -101;
            byArray31[29] = 105;
            byArray31[30] = 43;
            byArray11 = byArray31;
            byArray31[31] = 115;
        }
        treeMap.put(n7, byArray11);
        Integer n8 = Constants.CHECKSUM_BLOCK_20;
        if (Constants.isTestnet) {
            byte[] byArray32 = new byte[32];
            byArray32[0] = -123;
            byArray32[1] = -27;
            byArray32[2] = -29;
            byArray32[3] = 71;
            byArray32[4] = -26;
            byArray32[5] = 83;
            byArray32[6] = -122;
            byArray32[7] = -2;
            byArray32[8] = 118;
            byArray32[9] = -41;
            byArray32[10] = 60;
            byArray32[11] = 0;
            byArray32[12] = -76;
            byArray32[13] = 103;
            byArray32[14] = 63;
            byArray32[15] = -96;
            byArray32[16] = -80;
            byArray32[17] = 46;
            byArray32[18] = -27;
            byArray32[19] = 80;
            byArray32[20] = 114;
            byArray32[21] = -42;
            byArray32[22] = -23;
            byArray32[23] = 118;
            byArray32[24] = 17;
            byArray32[25] = -47;
            byArray32[26] = 28;
            byArray32[27] = 7;
            byArray32[28] = -103;
            byArray32[29] = -123;
            byArray32[30] = 4;
            byArray10 = byArray32;
            byArray32[31] = 90;
        } else {
            byte[] byArray33 = new byte[32];
            byArray33[0] = -112;
            byArray33[1] = 90;
            byArray33[2] = -83;
            byArray33[3] = -125;
            byArray33[4] = 96;
            byArray33[5] = 91;
            byArray33[6] = 90;
            byArray33[7] = 18;
            byArray33[8] = -73;
            byArray33[9] = -16;
            byArray33[10] = 36;
            byArray33[11] = -58;
            byArray33[12] = 70;
            byArray33[13] = 92;
            byArray33[14] = -16;
            byArray33[15] = -93;
            byArray33[16] = -62;
            byArray33[17] = 113;
            byArray33[18] = -16;
            byArray33[19] = 6;
            byArray33[20] = 7;
            byArray33[21] = 28;
            byArray33[22] = -68;
            byArray33[23] = -101;
            byArray33[24] = 48;
            byArray33[25] = 108;
            byArray33[26] = 24;
            byArray33[27] = -20;
            byArray33[28] = 72;
            byArray33[29] = 35;
            byArray33[30] = -93;
            byArray10 = byArray33;
            byArray33[31] = -74;
        }
        treeMap.put(n8, byArray10);
        Integer n9 = Constants.CHECKSUM_BLOCK_21;
        if (Constants.isTestnet) {
            byte[] byArray34 = new byte[32];
            byArray34[0] = 52;
            byArray34[1] = -119;
            byArray34[2] = 35;
            byArray34[3] = 54;
            byArray34[4] = -126;
            byArray34[5] = -69;
            byArray34[6] = 103;
            byArray34[7] = -114;
            byArray34[8] = -36;
            byArray34[9] = -58;
            byArray34[10] = 78;
            byArray34[11] = 118;
            byArray34[12] = -86;
            byArray34[13] = 26;
            byArray34[14] = -50;
            byArray34[15] = -17;
            byArray34[16] = -95;
            byArray34[17] = -86;
            byArray34[18] = 62;
            byArray34[19] = 45;
            byArray34[20] = -20;
            byArray34[21] = 119;
            byArray34[22] = 45;
            byArray34[23] = 5;
            byArray34[24] = -128;
            byArray34[25] = 48;
            byArray34[26] = 117;
            byArray34[27] = -12;
            byArray34[28] = -16;
            byArray34[29] = 56;
            byArray34[30] = -121;
            byArray9 = byArray34;
            byArray34[31] = 76;
        } else {
            byte[] byArray35 = new byte[32];
            byArray35[0] = 86;
            byArray35[1] = 57;
            byArray35[2] = -46;
            byArray35[3] = -107;
            byArray35[4] = -63;
            byArray35[5] = 10;
            byArray35[6] = 1;
            byArray35[7] = 7;
            byArray35[8] = -89;
            byArray35[9] = 121;
            byArray35[10] = -26;
            byArray35[11] = -30;
            byArray35[12] = -67;
            byArray35[13] = -121;
            byArray35[14] = 40;
            byArray35[15] = 119;
            byArray35[16] = 13;
            byArray35[17] = -52;
            byArray35[18] = -11;
            byArray35[19] = -72;
            byArray35[20] = -97;
            byArray35[21] = -99;
            byArray35[22] = 44;
            byArray35[23] = -96;
            byArray35[24] = 19;
            byArray35[25] = -23;
            byArray35[26] = -15;
            byArray35[27] = -79;
            byArray35[28] = 95;
            byArray35[29] = -55;
            byArray35[30] = 37;
            byArray9 = byArray35;
            byArray35[31] = -122;
        }
        treeMap.put(n9, byArray9);
        Integer n10 = Constants.CHECKSUM_BLOCK_22;
        if (Constants.isTestnet) {
            byte[] byArray36 = new byte[32];
            byArray36[0] = 85;
            byArray36[1] = -115;
            byArray36[2] = -89;
            byArray36[3] = -71;
            byArray36[4] = 121;
            byArray36[5] = -71;
            byArray36[6] = -101;
            byArray36[7] = 75;
            byArray36[8] = 71;
            byArray36[9] = 99;
            byArray36[10] = -112;
            byArray36[11] = -58;
            byArray36[12] = 109;
            byArray36[13] = -121;
            byArray36[14] = -24;
            byArray36[15] = 101;
            byArray36[16] = -110;
            byArray36[17] = 83;
            byArray36[18] = -33;
            byArray36[19] = -38;
            byArray36[20] = 72;
            byArray36[21] = 4;
            byArray36[22] = -76;
            byArray36[23] = 106;
            byArray36[24] = -12;
            byArray36[25] = -31;
            byArray36[26] = -44;
            byArray36[27] = -81;
            byArray36[28] = 105;
            byArray36[29] = -65;
            byArray36[30] = 117;
            byArray8 = byArray36;
            byArray36[31] = 36;
        } else {
            byte[] byArray37 = new byte[32];
            byArray37[0] = -58;
            byArray37[1] = -89;
            byArray37[2] = -6;
            byArray37[3] = -56;
            byArray37[4] = -22;
            byArray37[5] = -8;
            byArray37[6] = -126;
            byArray37[7] = 68;
            byArray37[8] = 103;
            byArray37[9] = -50;
            byArray37[10] = 113;
            byArray37[11] = 112;
            byArray37[12] = -70;
            byArray37[13] = 94;
            byArray37[14] = 17;
            byArray37[15] = -117;
            byArray37[16] = 71;
            byArray37[17] = 31;
            byArray37[18] = -21;
            byArray37[19] = 97;
            byArray37[20] = 22;
            byArray37[21] = -13;
            byArray37[22] = -98;
            byArray37[23] = -88;
            byArray37[24] = -32;
            byArray37[25] = 82;
            byArray37[26] = -116;
            byArray37[27] = -123;
            byArray37[28] = -15;
            byArray37[29] = -125;
            byArray37[30] = 15;
            byArray8 = byArray37;
            byArray37[31] = 127;
        }
        treeMap.put(n10, byArray8);
        Integer n11 = Constants.CHECKSUM_BLOCK_23;
        if (Constants.isTestnet) {
            byte[] byArray38 = new byte[32];
            byArray38[0] = 70;
            byArray38[1] = 50;
            byArray38[2] = -31;
            byArray38[3] = 25;
            byArray38[4] = -5;
            byArray38[5] = 67;
            byArray38[6] = -99;
            byArray38[7] = 72;
            byArray38[8] = -113;
            byArray38[9] = -118;
            byArray38[10] = -8;
            byArray38[11] = 26;
            byArray38[12] = -93;
            byArray38[13] = 122;
            byArray38[14] = 102;
            byArray38[15] = -19;
            byArray38[16] = -20;
            byArray38[17] = 52;
            byArray38[18] = -111;
            byArray38[19] = 52;
            byArray38[20] = -30;
            byArray38[21] = 107;
            byArray38[22] = 67;
            byArray38[23] = -114;
            byArray38[24] = -12;
            byArray38[25] = 62;
            byArray38[26] = 89;
            byArray38[27] = -82;
            byArray38[28] = 56;
            byArray38[29] = 9;
            byArray38[30] = 124;
            byArray7 = byArray38;
            byArray38[31] = -56;
        } else {
            byte[] byArray39 = new byte[32];
            byArray39[0] = -105;
            byArray39[1] = -57;
            byArray39[2] = -41;
            byArray39[3] = -102;
            byArray39[4] = 46;
            byArray39[5] = -47;
            byArray39[6] = -114;
            byArray39[7] = 28;
            byArray39[8] = 54;
            byArray39[9] = -72;
            byArray39[10] = 7;
            byArray39[11] = 83;
            byArray39[12] = 107;
            byArray39[13] = -56;
            byArray39[14] = 36;
            byArray39[15] = 111;
            byArray39[16] = 68;
            byArray39[17] = 3;
            byArray39[18] = 103;
            byArray39[19] = 112;
            byArray39[20] = -108;
            byArray39[21] = 121;
            byArray39[22] = 49;
            byArray39[23] = -116;
            byArray39[24] = -32;
            byArray39[25] = -42;
            byArray39[26] = -22;
            byArray39[27] = -97;
            byArray39[28] = -62;
            byArray39[29] = 104;
            byArray39[30] = 93;
            byArray7 = byArray39;
            byArray39[31] = -98;
        }
        treeMap.put(n11, byArray7);
        Integer n12 = Constants.CHECKSUM_BLOCK_24;
        if (Constants.isTestnet) {
            byte[] byArray40 = new byte[32];
            byArray40[0] = 29;
            byArray40[1] = 90;
            byArray40[2] = -41;
            byArray40[3] = -73;
            byArray40[4] = -96;
            byArray40[5] = -63;
            byArray40[6] = 75;
            byArray40[7] = 57;
            byArray40[8] = 81;
            byArray40[9] = -36;
            byArray40[10] = 14;
            byArray40[11] = 23;
            byArray40[12] = -5;
            byArray40[13] = -90;
            byArray40[14] = 2;
            byArray40[15] = 59;
            byArray40[16] = 6;
            byArray40[17] = -45;
            byArray40[18] = 112;
            byArray40[19] = -9;
            byArray40[20] = 93;
            byArray40[21] = -89;
            byArray40[22] = 126;
            byArray40[23] = -89;
            byArray40[24] = -87;
            byArray40[25] = 99;
            byArray40[26] = 1;
            byArray40[27] = -58;
            byArray40[28] = 0;
            byArray40[29] = 12;
            byArray40[30] = -102;
            byArray6 = byArray40;
            byArray40[31] = 98;
        } else {
            byte[] byArray41 = new byte[32];
            byArray41[0] = 80;
            byArray41[1] = -26;
            byArray41[2] = 69;
            byArray41[3] = -49;
            byArray41[4] = -22;
            byArray41[5] = 83;
            byArray41[6] = 97;
            byArray41[7] = -60;
            byArray41[8] = 112;
            byArray41[9] = -57;
            byArray41[10] = -89;
            byArray41[11] = 31;
            byArray41[12] = -77;
            byArray41[13] = 50;
            byArray41[14] = -61;
            byArray41[15] = -48;
            byArray41[16] = 19;
            byArray41[17] = -72;
            byArray41[18] = 69;
            byArray41[19] = -95;
            byArray41[20] = 74;
            byArray41[21] = -18;
            byArray41[22] = -96;
            byArray41[23] = 76;
            byArray41[24] = -92;
            byArray41[25] = -15;
            byArray41[26] = -99;
            byArray41[27] = 36;
            byArray41[28] = 107;
            byArray41[29] = -82;
            byArray41[30] = 83;
            byArray6 = byArray41;
            byArray41[31] = 116;
        }
        treeMap.put(n12, byArray6);
        Integer n13 = Constants.CHECKSUM_BLOCK_25;
        if (Constants.isTestnet) {
            byte[] byArray42 = new byte[32];
            byArray42[0] = 90;
            byArray42[1] = 24;
            byArray42[2] = -107;
            byArray42[3] = -99;
            byArray42[4] = -59;
            byArray42[5] = 82;
            byArray42[6] = 82;
            byArray42[7] = -121;
            byArray42[8] = -67;
            byArray42[9] = -39;
            byArray42[10] = -8;
            byArray42[11] = 16;
            byArray42[12] = 123;
            byArray42[13] = 89;
            byArray42[14] = 35;
            byArray42[15] = -5;
            byArray42[16] = 91;
            byArray42[17] = 17;
            byArray42[18] = 12;
            byArray42[19] = -76;
            byArray42[20] = -53;
            byArray42[21] = 122;
            byArray42[22] = -57;
            byArray42[23] = -80;
            byArray42[24] = 6;
            byArray42[25] = -47;
            byArray42[26] = 8;
            byArray42[27] = -118;
            byArray42[28] = 43;
            byArray42[29] = 12;
            byArray42[30] = -81;
            byArray5 = byArray42;
            byArray42[31] = -45;
        } else {
            byte[] byArray43 = new byte[32];
            byArray43[0] = -79;
            byArray43[1] = 50;
            byArray43[2] = -72;
            byArray43[3] = -120;
            byArray43[4] = -3;
            byArray43[5] = -104;
            byArray43[6] = -77;
            byArray43[7] = -52;
            byArray43[8] = 31;
            byArray43[9] = 47;
            byArray43[10] = -2;
            byArray43[11] = 64;
            byArray43[12] = 78;
            byArray43[13] = 77;
            byArray43[14] = 122;
            byArray43[15] = 43;
            byArray43[16] = -23;
            byArray43[17] = -94;
            byArray43[18] = 53;
            byArray43[19] = -99;
            byArray43[20] = 112;
            byArray43[21] = -128;
            byArray43[22] = 52;
            byArray43[23] = -54;
            byArray43[24] = 37;
            byArray43[25] = 7;
            byArray43[26] = 25;
            byArray43[27] = -23;
            byArray43[28] = -90;
            byArray43[29] = -8;
            byArray43[30] = 99;
            byArray5 = byArray43;
            byArray43[31] = -65;
        }
        treeMap.put(n13, byArray5);
        Integer n14 = Constants.CHECKSUM_BLOCK_26;
        if (Constants.isTestnet) {
            byte[] byArray44 = new byte[32];
            byArray44[0] = 123;
            byArray44[1] = -28;
            byArray44[2] = 86;
            byArray44[3] = 33;
            byArray44[4] = 21;
            byArray44[5] = 38;
            byArray44[6] = 116;
            byArray44[7] = -100;
            byArray44[8] = 39;
            byArray44[9] = 6;
            byArray44[10] = -12;
            byArray44[11] = -74;
            byArray44[12] = 18;
            byArray44[13] = -71;
            byArray44[14] = 95;
            byArray44[15] = 44;
            byArray44[16] = -103;
            byArray44[17] = -22;
            byArray44[18] = -109;
            byArray44[19] = -13;
            byArray44[20] = -103;
            byArray44[21] = 73;
            byArray44[22] = -26;
            byArray44[23] = 100;
            byArray44[24] = 74;
            byArray44[25] = 6;
            byArray44[26] = 35;
            byArray44[27] = -37;
            byArray44[28] = -108;
            byArray44[29] = 68;
            byArray44[30] = 73;
            byArray4 = byArray44;
            byArray44[31] = 17;
        } else {
            byte[] byArray45 = new byte[32];
            byArray45[0] = -85;
            byArray45[1] = 58;
            byArray45[2] = 123;
            byArray45[3] = -14;
            byArray45[4] = 80;
            byArray45[5] = -34;
            byArray45[6] = -109;
            byArray45[7] = -78;
            byArray45[8] = -92;
            byArray45[9] = 86;
            byArray45[10] = 62;
            byArray45[11] = 2;
            byArray45[12] = -14;
            byArray45[13] = -36;
            byArray45[14] = 41;
            byArray45[15] = -13;
            byArray45[16] = -56;
            byArray45[17] = 50;
            byArray45[18] = 17;
            byArray45[19] = -18;
            byArray45[20] = 44;
            byArray45[21] = -31;
            byArray45[22] = -34;
            byArray45[23] = 56;
            byArray45[24] = 113;
            byArray45[25] = -11;
            byArray45[26] = -74;
            byArray45[27] = 98;
            byArray45[28] = 32;
            byArray45[29] = -87;
            byArray45[30] = -9;
            byArray4 = byArray45;
            byArray45[31] = -87;
        }
        treeMap.put(n14, byArray4);
        Integer n15 = Constants.CHECKSUM_BLOCK_27;
        if (Constants.isTestnet) {
            byte[] byArray46 = new byte[32];
            byArray46[0] = -61;
            byArray46[1] = -118;
            byArray46[2] = -76;
            byArray46[3] = 124;
            byArray46[4] = -66;
            byArray46[5] = -86;
            byArray46[6] = -8;
            byArray46[7] = 96;
            byArray46[8] = -102;
            byArray46[9] = 51;
            byArray46[10] = 97;
            byArray46[11] = -36;
            byArray46[12] = -81;
            byArray46[13] = -57;
            byArray46[14] = 1;
            byArray46[15] = 7;
            byArray46[16] = -42;
            byArray46[17] = -59;
            byArray46[18] = 50;
            byArray46[19] = -63;
            byArray46[20] = -14;
            byArray46[21] = -23;
            byArray46[22] = -109;
            byArray46[23] = 106;
            byArray46[24] = 86;
            byArray46[25] = 19;
            byArray46[26] = 101;
            byArray46[27] = -89;
            byArray46[28] = -59;
            byArray46[29] = 28;
            byArray46[30] = -30;
            byArray3 = byArray46;
            byArray46[31] = -65;
        } else {
            byte[] byArray47 = new byte[32];
            byArray47[0] = -124;
            byArray47[1] = 127;
            byArray47[2] = -56;
            byArray47[3] = 18;
            byArray47[4] = -49;
            byArray47[5] = -13;
            byArray47[6] = 99;
            byArray47[7] = 43;
            byArray47[8] = 34;
            byArray47[9] = 13;
            byArray47[10] = -118;
            byArray47[11] = -93;
            byArray47[12] = -17;
            byArray47[13] = -128;
            byArray47[14] = 59;
            byArray47[15] = 52;
            byArray47[16] = 41;
            byArray47[17] = -126;
            byArray47[18] = -85;
            byArray47[19] = -40;
            byArray47[20] = 52;
            byArray47[21] = 48;
            byArray47[22] = -13;
            byArray47[23] = 95;
            byArray47[24] = 56;
            byArray47[25] = 52;
            byArray47[26] = 61;
            byArray47[27] = -76;
            byArray47[28] = 105;
            byArray47[29] = -80;
            byArray47[30] = 54;
            byArray3 = byArray47;
            byArray47[31] = -75;
        }
        treeMap.put(n15, byArray3);
        Integer n16 = Constants.CHECKSUM_BLOCK_28;
        if (Constants.isTestnet) {
            byte[] byArray48 = new byte[32];
            byArray48[0] = -65;
            byArray48[1] = 98;
            byArray48[2] = 18;
            byArray48[3] = -77;
            byArray48[4] = 61;
            byArray48[5] = -75;
            byArray48[6] = 48;
            byArray48[7] = -36;
            byArray48[8] = 24;
            byArray48[9] = 109;
            byArray48[10] = 27;
            byArray48[11] = 47;
            byArray48[12] = -34;
            byArray48[13] = 32;
            byArray48[14] = 61;
            byArray48[15] = 123;
            byArray48[16] = 12;
            byArray48[17] = -100;
            byArray48[18] = -37;
            byArray48[19] = 42;
            byArray48[20] = -100;
            byArray48[21] = 6;
            byArray48[22] = -79;
            byArray48[23] = 69;
            byArray48[24] = -56;
            byArray48[25] = 103;
            byArray48[26] = 84;
            byArray48[27] = -57;
            byArray48[28] = -17;
            byArray48[29] = -104;
            byArray48[30] = 126;
            byArray2 = byArray48;
            byArray48[31] = -62;
        } else {
            byte[] byArray49 = new byte[32];
            byArray49[0] = -57;
            byArray49[1] = 55;
            byArray49[2] = 105;
            byArray49[3] = 105;
            byArray49[4] = -67;
            byArray49[5] = -92;
            byArray49[6] = -9;
            byArray49[7] = 121;
            byArray49[8] = 46;
            byArray49[9] = 118;
            byArray49[10] = -106;
            byArray49[11] = -107;
            byArray49[12] = 73;
            byArray49[13] = 20;
            byArray49[14] = -24;
            byArray49[15] = 62;
            byArray49[16] = -60;
            byArray49[17] = 12;
            byArray49[18] = -124;
            byArray49[19] = 50;
            byArray49[20] = 25;
            byArray49[21] = 26;
            byArray49[22] = -88;
            byArray49[23] = -106;
            byArray49[24] = 83;
            byArray49[25] = 46;
            byArray49[26] = 89;
            byArray49[27] = -110;
            byArray49[28] = -104;
            byArray49[29] = 83;
            byArray49[30] = -110;
            byArray2 = byArray49;
            byArray49[31] = -86;
        }
        treeMap.put(n16, byArray2);
        Integer n17 = Constants.CHECKSUM_BLOCK_29;
        if (Constants.isTestnet) {
            byte[] byArray50 = new byte[32];
            byArray50[0] = 124;
            byArray50[1] = 88;
            byArray50[2] = 15;
            byArray50[3] = 103;
            byArray50[4] = -20;
            byArray50[5] = -65;
            byArray50[6] = 8;
            byArray50[7] = -11;
            byArray50[8] = -81;
            byArray50[9] = -98;
            byArray50[10] = -7;
            byArray50[11] = 44;
            byArray50[12] = 126;
            byArray50[13] = 89;
            byArray50[14] = 3;
            byArray50[15] = 104;
            byArray50[16] = 59;
            byArray50[17] = -8;
            byArray50[18] = 121;
            byArray50[19] = 114;
            byArray50[20] = -128;
            byArray50[21] = 5;
            byArray50[22] = -80;
            byArray50[23] = 96;
            byArray50[24] = 25;
            byArray50[25] = 127;
            byArray50[26] = 120;
            byArray50[27] = -10;
            byArray50[28] = 78;
            byArray50[29] = -93;
            byArray50[30] = -57;
            byArray = byArray50;
            byArray50[31] = -88;
        } else {
            byte[] byArray51 = new byte[32];
            byArray51[0] = -12;
            byArray51[1] = 2;
            byArray51[2] = 4;
            byArray51[3] = 109;
            byArray51[4] = 74;
            byArray51[5] = 70;
            byArray51[6] = 77;
            byArray51[7] = 98;
            byArray51[8] = 50;
            byArray51[9] = -76;
            byArray51[10] = 3;
            byArray51[11] = -17;
            byArray51[12] = 47;
            byArray51[13] = 116;
            byArray51[14] = 66;
            byArray51[15] = -52;
            byArray51[16] = -2;
            byArray51[17] = 72;
            byArray51[18] = 28;
            byArray51[19] = -92;
            byArray51[20] = 24;
            byArray51[21] = 114;
            byArray51[22] = -35;
            byArray51[23] = -41;
            byArray51[24] = -57;
            byArray51[25] = -73;
            byArray51[26] = -37;
            byArray51[27] = -9;
            byArray51[28] = 118;
            byArray51[29] = -43;
            byArray51[30] = 86;
            byArray = byArray51;
            byArray51[31] = -41;
        }
        treeMap.put(n17, byArray);
        checksums = Collections.unmodifiableNavigableMap(treeMap);
        instance = new BlockchainProcessorImpl();
        finishingTransactionsComparator = Comparator.comparingInt(Transaction::getHeight).thenComparingInt(Transaction::getIndex).thenComparingLong(Transaction::getId);
        transactionArrivalComparator = Comparator.comparingLong(UnconfirmedTransaction::getArrivalTimestamp).thenComparingInt(UnconfirmedTransaction::getHeight).thenComparingLong(UnconfirmedTransaction::getId);
    }

    private class RestorePrunableDataTask
    implements Runnable {
        private RestorePrunableDataTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Peer peer2 = null;
            try {
                Object object;
                List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && peer.getAnnouncedAddress() != null);
                while (!list.isEmpty()) {
                    if (!Peers.isNetworkingEnabled()) {
                        return;
                    }
                    object = list.get(ThreadLocalRandom.current().nextInt(list.size()));
                    if (object.getState() != Peer.State.CONNECTED) {
                        Peers.connectPeer((Peer)object);
                    }
                    if (object.getState() != Peer.State.CONNECTED) continue;
                    peer2 = object;
                    break;
                }
                if (peer2 == null) {
                    Logger.logDebugMessage("Cannot find any archive peers");
                    return;
                }
                Logger.logDebugMessage("Connected to archive peer " + peer2.getHost());
                Set set = BlockchainProcessorImpl.this.prunableTransactions;
                synchronized (set) {
                    object = new HashSet(BlockchainProcessorImpl.this.prunableTransactions.size());
                    object.addAll(BlockchainProcessorImpl.this.prunableTransactions);
                }
                Logger.logDebugMessage("Need to restore " + object.size() + " pruned data");
                while (!object.isEmpty()) {
                    JSONArray jSONArray;
                    if (!Peers.isNetworkingEnabled()) {
                        Logger.logDebugMessage("Peers networking was disabled while retrieving prunable data");
                        return;
                    }
                    set = new JSONObject();
                    JSONArray jSONArray2 = new JSONArray();
                    Set set2 = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (set2) {
                        jSONArray = object.iterator();
                        while (jSONArray.hasNext()) {
                            long l = (Long)jSONArray.next();
                            jSONArray2.add((Object)Long.toUnsignedString(l));
                            jSONArray.remove();
                            if (jSONArray2.size() != 100) continue;
                            break;
                        }
                    }
                    set.put("requestType", "getTransactions");
                    set.put("transactionIds", jSONArray2);
                    set2 = peer2.send(JSON.prepareRequest((JSONObject)set), 0xA00000);
                    if (set2 == null) {
                        return;
                    }
                    jSONArray = (JSONArray)set2.get("transactions");
                    if (jSONArray == null || jSONArray.isEmpty()) {
                        return;
                    }
                    List<Transaction> list2 = Nxt.getTransactionProcessor().restorePrunableData(jSONArray);
                    Set set3 = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (set3) {
                        list2.forEach(transaction -> BlockchainProcessorImpl.this.prunableTransactions.remove(transaction.getId()));
                    }
                }
                Logger.logDebugMessage("Done retrieving prunable transactions from " + peer2.getHost());
            }
            catch (NxtException.ValidationException validationException) {
                Logger.logErrorMessage("Peer " + peer2.getHost() + " returned invalid prunable transaction", validationException);
                peer2.blacklist(validationException);
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Unable to restore prunable data", runtimeException);
            }
            finally {
                BlockchainProcessorImpl.this.isRestoring = false;
                Logger.logDebugMessage("Remaining " + BlockchainProcessorImpl.this.prunableTransactions.size() + " pruned transactions");
            }
        }
    }

    private static class PeerBlock {
        private final Peer peer;
        private final BlockImpl block;

        public PeerBlock(Peer peer, BlockImpl blockImpl) {
            this.peer = peer;
            this.block = blockImpl;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public BlockImpl getBlock() {
            return this.block;
        }
    }

    private static class GetNextBlocks
    implements Callable<List<BlockImpl>> {
        private Future<List<BlockImpl>> future;
        private Peer peer;
        private final List<Long> blockIds;
        private int start;
        private int stop;
        private int requestCount;
        private long responseTime;

        public GetNextBlocks(List<Long> list, int n, int n2) {
            this.blockIds = list;
            this.start = n;
            this.stop = n2;
            this.requestCount = 0;
        }

        @Override
        public List<BlockImpl> call() {
            ++this.requestCount;
            JSONArray jSONArray = new JSONArray();
            for (int i = this.start + 1; i <= this.stop; ++i) {
                jSONArray.add((Object)Long.toUnsignedString(this.blockIds.get(i)));
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"requestType", (Object)"getNextBlocks");
            jSONObject.put((Object)"blockIds", (Object)jSONArray);
            jSONObject.put((Object)"blockId", (Object)Long.toUnsignedString(this.blockIds.get(this.start)));
            long l = System.currentTimeMillis();
            JSONObject jSONObject2 = this.peer.send(JSON.prepareRequest(jSONObject), 0xA00000);
            this.responseTime = System.currentTimeMillis() - l;
            if (jSONObject2 == null) {
                return null;
            }
            List list = (List)jSONObject2.get((Object)"nextBlocks");
            if (list == null) {
                return null;
            }
            if (list.size() > 36) {
                Logger.logDebugMessage("Obsolete or rogue peer " + this.peer.getHost() + " sends too many nextBlocks, blacklisting");
                this.peer.blacklist("Too many nextBlocks");
                return null;
            }
            ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>(list.size());
            try {
                int n = this.stop - this.start;
                for (JSONObject jSONObject3 : list) {
                    arrayList.add(BlockImpl.parseBlock(jSONObject3));
                    if (--n > 0) continue;
                    break;
                }
            }
            catch (RuntimeException | NxtException.NotValidException exception) {
                Logger.logDebugMessage("Failed to parse block: " + exception.toString(), exception);
                this.peer.blacklist(exception);
                this.stop = this.start + arrayList.size();
            }
            return arrayList;
        }

        public Future<List<BlockImpl>> getFuture() {
            return this.future;
        }

        public void setFuture(Future<List<BlockImpl>> future) {
            this.future = future;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public void setPeer(Peer peer) {
            this.peer = peer;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getStop() {
            return this.stop;
        }

        public int getRequestCount() {
            return this.requestCount;
        }

        public long getResponseTime() {
            return this.responseTime;
        }
    }
}

