/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.util.Calendar;
import java.util.TimeZone;
import nxt.Nxt;

public final class Constants {
    public static final boolean isTestnet = Nxt.getBooleanProperty("nxt.isTestnet");
    public static final boolean isOffline = Nxt.getBooleanProperty("nxt.isOffline");
    public static final boolean isLightClient = Nxt.getBooleanProperty("nxt.isLightClient");
    public static final boolean isAutomatedTest = isTestnet && Nxt.getBooleanProperty("nxt.isAutomatedTest");
    public static final String customLoginWarning = Nxt.getStringProperty("nxt.customLoginWarning", null, false, "UTF-8");
    public static final int MAX_NUMBER_OF_TRANSACTIONS = 255;
    public static final int MIN_TRANSACTION_SIZE = 176;
    public static final int MAX_PAYLOAD_LENGTH = 44880;
    public static final long MAX_BALANCE_NXT = 1000000000L;
    public static final long ONE_NXT = 100000000L;
    public static final long MAX_BALANCE_NQT = 100000000000000000L;
    public static final long INITIAL_BASE_TARGET = 153722867L;
    public static final long MAX_BASE_TARGET = 153722867000000000L;
    public static final long MAX_BASE_TARGET_2 = isTestnet ? 153722867000000000L : 7686143350L;
    public static final long MIN_BASE_TARGET = 138350580L;
    public static final int MIN_BLOCKTIME_LIMIT = 53;
    public static final int MAX_BLOCKTIME_LIMIT = 67;
    public static final int BASE_TARGET_GAMMA = 64;
    public static final int MAX_ROLLBACK = Math.max(Nxt.getIntProperty("nxt.maxRollback"), 720);
    public static final int GUARANTEED_BALANCE_CONFIRMATIONS = isTestnet ? Nxt.getIntProperty("nxt.testnetGuaranteedBalanceConfirmations", 1440) : 1440;
    public static final int LEASING_DELAY = isTestnet ? Nxt.getIntProperty("nxt.testnetLeasingDelay", 1440) : 1440;
    public static final long MIN_FORGING_BALANCE_NQT = 100000000000L;
    public static final int MAX_TIMEDRIFT = 15;
    public static final int FORGING_DELAY = Nxt.getIntProperty("nxt.forgingDelay");
    public static final int FORGING_SPEEDUP = Nxt.getIntProperty("nxt.forgingSpeedup");
    public static final int BATCH_COMMIT_SIZE = Nxt.getIntProperty("nxt.batchCommitSize", Integer.MAX_VALUE);
    public static final byte MAX_PHASING_VOTE_TRANSACTIONS = 10;
    public static final byte MAX_PHASING_WHITELIST_SIZE = 10;
    public static final byte MAX_PHASING_LINKED_TRANSACTIONS = 10;
    public static final int MAX_PHASING_DURATION = 20160;
    public static final int MAX_PHASING_REVEALED_SECRET_LENGTH = 100;
    public static final int MAX_ALIAS_URI_LENGTH = 1000;
    public static final int MAX_ALIAS_LENGTH = 100;
    public static final int MAX_ARBITRARY_MESSAGE_LENGTH = 160;
    public static final int MAX_ENCRYPTED_MESSAGE_LENGTH = 176;
    public static final int MAX_PRUNABLE_MESSAGE_LENGTH = 43008;
    public static final int MAX_PRUNABLE_ENCRYPTED_MESSAGE_LENGTH = 43008;
    public static final int MIN_PRUNABLE_LIFETIME = isTestnet ? 86400 : 1209600;
    public static final int MAX_PRUNABLE_LIFETIME;
    public static final boolean ENABLE_PRUNING;
    public static final boolean INCLUDE_EXPIRED_PRUNABLE;
    public static final int MAX_ACCOUNT_NAME_LENGTH = 100;
    public static final int MAX_ACCOUNT_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_ACCOUNT_PROPERTY_NAME_LENGTH = 32;
    public static final int MAX_ACCOUNT_PROPERTY_VALUE_LENGTH = 160;
    public static final int MAX_ASSET_PROPERTY_NAME_LENGTH = 32;
    public static final int MAX_ASSET_PROPERTY_VALUE_LENGTH = 160;
    public static final long MAX_ASSET_QUANTITY_QNT = 100000000000000000L;
    public static final int MIN_ASSET_NAME_LENGTH = 3;
    public static final int MAX_ASSET_NAME_LENGTH = 10;
    public static final int MAX_ASSET_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_SINGLETON_ASSET_DESCRIPTION_LENGTH = 160;
    public static final int MAX_ASSET_TRANSFER_COMMENT_LENGTH = 1000;
    public static final int MAX_DIVIDEND_PAYMENT_ROLLBACK = 1441;
    public static final int MAX_POLL_NAME_LENGTH = 100;
    public static final int MAX_POLL_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_POLL_OPTION_LENGTH = 100;
    public static final int MAX_POLL_OPTION_COUNT = 100;
    public static final int MAX_POLL_DURATION = 20160;
    public static final byte MIN_VOTE_VALUE = -92;
    public static final byte MAX_VOTE_VALUE = 92;
    public static final byte NO_VOTE_VALUE = -128;
    public static final int MAX_DGS_LISTING_QUANTITY = 1000000000;
    public static final int MAX_DGS_LISTING_NAME_LENGTH = 100;
    public static final int MAX_DGS_LISTING_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_DGS_LISTING_TAGS_LENGTH = 100;
    public static final int MAX_DGS_GOODS_LENGTH = 1000;
    public static final int MAX_HUB_ANNOUNCEMENT_URIS = 100;
    public static final int MAX_HUB_ANNOUNCEMENT_URI_LENGTH = 1000;
    public static final long MIN_HUB_EFFECTIVE_BALANCE = 100000L;
    public static final int MIN_CURRENCY_NAME_LENGTH = 3;
    public static final int MAX_CURRENCY_NAME_LENGTH = 10;
    public static final int MIN_CURRENCY_CODE_LENGTH = 3;
    public static final int MAX_CURRENCY_CODE_LENGTH = 5;
    public static final int MAX_CURRENCY_DESCRIPTION_LENGTH = 1000;
    public static final long MAX_CURRENCY_TOTAL_SUPPLY = 100000000000000000L;
    public static final int MAX_MINTING_RATIO = 10000;
    public static final byte MIN_NUMBER_OF_SHUFFLING_PARTICIPANTS = 3;
    public static final byte MAX_NUMBER_OF_SHUFFLING_PARTICIPANTS = 30;
    public static final short MAX_SHUFFLING_REGISTRATION_PERIOD = 10080;
    public static final short SHUFFLING_PROCESSING_DEADLINE;
    public static final int MAX_TAGGED_DATA_NAME_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_DESCRIPTION_LENGTH = 1000;
    public static final int MAX_TAGGED_DATA_TAGS_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_TYPE_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_CHANNEL_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_FILENAME_LENGTH = 100;
    public static final int MAX_TAGGED_DATA_DATA_LENGTH = 43008;
    public static final int ALIAS_SYSTEM_BLOCK = 22000;
    public static final int TRANSPARENT_FORGING_BLOCK;
    public static final int ARBITRARY_MESSAGES_BLOCK = 40000;
    public static final int TRANSPARENT_FORGING_BLOCK_2 = 47000;
    public static final int TRANSPARENT_FORGING_BLOCK_3;
    public static final int TRANSPARENT_FORGING_BLOCK_4 = 64000;
    public static final int TRANSPARENT_FORGING_BLOCK_5 = 67000;
    public static final int TRANSPARENT_FORGING_BLOCK_6;
    public static final int TRANSPARENT_FORGING_BLOCK_7 = Integer.MAX_VALUE;
    public static final int TRANSPARENT_FORGING_BLOCK_8;
    public static final int NQT_BLOCK;
    public static final int FRACTIONAL_BLOCK;
    public static final int ASSET_EXCHANGE_BLOCK;
    public static final int REFERENCED_TRANSACTION_FULL_HASH_BLOCK;
    public static final int REFERENCED_TRANSACTION_FULL_HASH_BLOCK_TIMESTAMP;
    public static final int MAX_REFERENCED_TRANSACTION_TIMESPAN = 5184000;
    public static final int DIGITAL_GOODS_STORE_BLOCK;
    public static final int MONETARY_SYSTEM_BLOCK;
    public static final int PHASING_BLOCK;
    public static final int CHECKSUM_BLOCK_16;
    public static final int SHUFFLING_BLOCK;
    public static final int CHECKSUM_BLOCK_17;
    public static final int CHECKSUM_BLOCK_18;
    public static final int CHECKSUM_BLOCK_19;
    public static final int FXT_BLOCK;
    public static final int CHECKSUM_BLOCK_20;
    public static final int CHECKSUM_BLOCK_21;
    public static final int CHECKSUM_BLOCK_22;
    public static final int CHECKSUM_BLOCK_23;
    public static final int IGNIS_BLOCK;
    public static final int CHECKSUM_BLOCK_24;
    public static final int CHECKSUM_BLOCK_25;
    public static final int CHECKSUM_BLOCK_26;
    public static final int ASSET_INCREASE_BLOCK;
    public static final int CHECKSUM_BLOCK_27;
    public static final int CHECKSUM_BLOCK_28;
    public static final int CHECKSUM_BLOCK_29;
    public static final int MIGRATION_SIGNALING_BLOCK;
    public static final int MIGRATION_DECISION_BLOCK;
    public static final int MIGRATION_HEIGHT;
    public static final int LAST_CHECKSUM_BLOCK;
    public static final int LAST_KNOWN_BLOCK;
    public static final int[] MIN_VERSION;
    public static final int[] MIN_PROXY_VERSION;
    static final long UNCONFIRMED_POOL_DEPOSIT_NQT;
    public static final long SHUFFLING_DEPOSIT_NQT;
    public static final boolean correctInvalidFees;
    public static final long EPOCH_BEGINNING;
    public static final String ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
    public static final String ALLOWED_CURRENCY_CODE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final boolean DISABLE_FULL_TEXT_SEARCH;
    public static final boolean DISABLE_METADATA_DETECTION;

    private Constants() {
    }

    static {
        int n = Nxt.getIntProperty("nxt.maxPrunableLifetime");
        ENABLE_PRUNING = n >= 0;
        MAX_PRUNABLE_LIFETIME = ENABLE_PRUNING ? Math.max(n, MIN_PRUNABLE_LIFETIME) : Integer.MAX_VALUE;
        INCLUDE_EXPIRED_PRUNABLE = Nxt.getBooleanProperty("nxt.includeExpiredPrunable");
        SHUFFLING_PROCESSING_DEADLINE = (short)(isTestnet ? 10 : 100);
        TRANSPARENT_FORGING_BLOCK = isAutomatedTest ? 0 : 30000;
        int n2 = TRANSPARENT_FORGING_BLOCK_3 = isAutomatedTest ? 0 : 51000;
        TRANSPARENT_FORGING_BLOCK_6 = isTestnet ? (isAutomatedTest ? 0 : 75000) : 130000;
        int n3 = TRANSPARENT_FORGING_BLOCK_8 = isTestnet ? 78000 : 215000;
        NQT_BLOCK = isTestnet ? (isAutomatedTest ? 0 : 76500) : 132000;
        FRACTIONAL_BLOCK = isTestnet ? NQT_BLOCK : 134000;
        ASSET_EXCHANGE_BLOCK = isTestnet ? NQT_BLOCK : 135000;
        REFERENCED_TRANSACTION_FULL_HASH_BLOCK = isTestnet ? NQT_BLOCK : 140000;
        int n4 = REFERENCED_TRANSACTION_FULL_HASH_BLOCK_TIMESTAMP = isTestnet ? 13031352 : 15134204;
        int n5 = isTestnet ? (isAutomatedTest ? 0 : 77341) : (DIGITAL_GOODS_STORE_BLOCK = 213000);
        int n6 = isTestnet ? (isAutomatedTest ? 0 : 150000) : (MONETARY_SYSTEM_BLOCK = 330000);
        PHASING_BLOCK = isTestnet ? (isAutomatedTest ? 0 : 220000) : 445000;
        int n7 = CHECKSUM_BLOCK_16 = isTestnet ? 450000 : 556000;
        SHUFFLING_BLOCK = isTestnet ? (isAutomatedTest ? 0 : 483000) : 621000;
        CHECKSUM_BLOCK_17 = isTestnet ? 484000 : 622000;
        CHECKSUM_BLOCK_18 = isTestnet ? 664000 : 729700;
        int n8 = CHECKSUM_BLOCK_19 = isTestnet ? 789000 : 851000;
        FXT_BLOCK = isTestnet ? (isAutomatedTest ? -1 : 779000) : 1000000;
        CHECKSUM_BLOCK_20 = isTestnet ? 944000 : 1000100;
        CHECKSUM_BLOCK_21 = isTestnet ? 1051000 : 1105000;
        CHECKSUM_BLOCK_22 = isTestnet ? 1152000 : 1204000;
        int n9 = CHECKSUM_BLOCK_23 = isTestnet ? 1367000 : 1412000;
        IGNIS_BLOCK = isTestnet ? (isAutomatedTest ? -1 : 1592192) : 1636363;
        CHECKSUM_BLOCK_24 = isTestnet ? 1595000 : 1637000;
        CHECKSUM_BLOCK_25 = isTestnet ? 1825000 : 1865000;
        int n10 = CHECKSUM_BLOCK_26 = isTestnet ? 2496000 : 2532000;
        ASSET_INCREASE_BLOCK = isTestnet ? (isAutomatedTest ? 0 : 2500000) : 2870000;
        CHECKSUM_BLOCK_27 = isTestnet ? 2847000 : 2880000;
        CHECKSUM_BLOCK_28 = isTestnet ? 3872000 : 3906000;
        CHECKSUM_BLOCK_29 = isTestnet ? 5681000 : 5849000;
        MIGRATION_SIGNALING_BLOCK = isTestnet ? 5700000 : 5915915;
        MIGRATION_DECISION_BLOCK = MIGRATION_SIGNALING_BLOCK + 1440;
        MIGRATION_HEIGHT = isTestnet ? MIGRATION_DECISION_BLOCK + 1440 : 6000000;
        LAST_CHECKSUM_BLOCK = CHECKSUM_BLOCK_29;
        LAST_KNOWN_BLOCK = CHECKSUM_BLOCK_29;
        MIN_VERSION = new int[]{1, 12, 1};
        MIN_PROXY_VERSION = new int[]{1, 12, 1};
        UNCONFIRMED_POOL_DEPOSIT_NQT = (long)(isTestnet ? 50 : 100) * 100000000L;
        SHUFFLING_DEPOSIT_NQT = (long)(isTestnet ? 7 : 1000) * 100000000L;
        correctInvalidFees = Nxt.getBooleanProperty("nxt.correctInvalidFees");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1, 2013);
        calendar.set(2, 10);
        calendar.set(5, 24);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH_BEGINNING = calendar.getTimeInMillis();
        DISABLE_FULL_TEXT_SEARCH = Nxt.getBooleanProperty("nxt.disableFullTextSearch");
        DISABLE_METADATA_DETECTION = Nxt.getBooleanProperty("nxt.disableMetadataDetection");
    }
}

