/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nxt.Account;
import nxt.AccountRestrictions;
import nxt.Asset;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.Order;
import nxt.TransactionDb;
import nxt.db.DbIterator;
import nxt.db.DerivedDbTable;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class FxtDistribution
implements Listener<Block> {
    public static final int DISTRIBUTION_END = Constants.FXT_BLOCK;
    public static final int DISTRIBUTION_START = DISTRIBUTION_END - 129600;
    public static final int DISTRIBUTION_FREQUENCY = 720;
    public static final int DISTRIBUTION_STEP = 60;
    public static final long FXT_ASSET_ID = Long.parseUnsignedLong(Constants.isTestnet ? "861080501219231688" : "12422608354438203866");
    public static final long FXT_ISSUER_ID = Convert.parseAccountId(Constants.isTestnet ? "NXT-F8FG-RDWZ-GRW7-4GSK9" : "NXT-FQ28-G9SQ-BG8M-6V6QH");
    private static final BigInteger BALANCE_DIVIDER = BigInteger.valueOf(10000L * (long)(DISTRIBUTION_END - DISTRIBUTION_START) / 60L);
    private static final String logAccount = Nxt.getStringProperty("nxt.logFxtBalance");
    private static final long logAccountId = Convert.parseAccountId(logAccount);
    private static final String fxtJsonFile = Constants.isTestnet ? "fxt-testnet.json" : "fxt.json";
    private static final boolean hasSnapshot = ResourceLookup.getSystemResource(fxtJsonFile) != null;
    public static final long BITSWIFT_ASSET_ID = Long.parseUnsignedLong("12034575542068240440");
    public static final long BITSWIFT_SHAREDROP_ACCOUNT = Convert.parseAccountId("NXT-2HKA-GTP2-ZBFL-34B9L");
    public static final long JANUS_ASSET_ID = Long.parseUnsignedLong("4348103880042995903");
    public static final long JANUSXT_ASSET_ID = Long.parseUnsignedLong("14572747084550678873");
    public static final long COMJNSXT_ASSET_ID = Long.parseUnsignedLong("13363533560620557665");
    public static final Set<Long> ardorSnapshotAssets = Collections.unmodifiableSet(Convert.toSet(new long[]{FXT_ASSET_ID, BITSWIFT_ASSET_ID, JANUS_ASSET_ID, JANUSXT_ASSET_ID, COMJNSXT_ASSET_ID}));
    private static final DerivedDbTable accountFXTTable = new DerivedDbTable("account_fxt"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trim(int n) {
            block66: {
                try (Connection connection = db.getConnection();){
                    Statement statement;
                    if (n > DISTRIBUTION_END) {
                        statement = connection.createStatement();
                        Throwable throwable = null;
                        try {
                            statement.executeUpdate("TRUNCATE TABLE account_fxt");
                            break block66;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (statement != null) {
                                if (throwable != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    statement.close();
                                }
                            }
                        }
                    }
                    statement = connection.prepareStatement("CREATE TEMP TABLE account_fxt_tmp NOT PERSISTENT AS SELECT id, MAX(height) AS height FROM account_fxt WHERE height < ? GROUP BY id");
                    Throwable throwable = null;
                    try (PreparedStatement preparedStatement = connection.prepareStatement("DROP TABLE account_fxt_tmp");){
                        statement.setInt(1, n);
                        statement.executeUpdate();
                        try (PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM account_fxt WHERE (id, height) NOT IN (SELECT (id, height) FROM account_fxt_tmp) AND height < ? AND height >= 0");){
                            preparedStatement2.setInt(1, n);
                            preparedStatement2.executeUpdate();
                        }
                        finally {
                            preparedStatement.executeUpdate();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
        }
    };

    static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Block block) {
        block259: {
            Serializable serializable;
            Object object;
            Throwable throwable;
            PreparedStatement preparedStatement;
            Throwable throwable2;
            PreparedStatement preparedStatement2;
            Throwable throwable3;
            Connection connection;
            int n;
            int n2 = block.getHeight();
            if (n2 == Constants.IGNIS_BLOCK) {
                boolean bl = Db.db.isInTransaction();
                if (!bl) {
                    Db.db.beginTransaction();
                }
                try {
                    Object object2 = ardorSnapshotAssets.iterator();
                    while (object2.hasNext()) {
                        Order order;
                        long l = object2.next();
                        int n3 = 0;
                        try (DbIterator<Order> dbIterator = Order.Ask.getAskOrdersByAsset(l, 0, -1);){
                            while (dbIterator.hasNext()) {
                                order = dbIterator.next();
                                Order.Ask.removeOrder(order.getId());
                                Account.getAccount(order.getAccountId()).addToUnconfirmedAssetBalanceQNT(null, 0L, l, order.getQuantityQNT());
                                if (++n3 % 1000 != 0) continue;
                                Db.db.commitTransaction();
                            }
                        }
                        Logger.logDebugMessage("Deleted " + n3 + " ask orders for asset " + Long.toUnsignedString(l));
                        n3 = 0;
                        dbIterator = Order.Bid.getBidOrdersByAsset(l, 0, -1);
                        var9_29 = null;
                        try {
                            while (dbIterator.hasNext()) {
                                order = dbIterator.next();
                                Order.Bid.removeOrder(order.getId());
                                Account.getAccount(order.getAccountId()).addToUnconfirmedBalanceNQT(null, 0L, Math.multiplyExact(order.getQuantityQNT(), order.getPriceNQT()));
                                if (++n3 % 1000 != 0) continue;
                                Db.db.commitTransaction();
                            }
                        }
                        catch (Throwable throwable4) {
                            var9_29 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (dbIterator != null) {
                                if (var9_29 != null) {
                                    try {
                                        dbIterator.close();
                                    }
                                    catch (Throwable throwable5) {
                                        var9_29.addSuppressed(throwable5);
                                    }
                                } else {
                                    dbIterator.close();
                                }
                            }
                        }
                        Logger.logDebugMessage("Deleted " + n3 + " bid orders for asset " + Long.toUnsignedString(l));
                    }
                    object2 = Account.getAccount(FXT_ISSUER_ID);
                    AccountRestrictions.PhasingOnly.unset((Account)object2);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw new RuntimeException(exception.toString(), exception);
                }
                finally {
                    if (!bl) {
                        Db.db.endTransaction();
                    }
                }
                return;
            }
            if (hasSnapshot) {
                if (n2 == DISTRIBUTION_END) {
                    JSONObject jSONObject;
                    Logger.logDebugMessage("Distributing FXT based on snapshot file " + fxtJsonFile);
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ResourceLookup.getSystemResourceAsStream(fxtJsonFile)));){
                        jSONObject = (JSONObject)JSONValue.parse((Reader)bufferedReader);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.getMessage(), iOException);
                    }
                    boolean bl = Db.db.isInTransaction();
                    if (!bl) {
                        Db.db.beginTransaction();
                    }
                    try {
                        long l = Asset.getAsset(FXT_ASSET_ID).getInitialQuantityQNT();
                        Account account = Account.getAccount(FXT_ISSUER_ID);
                        account.addToAssetAndUnconfirmedAssetBalanceQNT(null, block.getId(), FXT_ASSET_ID, -l);
                        long l2 = 0L;
                        Iterator iterator = jSONObject.entrySet().iterator();
                        int n4 = 0;
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            long l3 = Long.parseUnsignedLong((String)entry.getKey());
                            long l4 = (Long)entry.getValue();
                            Account.getAccount(l3).addToAssetAndUnconfirmedAssetBalanceQNT(null, block.getId(), FXT_ASSET_ID, l4);
                            l2 += l4;
                            if (++n4 % 1000 != 0) continue;
                            Db.db.commitTransaction();
                        }
                        long l5 = l - l2;
                        Asset.deleteAsset(TransactionDb.findTransaction(FXT_ASSET_ID), FXT_ASSET_ID, l5);
                        Logger.logDebugMessage("Deleted " + l5 + " excess QNT");
                        Logger.logDebugMessage("Distributed " + l2 + " QNT to " + n4 + " accounts");
                        Db.db.commitTransaction();
                    }
                    catch (Exception exception) {
                        Db.db.rollbackTransaction();
                        throw new RuntimeException(exception.toString(), exception);
                    }
                    finally {
                        if (!bl) {
                            Db.db.endTransaction();
                        }
                    }
                }
                return;
            }
            if (n2 <= DISTRIBUTION_START || n2 > DISTRIBUTION_END || (n2 - DISTRIBUTION_START) % 720 != 0) {
                return;
            }
            Logger.logDebugMessage("Running FXT balance update at height " + n2);
            HashMap<Long, BigInteger> hashMap = new HashMap<Long, BigInteger>();
            for (n = n2 - 720 + 60; n <= n2; n += 60) {
                Logger.logDebugMessage("Calculating balances at height " + n);
                try {
                    connection = Db.db.getConnection();
                    throwable3 = null;
                    try {
                        preparedStatement2 = connection.prepareStatement("CREATE TEMP TABLE account_tmp NOT PERSISTENT AS SELECT id, MAX(height) as height FROM account WHERE height <= ? GROUP BY id");
                        throwable2 = null;
                        try {
                            preparedStatement2.setInt(1, n);
                            preparedStatement2.executeUpdate();
                            preparedStatement = connection.prepareStatement("SELECT account.id, account.balance FROM account, account_tmp WHERE account.id = account_tmp.id AND account.height = account_tmp.height AND account.balance > 0");
                            throwable = null;
                            try {
                                PreparedStatement preparedStatement3 = connection.prepareStatement("DROP TABLE account_tmp");
                                Object object3 = null;
                                try {
                                    try (ResultSet throwable7 = preparedStatement.executeQuery();){
                                        while (throwable7.next()) {
                                            object = throwable7.getLong("id");
                                            long l8 = throwable7.getLong("balance");
                                            if (logAccountId != 0L && (Long)object == logAccountId) {
                                                Logger.logMessage("NXT balance for " + logAccount + " at height " + n + ":\t" + l8);
                                            }
                                            hashMap.put((Long)object, (serializable = (BigInteger)hashMap.get(object)) == null ? BigInteger.valueOf(l8) : ((BigInteger)serializable).add(BigInteger.valueOf(l8)));
                                        }
                                        continue;
                                    }
                                    finally {
                                        preparedStatement3.executeUpdate();
                                    }
                                }
                                catch (Throwable throwable4) {
                                    object3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (preparedStatement3 != null) {
                                        if (object3 != null) {
                                            try {
                                                preparedStatement3.close();
                                            }
                                            catch (Throwable throwable6) {
                                                ((Throwable)object3).addSuppressed(throwable6);
                                            }
                                        } else {
                                            preparedStatement3.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (preparedStatement != null) {
                                    if (throwable != null) {
                                        try {
                                            preparedStatement.close();
                                        }
                                        catch (Throwable throwable9) {
                                            throwable.addSuppressed(throwable9);
                                        }
                                    } else {
                                        preparedStatement.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable2 = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (preparedStatement2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        preparedStatement2.close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable2.addSuppressed(throwable11);
                                    }
                                } else {
                                    preparedStatement2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable3 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (connection != null) {
                            if (throwable3 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable3.addSuppressed(throwable13);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
            Logger.logDebugMessage("Updating balances for " + hashMap.size() + " accounts");
            n = Db.db.isInTransaction() ? 1 : 0;
            if (n == 0) {
                Db.db.beginTransaction();
            }
            Db.db.clearCache();
            try {
                connection = Db.db.getConnection();
                throwable3 = null;
                try {
                    preparedStatement2 = connection.prepareStatement("SELECT balance FROM account_fxt WHERE id = ? ORDER BY height DESC LIMIT 1");
                    throwable2 = null;
                    try {
                        preparedStatement = connection.prepareStatement("INSERT INTO account_fxt (id, balance, height) values (?, ?, ?)");
                        throwable = null;
                        try {
                            Serializable serializable2;
                            Object object2;
                            Object object3;
                            AutoCloseable autoCloseable;
                            int n5 = 0;
                            for (Map.Entry entry : hashMap.entrySet()) {
                                long l = (Long)entry.getKey();
                                BigInteger bigInteger = (BigInteger)entry.getValue();
                                preparedStatement2.setLong(1, l);
                                autoCloseable = preparedStatement2.executeQuery();
                                serializable = null;
                                try {
                                    if (autoCloseable.next()) {
                                        bigInteger = bigInteger.add(new BigInteger(autoCloseable.getBytes("balance")));
                                    }
                                }
                                catch (Throwable throwable21) {
                                    serializable = throwable21;
                                    throw throwable21;
                                }
                                finally {
                                    if (autoCloseable != null) {
                                        if (serializable != null) {
                                            try {
                                                autoCloseable.close();
                                            }
                                            catch (Throwable throwable22) {
                                                ((Throwable)serializable).addSuppressed(throwable22);
                                            }
                                        } else {
                                            autoCloseable.close();
                                        }
                                    }
                                }
                                if (logAccountId != 0L && l == logAccountId) {
                                    Logger.logMessage("Average NXT balance for " + logAccount + " as of height " + n2 + ":\t" + Convert.longValueExact(bigInteger.divide(BigInteger.valueOf((n2 - DISTRIBUTION_START) / 60))));
                                }
                                preparedStatement.setLong(1, l);
                                preparedStatement.setBytes(2, bigInteger.toByteArray());
                                preparedStatement.setInt(3, n2);
                                preparedStatement.executeUpdate();
                                if (++n5 % 1000 != 0) continue;
                                Db.db.commitTransaction();
                            }
                            hashMap.clear();
                            Db.db.commitTransaction();
                            if (n2 != DISTRIBUTION_END) break block259;
                            Logger.logDebugMessage("Running FXT distribution at height " + n2);
                            long l = 0L;
                            n5 = 0;
                            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
                            object = connection.prepareStatement("CREATE TEMP TABLE account_fxt_tmp NOT PERSISTENT AS SELECT id, MAX(height) AS height FROM account_fxt WHERE height <= ? GROUP BY id");
                            Throwable throwable5 = null;
                            try {
                                autoCloseable = connection.prepareStatement("DROP TABLE account_fxt_tmp");
                                serializable = null;
                                try {
                                    object.setInt(1, n2);
                                    object.executeUpdate();
                                    try {
                                        PreparedStatement preparedStatement3 = connection.prepareStatement("SELECT account_fxt.id, account_fxt.balance FROM account_fxt, account_fxt_tmp WHERE account_fxt.id = account_fxt_tmp.id AND account_fxt.height = account_fxt_tmp.height");
                                        object3 = null;
                                        try {
                                            object2 = preparedStatement3.executeQuery();
                                            serializable2 = null;
                                            try {
                                                while (object2.next()) {
                                                    long l5 = object2.getLong("id");
                                                    long l6 = Convert.longValueExact(new BigInteger(object2.getBytes("balance")).divide(BALANCE_DIVIDER));
                                                    if (logAccountId != 0L && l5 == logAccountId) {
                                                        Logger.logMessage("FXT quantity for " + logAccount + ":\t" + l6);
                                                    }
                                                    Account.getAccount(l5).addToAssetAndUnconfirmedAssetBalanceQNT(null, block.getId(), FXT_ASSET_ID, l6);
                                                    treeMap.put(Long.toUnsignedString(l5), l6);
                                                    l += l6;
                                                    if (++n5 % 1000 != 0) continue;
                                                    Db.db.commitTransaction();
                                                }
                                            }
                                            catch (Throwable throwable6) {
                                                serializable2 = throwable6;
                                                throw throwable6;
                                            }
                                            finally {
                                                if (object2 != null) {
                                                    if (serializable2 != null) {
                                                        try {
                                                            object2.close();
                                                        }
                                                        catch (Throwable throwable7) {
                                                            ((Throwable)serializable2).addSuppressed(throwable7);
                                                        }
                                                    } else {
                                                        object2.close();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable throwable8) {
                                            object3 = throwable8;
                                            throw throwable8;
                                        }
                                        finally {
                                            if (preparedStatement3 != null) {
                                                if (object3 != null) {
                                                    try {
                                                        preparedStatement3.close();
                                                    }
                                                    catch (Throwable throwable9) {
                                                        ((Throwable)object3).addSuppressed(throwable9);
                                                    }
                                                } else {
                                                    preparedStatement3.close();
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        autoCloseable.executeUpdate();
                                    }
                                }
                                catch (Throwable throwable10) {
                                    serializable = throwable10;
                                    throw throwable10;
                                }
                                finally {
                                    if (autoCloseable != null) {
                                        if (serializable != null) {
                                            try {
                                                autoCloseable.close();
                                            }
                                            catch (Throwable throwable11) {
                                                ((Throwable)serializable).addSuppressed(throwable11);
                                            }
                                        } else {
                                            autoCloseable.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable throwable12) {
                                throwable5 = throwable12;
                                throw throwable12;
                            }
                            finally {
                                if (object != null) {
                                    if (throwable5 != null) {
                                        try {
                                            object.close();
                                        }
                                        catch (Throwable throwable13) {
                                            throwable5.addSuppressed(throwable13);
                                        }
                                    } else {
                                        object.close();
                                    }
                                }
                            }
                            object = Account.getAccount(FXT_ISSUER_ID);
                            ((Account)object).addToAssetAndUnconfirmedAssetBalanceQNT(null, block.getId(), FXT_ASSET_ID, -l);
                            long l7 = Asset.getAsset(FXT_ASSET_ID).getInitialQuantityQNT() - l;
                            ((Account)object).addToAssetAndUnconfirmedAssetBalanceQNT(null, block.getId(), FXT_ASSET_ID, -l7);
                            long l8 = ((Account)object).getAssetBalanceQNT(FXT_ASSET_ID);
                            if (l8 > 0L) {
                                treeMap.put(Long.toUnsignedString(FXT_ISSUER_ID), l8);
                            } else {
                                treeMap.remove(Long.toUnsignedString(FXT_ISSUER_ID));
                            }
                            Asset.deleteAsset(TransactionDb.findTransaction(FXT_ASSET_ID), FXT_ASSET_ID, l7);
                            Logger.logDebugMessage("Deleted " + l7 + " excess QNT");
                            Logger.logDebugMessage("Distributed " + l + " QNT to " + n5 + " accounts");
                            object3 = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fxtJsonFile))), true);
                            object2 = null;
                            try {
                                serializable2 = new StringBuilder(1024);
                                JSON.encodeObject(treeMap, (StringBuilder)serializable2);
                                ((PrintWriter)object3).write(((StringBuilder)serializable2).toString());
                            }
                            catch (Throwable throwable14) {
                                object2 = throwable14;
                                throw throwable14;
                            }
                            finally {
                                if (object3 != null) {
                                    if (object2 != null) {
                                        try {
                                            ((PrintWriter)object3).close();
                                        }
                                        catch (Throwable throwable15) {
                                            ((Throwable)object2).addSuppressed(throwable15);
                                        }
                                    } else {
                                        ((PrintWriter)object3).close();
                                    }
                                }
                            }
                            Db.db.commitTransaction();
                        }
                        catch (Throwable throwable27) {
                            throwable = throwable27;
                            throw throwable27;
                        }
                        finally {
                            if (preparedStatement != null) {
                                if (throwable != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable throwable28) {
                                        throwable.addSuppressed(throwable28);
                                    }
                                } else {
                                    preparedStatement.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable29) {
                        throwable2 = throwable29;
                        throw throwable29;
                    }
                    finally {
                        if (preparedStatement2 != null) {
                            if (throwable2 != null) {
                                try {
                                    preparedStatement2.close();
                                }
                                catch (Throwable throwable30) {
                                    throwable2.addSuppressed(throwable30);
                                }
                            } else {
                                preparedStatement2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable31) {
                    throwable3 = throwable31;
                    throw throwable31;
                }
                finally {
                    if (connection != null) {
                        if (throwable3 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable32) {
                                throwable3.addSuppressed(throwable32);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                Db.db.rollbackTransaction();
                throw new RuntimeException(exception.toString(), exception);
            }
            finally {
                if (n == 0) {
                    Db.db.endTransaction();
                }
            }
        }
    }

    static {
        Nxt.getBlockchainProcessor().addListener(new FxtDistribution(), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
    }
}

