/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Asset;
import nxt.Attachment;
import nxt.Constants;
import nxt.Currency;
import nxt.CurrencyType;
import nxt.Fee;
import nxt.HoldingType;
import nxt.MonetarySystem;
import nxt.Nxt;
import nxt.NxtException;
import nxt.Shuffling;
import nxt.ShufflingParticipant;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionType;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class ShufflingTransaction
extends TransactionType {
    private static final byte SUBTYPE_SHUFFLING_CREATION = 0;
    private static final byte SUBTYPE_SHUFFLING_REGISTRATION = 1;
    private static final byte SUBTYPE_SHUFFLING_PROCESSING = 2;
    private static final byte SUBTYPE_SHUFFLING_RECIPIENTS = 3;
    private static final byte SUBTYPE_SHUFFLING_VERIFICATION = 4;
    private static final byte SUBTYPE_SHUFFLING_CANCELLATION = 5;
    private static final Fee SHUFFLING_PROCESSING_FEE = new Fee.ConstantFee(1000000000L);
    private static final Fee SHUFFLING_RECIPIENTS_FEE = new Fee.ConstantFee(1100000000L);
    public static final TransactionType SHUFFLING_CREATION = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_REGISTRATION;
        }

        @Override
        public String getName() {
            return "ShufflingCreation";
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) {
            return new Attachment.ShufflingCreation(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingCreation(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingCreation shufflingCreation = (Attachment.ShufflingCreation)transaction.getAttachment();
            HoldingType holdingType = shufflingCreation.getHoldingType();
            long l = shufflingCreation.getAmount();
            switch (holdingType) {
                case NXT: {
                    if (l >= Constants.SHUFFLING_DEPOSIT_NQT && l <= 100000000000000000L) break;
                    throw new NxtException.NotValidException("Invalid NQT amount " + l + ", minimum is " + Constants.SHUFFLING_DEPOSIT_NQT);
                }
                case ASSET: {
                    Asset asset = Asset.getAsset(shufflingCreation.getHoldingId());
                    if (asset == null) {
                        throw new NxtException.NotCurrentlyValidException("Unknown asset " + Long.toUnsignedString(shufflingCreation.getHoldingId()));
                    }
                    if (l > 0L && l <= asset.getInitialQuantityQNT()) break;
                    throw new NxtException.NotValidException("Invalid asset quantity " + l);
                }
                case CURRENCY: {
                    Currency currency = Currency.getCurrency(shufflingCreation.getHoldingId());
                    CurrencyType.validate(currency, transaction);
                    if (!currency.isActive()) {
                        throw new NxtException.NotCurrentlyValidException("Currency is not active: " + currency.getCode());
                    }
                    if (l > 0L && l <= 100000000000000000L) break;
                    throw new NxtException.NotValidException("Invalid currency amount " + l);
                }
                default: {
                    throw new RuntimeException("Unsupported holding type " + (Object)((Object)holdingType));
                }
            }
            if (shufflingCreation.getParticipantCount() < 3 || shufflingCreation.getParticipantCount() > 30) {
                throw new NxtException.NotValidException(String.format("Number of participants %d is not between %d and %d", shufflingCreation.getParticipantCount(), (byte)3, (byte)30));
            }
            if (shufflingCreation.getRegistrationPeriod() < 1 || shufflingCreation.getRegistrationPeriod() > 10080) {
                throw new NxtException.NotValidException("Invalid registration period: " + shufflingCreation.getRegistrationPeriod());
            }
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.ShufflingCreation shufflingCreation = (Attachment.ShufflingCreation)transaction.getAttachment();
            HoldingType holdingType = shufflingCreation.getHoldingType();
            if (holdingType != HoldingType.NXT) {
                if (holdingType.getUnconfirmedBalance(account, shufflingCreation.getHoldingId()) >= shufflingCreation.getAmount() && account.getUnconfirmedBalanceNQT() >= Constants.SHUFFLING_DEPOSIT_NQT) {
                    holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), shufflingCreation.getHoldingId(), -shufflingCreation.getAmount());
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Constants.SHUFFLING_DEPOSIT_NQT);
                    return true;
                }
            } else if (account.getUnconfirmedBalanceNQT() >= shufflingCreation.getAmount()) {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -shufflingCreation.getAmount());
                return true;
            }
            return false;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingCreation shufflingCreation = (Attachment.ShufflingCreation)transaction.getAttachment();
            Shuffling.addShuffling(transaction, shufflingCreation);
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.ShufflingCreation shufflingCreation = (Attachment.ShufflingCreation)transaction.getAttachment();
            HoldingType holdingType = shufflingCreation.getHoldingType();
            if (holdingType != HoldingType.NXT) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), shufflingCreation.getHoldingId(), shufflingCreation.getAmount());
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Constants.SHUFFLING_DEPOSIT_NQT);
            } else {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), shufflingCreation.getAmount());
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingCreation shufflingCreation = (Attachment.ShufflingCreation)transaction.getAttachment();
            if (shufflingCreation.getHoldingType() != HoldingType.CURRENCY) {
                return false;
            }
            Currency currency = Currency.getCurrency(shufflingCreation.getHoldingId());
            String string = currency.getName().toLowerCase(Locale.ROOT);
            String string2 = currency.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(MonetarySystem.CURRENCY_ISSUANCE, string, map, false);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(MonetarySystem.CURRENCY_ISSUANCE, string2, map, false);
            }
            return bl;
        }
    };
    public static final TransactionType SHUFFLING_REGISTRATION = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_REGISTRATION;
        }

        @Override
        public String getName() {
            return "ShufflingRegistration";
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) {
            return new Attachment.ShufflingRegistration(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingRegistration(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingRegistration shufflingRegistration = (Attachment.ShufflingRegistration)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRegistration.getShufflingId());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Long.toUnsignedString(shufflingRegistration.getShufflingId()));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingRegistration.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            if (shuffling.getStage() != Shuffling.Stage.REGISTRATION) {
                throw new NxtException.NotCurrentlyValidException("Shuffling registration has ended for " + Long.toUnsignedString(shufflingRegistration.getShufflingId()));
            }
            if (shuffling.getParticipant(transaction.getSenderId()) != null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is already registered for shuffling %s", Long.toUnsignedString(transaction.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (Nxt.getBlockchain().getHeight() + shuffling.getBlocksRemaining() <= shufflingRegistration.getFinishValidationHeight(transaction)) {
                throw new NxtException.NotCurrentlyValidException("Shuffling registration finishes in " + shuffling.getBlocksRemaining() + " blocks");
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingRegistration shufflingRegistration = (Attachment.ShufflingRegistration)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRegistration.getShufflingId());
            return TransactionType.isDuplicate(SHUFFLING_REGISTRATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true) || TransactionType.isDuplicate(SHUFFLING_REGISTRATION, Long.toUnsignedString(shuffling.getId()), map, shuffling.getParticipantCount() - shuffling.getRegistrantCount());
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.ShufflingRegistration shufflingRegistration = (Attachment.ShufflingRegistration)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRegistration.getShufflingId());
            HoldingType holdingType = shuffling.getHoldingType();
            if (holdingType != HoldingType.NXT) {
                if (holdingType.getUnconfirmedBalance(account, shuffling.getHoldingId()) >= shuffling.getAmount() && account.getUnconfirmedBalanceNQT() >= Constants.SHUFFLING_DEPOSIT_NQT) {
                    holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), shuffling.getHoldingId(), -shuffling.getAmount());
                    account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -Constants.SHUFFLING_DEPOSIT_NQT);
                    return true;
                }
            } else if (account.getUnconfirmedBalanceNQT() >= shuffling.getAmount()) {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), -shuffling.getAmount());
                return true;
            }
            return false;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingRegistration shufflingRegistration = (Attachment.ShufflingRegistration)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRegistration.getShufflingId());
            shuffling.addParticipant(transaction.getSenderId());
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
            Attachment.ShufflingRegistration shufflingRegistration = (Attachment.ShufflingRegistration)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRegistration.getShufflingId());
            HoldingType holdingType = shuffling.getHoldingType();
            if (holdingType != HoldingType.NXT) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), transaction.getId(), shuffling.getHoldingId(), shuffling.getAmount());
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), Constants.SHUFFLING_DEPOSIT_NQT);
            } else {
                account.addToUnconfirmedBalanceNQT(this.getLedgerEvent(), transaction.getId(), shuffling.getAmount());
            }
        }
    };
    public static final TransactionType SHUFFLING_PROCESSING = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingProcessing";
        }

        @Override
        Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_PROCESSING_FEE;
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) {
            return new Attachment.ShufflingProcessing(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingProcessing(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingProcessing shufflingProcessing = (Attachment.ShufflingProcessing)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingProcessing.getShufflingId());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Long.toUnsignedString(shufflingProcessing.getShufflingId()));
            }
            if (shuffling.getStage() != Shuffling.Stage.PROCESSING) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not in processing stage", Long.toUnsignedString(shufflingProcessing.getShufflingId())));
            }
            ShufflingParticipant shufflingParticipant = shuffling.getParticipant(transaction.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(transaction.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipant.State.PROCESSED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s processing already complete", Long.toUnsignedString(transaction.getSenderId())));
            }
            if (shufflingParticipant.getAccountId() != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s is not currently assigned to process shuffling %s", Long.toUnsignedString(shufflingParticipant.getAccountId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (shufflingParticipant.getNextAccountId() == 0L) {
                throw new NxtException.NotValidException(String.format("Participant %s is last in shuffle", Long.toUnsignedString(transaction.getSenderId())));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingProcessing.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            byte[][] byArray2 = shufflingProcessing.getData();
            if (byArray2 == null && Nxt.getEpochTime() - transaction.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                throw new NxtException.NotCurrentlyValidException("Data has been pruned prematurely");
            }
            if (byArray2 != null) {
                if (byArray2.length != shufflingParticipant.getIndex() + 1 && byArray2.length != 0) {
                    throw new NxtException.NotValidException(String.format("Invalid number of encrypted data %d for participant number %d", byArray2.length, shufflingParticipant.getIndex()));
                }
                byte[] byArray3 = null;
                for (byte[] byArray4 : byArray2) {
                    if (byArray4.length != 32 + 64 * (shuffling.getParticipantCount() - shufflingParticipant.getIndex() - 1)) {
                        throw new NxtException.NotValidException("Invalid encrypted data length " + byArray4.length);
                    }
                    if (byArray3 != null && Convert.byteArrayComparator.compare(byArray3, byArray4) >= 0) {
                        throw new NxtException.NotValidException("Duplicate or unsorted encrypted data");
                    }
                    byArray3 = byArray4;
                }
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingProcessing shufflingProcessing = (Attachment.ShufflingProcessing)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingProcessing.getShufflingId());
            return TransactionType.isDuplicate(SHUFFLING_PROCESSING, Long.toUnsignedString(shuffling.getId()), map, true);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingProcessing shufflingProcessing = (Attachment.ShufflingProcessing)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingProcessing.getShufflingId());
            shuffling.updateParticipantData(transaction, shufflingProcessing);
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }

        @Override
        boolean isPruned(long l) {
            TransactionImpl transactionImpl = TransactionDb.findTransaction(l);
            Attachment.ShufflingProcessing shufflingProcessing = (Attachment.ShufflingProcessing)transactionImpl.getAttachment();
            return ShufflingParticipant.getData(shufflingProcessing.getShufflingId(), transactionImpl.getSenderId()) == null;
        }
    };
    public static final TransactionType SHUFFLING_RECIPIENTS = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingRecipients";
        }

        @Override
        Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_RECIPIENTS_FEE;
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) throws NxtException.NotValidException {
            return new Attachment.ShufflingRecipients(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingRecipients(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingRecipients shufflingRecipients = (Attachment.ShufflingRecipients)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRecipients.getShufflingId());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Long.toUnsignedString(shufflingRecipients.getShufflingId()));
            }
            if (shuffling.getStage() != Shuffling.Stage.PROCESSING) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not in processing stage", Long.toUnsignedString(shufflingRecipients.getShufflingId())));
            }
            ShufflingParticipant shufflingParticipant = shuffling.getParticipant(transaction.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(transaction.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (shufflingParticipant.getNextAccountId() != 0L) {
                throw new NxtException.NotValidException(String.format("Participant %s is not last in shuffle", Long.toUnsignedString(transaction.getSenderId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipant.State.PROCESSED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s processing already complete", Long.toUnsignedString(transaction.getSenderId())));
            }
            if (shufflingParticipant.getAccountId() != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s is not currently assigned to process shuffling %s", Long.toUnsignedString(shufflingParticipant.getAccountId()), Long.toUnsignedString(shuffling.getId())));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingRecipients.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            byte[][] byArray2 = shufflingRecipients.getRecipientPublicKeys();
            if (byArray2.length != shuffling.getParticipantCount() && byArray2.length != 0) {
                throw new NxtException.NotValidException(String.format("Invalid number of recipient public keys %d", byArray2.length));
            }
            HashSet<Long> hashSet = new HashSet<Long>(byArray2.length);
            for (byte[] byArray3 : byArray2) {
                if (!Crypto.isCanonicalPublicKey(byArray3)) {
                    throw new NxtException.NotValidException("Invalid recipient public key " + Convert.toHexString(byArray3));
                }
                if (hashSet.add(Account.getId(byArray3))) continue;
                throw new NxtException.NotValidException("Duplicate recipient accounts");
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingRecipients shufflingRecipients = (Attachment.ShufflingRecipients)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRecipients.getShufflingId());
            return TransactionType.isDuplicate(SHUFFLING_PROCESSING, Long.toUnsignedString(shuffling.getId()), map, true);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingRecipients shufflingRecipients = (Attachment.ShufflingRecipients)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingRecipients.getShufflingId());
            shuffling.updateRecipients(transaction, shufflingRecipients);
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };
    public static final TransactionType SHUFFLING_VERIFICATION = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingVerification";
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) {
            return new Attachment.ShufflingVerification(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingVerification(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingVerification shufflingVerification = (Attachment.ShufflingVerification)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingVerification.getShufflingId());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Long.toUnsignedString(shufflingVerification.getShufflingId()));
            }
            if (shuffling.getStage() != Shuffling.Stage.VERIFICATION) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not in verification stage: " + Long.toUnsignedString(shufflingVerification.getShufflingId()));
            }
            ShufflingParticipant shufflingParticipant = shuffling.getParticipant(transaction.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(transaction.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipant.State.VERIFIED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling participant %s in state %s cannot become verified", new Object[]{Long.toUnsignedString(shufflingVerification.getShufflingId()), shufflingParticipant.getState()}));
            }
            if (shufflingParticipant.getIndex() == shuffling.getParticipantCount() - 1) {
                throw new NxtException.NotValidException("Last participant cannot submit verification transaction");
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingVerification.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingVerification shufflingVerification = (Attachment.ShufflingVerification)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingVerification.getShufflingId());
            return TransactionType.isDuplicate(SHUFFLING_VERIFICATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingVerification shufflingVerification = (Attachment.ShufflingVerification)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingVerification.getShufflingId());
            shuffling.verify(transaction.getSenderId());
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };
    public static final TransactionType SHUFFLING_CANCELLATION = new ShufflingTransaction(){

        @Override
        public byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingCancellation";
        }

        @Override
        Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_PROCESSING_FEE;
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer, byte by) throws NxtException.NotValidException {
            return new Attachment.ShufflingCancellation(byteBuffer, by);
        }

        @Override
        Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new Attachment.ShufflingCancellation(jSONObject);
        }

        @Override
        void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
            Attachment.ShufflingCancellation shufflingCancellation = (Attachment.ShufflingCancellation)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingCancellation.getShufflingId());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Long.toUnsignedString(shufflingCancellation.getShufflingId()));
            }
            long l = shufflingCancellation.getCancellingAccountId();
            if (l == 0L && !shuffling.getStage().canBecome(Shuffling.Stage.BLAME)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling in state %s cannot be cancelled", new Object[]{shuffling.getStage()}));
            }
            if (l != 0L && l != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not currently being cancelled by account %s", Long.toUnsignedString(shuffling.getId()), Long.toUnsignedString(l)));
            }
            ShufflingParticipant shufflingParticipant = shuffling.getParticipant(transaction.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(transaction.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipant.State.CANCELLED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling participant %s in state %s cannot submit cancellation", new Object[]{Long.toUnsignedString(shufflingCancellation.getShufflingId()), shufflingParticipant.getState()}));
            }
            if (shufflingParticipant.getIndex() == shuffling.getParticipantCount() - 1) {
                throw new NxtException.NotValidException("Last participant cannot submit cancellation transaction");
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingCancellation.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            TransactionImpl transactionImpl = TransactionDb.findTransactionByFullHash(shufflingParticipant.getDataTransactionFullHash(), Nxt.getBlockchain().getHeight());
            if (transactionImpl == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid data transaction full hash");
            }
            Attachment.ShufflingProcessing shufflingProcessing = (Attachment.ShufflingProcessing)transactionImpl.getAttachment();
            if (!Arrays.equals(shufflingProcessing.getHash(), shufflingCancellation.getHash())) {
                throw new NxtException.NotValidException("Blame data hash doesn't match processing data hash");
            }
            byte[][] byArray2 = shufflingCancellation.getKeySeeds();
            if (byArray2.length != shuffling.getParticipantCount() - shufflingParticipant.getIndex() - 1) {
                throw new NxtException.NotValidException("Invalid number of revealed keySeeds: " + byArray2.length);
            }
            for (byte[] byArray3 : byArray2) {
                if (byArray3.length == 32) continue;
                throw new NxtException.NotValidException("Invalid keySeed: " + Convert.toHexString(byArray3));
            }
        }

        @Override
        boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            Attachment.ShufflingCancellation shufflingCancellation = (Attachment.ShufflingCancellation)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingCancellation.getShufflingId());
            return TransactionType.isDuplicate(SHUFFLING_VERIFICATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true);
        }

        @Override
        boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
            return true;
        }

        @Override
        void applyAttachment(Transaction transaction, Account account, Account account2) {
            Attachment.ShufflingCancellation shufflingCancellation = (Attachment.ShufflingCancellation)transaction.getAttachment();
            Shuffling shuffling = Shuffling.getShuffling(shufflingCancellation.getShufflingId());
            ShufflingParticipant shufflingParticipant = ShufflingParticipant.getParticipant(shuffling.getId(), account.getId());
            shuffling.cancelBy(shufflingParticipant, shufflingCancellation.getBlameData(), shufflingCancellation.getKeySeeds());
        }

        @Override
        void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };

    static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return SHUFFLING_CREATION;
            }
            case 1: {
                return SHUFFLING_REGISTRATION;
            }
            case 2: {
                return SHUFFLING_PROCESSING;
            }
            case 3: {
                return SHUFFLING_RECIPIENTS;
            }
            case 4: {
                return SHUFFLING_VERIFICATION;
            }
            case 5: {
                return SHUFFLING_CANCELLATION;
            }
        }
        return null;
    }

    private ShufflingTransaction() {
    }

    @Override
    public final byte getType() {
        return 7;
    }

    @Override
    public final boolean canHaveRecipient() {
        return false;
    }

    @Override
    public final boolean isPhasingSafe() {
        return false;
    }
}

