/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Attachment;
import nxt.Db;
import nxt.Nxt;
import nxt.Poll;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;

public final class Vote {
    private static final boolean deleteProcessedVotes = Nxt.getBooleanProperty("nxt.deleteProcessedVotes");
    private static final DbKey.LongKeyFactory<Vote> voteDbKeyFactory = new DbKey.LongKeyFactory<Vote>("id"){

        @Override
        public DbKey newKey(Vote vote) {
            return vote.dbKey;
        }
    };
    private static final EntityDbTable<Vote> voteTable = new EntityDbTable<Vote>("vote", voteDbKeyFactory){

        @Override
        protected Vote load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new Vote(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, Vote vote) throws SQLException {
            vote.save(connection);
        }

        @Override
        public void trim(int n) {
            super.trim(n);
            if (deleteProcessedVotes) {
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT MIN(height) as min_height FROM vote");
                     PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM vote WHERE poll_id = ?");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    resultSet.next();
                    int n2 = resultSet.getInt("min_height");
                    if (!resultSet.wasNull()) {
                        DbIterator<Poll> dbIterator = Poll.getPollsFinishingBetween(n2, n, 0, Integer.MAX_VALUE);
                        for (Poll poll : dbIterator) {
                            preparedStatement2.setLong(1, poll.getId());
                            preparedStatement2.executeUpdate();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long pollId;
    private final long voterId;
    private final byte[] voteBytes;

    public static int getCount() {
        return voteTable.getCount();
    }

    public static Vote getVote(long l) {
        return voteTable.get(voteDbKeyFactory.newKey(l));
    }

    public static DbIterator<Vote> getVotes(long l, int n, int n2) {
        return voteTable.getManyBy(new DbClause.LongClause("poll_id", l), n, n2);
    }

    public static Vote getVote(long l, long l2) {
        DbClause dbClause = new DbClause.LongClause("poll_id", l).and(new DbClause.LongClause("voter_id", l2));
        return voteTable.getBy(dbClause);
    }

    static Vote addVote(Transaction transaction, Attachment.MessagingVoteCasting messagingVoteCasting) {
        Vote vote = new Vote(transaction, messagingVoteCasting);
        voteTable.insert(vote);
        return vote;
    }

    static void init() {
    }

    private Vote(Transaction transaction, Attachment.MessagingVoteCasting messagingVoteCasting) {
        this.id = transaction.getId();
        this.dbKey = voteDbKeyFactory.newKey(this.id);
        this.pollId = messagingVoteCasting.getPollId();
        this.voterId = transaction.getSenderId();
        this.voteBytes = messagingVoteCasting.getPollVote();
    }

    private Vote(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.pollId = resultSet.getLong("poll_id");
        this.voterId = resultSet.getLong("voter_id");
        this.voteBytes = resultSet.getBytes("vote_bytes");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO vote (id, poll_id, voter_id, vote_bytes, height) VALUES (?, ?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.pollId);
            preparedStatement.setLong(++n, this.voterId);
            preparedStatement.setBytes(++n, this.voteBytes);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getPollId() {
        return this.pollId;
    }

    public long getVoterId() {
        return this.voterId;
    }

    public byte[] getVoteBytes() {
        return this.voteBytes;
    }
}

