/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.Account;
import nxt.Block;
import nxt.BlockchainProcessor;
import nxt.Db;
import nxt.Nxt;
import nxt.addons.AddOn;
import nxt.addons.SnapshotUtils;
import nxt.util.Listener;

public class ChildChainSnapshot
implements AddOn {
    private static final int snapshotHeight = Nxt.getIntProperty("nxt.childChainSnapshotHeight", Integer.MAX_VALUE);
    private static final boolean snapshotForTestnet = Nxt.getBooleanProperty("nxt.childChainSnapshotForTestnet", true);

    @Override
    public void init() {
        Nxt.getBlockchainProcessor().addListener(new Listener<Block>(){
            private final List<byte[]> developerPublicKeys = ChildChainSnapshot.access$000() ? SnapshotUtils.loadDeveloperPublicKeys() : Collections.emptyList();

            @Override
            public void notify(Block block) {
                if (block.getHeight() == snapshotHeight) {
                    this.exportPublicKeys();
                    this.exportBalances();
                    this.exportAliases();
                    this.exportCurrencies();
                }
            }

            private void exportPublicKeys() {
                String string = snapshotForTestnet ? "NXT_PUBLIC_KEY-testnet.json" : "NXT_PUBLIC_KEY.json";
                SnapshotUtils.exportPublicKeys(this.developerPublicKeys, string);
            }

            private void exportBalances() {
                TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
                try (Connection connection = Db.db.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement("SELECT id, balance FROM account WHERE LATEST=true");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        long l = resultSet.getLong("id");
                        long l2 = resultSet.getLong("balance");
                        if (l2 <= 0L) continue;
                        if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                            l2 /= 2L;
                        }
                        String string = Long.toUnsignedString(l);
                        treeMap.put(string, l2);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.getMessage(), sQLException);
                }
                if (snapshotForTestnet && !this.developerPublicKeys.isEmpty()) {
                    long l = 100000000000000000L / (2L * (long)this.developerPublicKeys.size());
                    this.developerPublicKeys.forEach(byArray -> {
                        String string = Long.toUnsignedString(Account.getId(byArray));
                        treeMap.put(string, l);
                    });
                }
                SnapshotUtils.saveMap(treeMap, snapshotForTestnet ? "NXT-testnet.json" : "NXT.json");
            }

            private void exportAliases() {
                SortedMap<String, Map<String, String>> sortedMap = SnapshotUtils.createAliasSnapshot();
                SnapshotUtils.saveMap(sortedMap, snapshotForTestnet ? "NXT_ALIASES-testnet.json" : "NXT_ALIASES.json");
            }

            private void exportCurrencies() {
                SortedMap<String, Map<String, String>> sortedMap = SnapshotUtils.createCurrenciesSnapshot();
                SnapshotUtils.saveMap(sortedMap, snapshotForTestnet ? "NXT_CURRENCIES-testnet.json" : "NXT_CURRENCIES.json");
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
    }
}

