/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import nxt.Account;
import nxt.Db;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONStreamAware;

class SnapshotUtils {
    SnapshotUtils() {
    }

    static List<byte[]> loadDeveloperPublicKeys() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("developerPasswords.txt");
        if (inputStream != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(Crypto.getPublicKey(string));
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
            arrayList.sort(Convert.byteArrayComparator);
            Logger.logDebugMessage("Loaded " + arrayList.size() + " developer public keys");
        } else {
            Logger.logDebugMessage("No developerPasswords.txt file found");
        }
        return arrayList;
    }

    static void exportPublicKeys(List<byte[]> list, String string) {
        Throwable throwable;
        AutoCloseable autoCloseable;
        JSONArray jSONArray = new JSONArray();
        try {
            autoCloseable = Db.db.getConnection();
            throwable = null;
            try (PreparedStatement preparedStatement = autoCloseable.prepareStatement("SELECT public_key FROM public_key WHERE public_key IS NOT NULL AND LATEST=true ORDER by account_id");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    byte[] byArray2 = resultSet.getBytes("public_key");
                    if (Collections.binarySearch(list, byArray2, Convert.byteArrayComparator) >= 0) {
                        throw new RuntimeException("Developer account " + Account.getId(byArray2) + " already exists");
                    }
                    jSONArray.add((Object)Convert.toHexString(resultSet.getBytes("public_key")));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (autoCloseable != null) {
                    if (throwable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        autoCloseable.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage(), sQLException);
        }
        list.forEach(byArray -> jSONArray.add((Object)Convert.toHexString(byArray)));
        Logger.logInfoMessage("Will save " + jSONArray.size() + " public keys");
        try {
            autoCloseable = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), true);
            throwable = null;
            try {
                JSON.writeJSONString((JSONStreamAware)jSONArray, (Writer)autoCloseable);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (autoCloseable != null) {
                    if (throwable != null) {
                        try {
                            ((PrintWriter)autoCloseable).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((PrintWriter)autoCloseable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        Logger.logInfoMessage("Done");
    }

    static void saveMap(Map<String, ?> map, String string) {
        Logger.logInfoMessage("Will save " + map.size() + " entries to " + string);
        try (PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), true);){
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeObject(map, stringBuilder);
            printWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        Logger.logInfoMessage("Done");
    }

    static SortedMap<String, Map<String, String>> createAliasSnapshot() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>();
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, alias_name, alias_uri FROM alias WHERE LATEST=true");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String string = resultSet.getString("alias_name");
                String string2 = Convert.nullToEmpty(resultSet.getString("alias_uri"));
                long l = resultSet.getLong("account_id");
                TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                treeMap2.put("account", Long.toUnsignedString(l));
                treeMap2.put("uri", string2);
                treeMap.put(string, treeMap2);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage(), sQLException);
        }
        return treeMap;
    }

    static SortedMap<String, Map<String, String>> createCurrenciesSnapshot() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>();
        try (Connection connection = Db.db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, name, code FROM currency WHERE LATEST=true");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String string = resultSet.getString("name");
                String string2 = resultSet.getString("code");
                if (SnapshotUtils.invalidCurrency(string2, string.toLowerCase(Locale.ROOT))) {
                    Logger.logDebugMessage("Skipping currency " + string2 + " " + string);
                    continue;
                }
                long l = resultSet.getLong("account_id");
                TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
                treeMap2.put("account", Long.toUnsignedString(l));
                treeMap2.put("name", string);
                treeMap.put(string2, treeMap2);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage(), sQLException);
        }
        return treeMap;
    }

    private static boolean invalidCurrency(String string, String string2) {
        if (string.equals("ARDOR") || string.contains("ARDR") || "ardor".equals(string2) || "ardr".equals(string2)) {
            return true;
        }
        if (string.contains("NXT") || string.contains("NEXT") || "nxt".equals(string2) || "next".equals(string2)) {
            return true;
        }
        if (string.equals("IGNIS") || "ignis".equals(string2)) {
            return true;
        }
        if ("bitswift".equals(string2)) {
            return true;
        }
        return string.equals("AEUR") || "aeur".equals(string2);
    }
}

