/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.db.TransactionalDb;

public abstract class DerivedDbTable {
    protected static final TransactionalDb db = Db.db;
    protected final String table;

    protected DerivedDbTable(String string) {
        this.table = string;
        Nxt.getBlockchainProcessor().registerDerivedTable(this);
    }

    public void popOffTo(int n) {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        try (Connection connection = db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.table + " WHERE height > ? LIMIT " + Constants.BATCH_COMMIT_SIZE);){
            int n2;
            preparedStatement.setInt(1, n);
            do {
                n2 = preparedStatement.executeUpdate();
                Db.db.commitTransaction();
            } while (n2 >= Constants.BATCH_COMMIT_SIZE);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public void rollback(int n) {
        this.popOffTo(n);
    }

    public void truncate() {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        try (Connection connection = db.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("TRUNCATE TABLE " + this.table);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public void trim(int n) {
    }

    public void createSearchIndex(Connection connection) throws SQLException {
    }

    public boolean isPersistent() {
        return false;
    }

    public final String toString() {
        return this.table;
    }
}

