/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Constants;
import nxt.Nxt;
import nxt.http.APIEnum;
import nxt.http.APIProxyServlet;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.APITestServlet;
import nxt.http.CustomAPISetup;
import nxt.http.DbShellServlet;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.UPnP;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class API {
    public static final int TESTNET_API_PORT = 6876;
    public static final int TESTNET_API_SSLPORT = 6877;
    private static final String[] DISABLED_HTTP_METHODS = new String[]{"TRACE", "OPTIONS", "HEAD"};
    static final Set<String> SENSITIVE_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("secretPhrase", "adminPassword", "sharedKey", "encryptionPassword")));
    private static boolean isInitialized = false;
    public static final int openAPIPort;
    public static final int openAPISSLPort;
    public static final boolean isOpenAPI;
    private static List<APIEnum> disabledAPIs;
    private static List<APITag> disabledAPITags;
    private static final Set<String> allowedBotHosts;
    private static final List<NetworkAddress> allowedBotNets;
    private static final Map<String, PasswordCount> incorrectPasswords;
    public static final String adminPassword;
    static final boolean disableAdminPassword;
    static final int maxRecords;
    static final boolean enableAPIUPnP;
    public static final int apiServerIdleTimeout;
    public static final boolean apiServerCORS;
    private static final String forwardedForHeader;
    private static final Server apiServer;
    private static URI welcomePageUri;
    private static URI serverRootUri;

    public static void init() {
        if (!isInitialized) {
            isInitialized = true;
            List<String> list = new ArrayList<String>(Nxt.getStringListProperty("nxt.disabledAPIs"));
            disabledAPIs = list.stream().map(APIEnum::fromName).collect(Collectors.toCollection(ArrayList::new));
            if (Constants.DISABLE_FULL_TEXT_SEARCH) {
                disabledAPIs.add(APIEnum.SEARCH_ACCOUNTS);
                disabledAPIs.add(APIEnum.SEARCH_ASSETS);
                disabledAPIs.add(APIEnum.SEARCH_CURRENCIES);
                disabledAPIs.add(APIEnum.SEARCH_DGS_GOODS);
                disabledAPIs.add(APIEnum.SEARCH_POLLS);
                disabledAPIs.add(APIEnum.SEARCH_TAGGED_DATA);
            }
            list = Nxt.getStringListProperty("nxt.disabledAPITags");
            Collections.sort(list);
            ArrayList arrayList = new ArrayList(list.size());
            list.forEach(string -> arrayList.add(APITag.fromDisplayName(string)));
            disabledAPITags = Collections.unmodifiableList(arrayList);
        }
    }

    public static void shutdown() {
        if (apiServer != null) {
            try {
                apiServer.stop();
                if (enableAPIUPnP) {
                    Connector[] connectorArray;
                    for (Connector connector : connectorArray = apiServer.getConnectors()) {
                        if (!(connector instanceof ServerConnector)) continue;
                        UPnP.deletePort(((ServerConnector)connector).getPort());
                    }
                }
            }
            catch (Exception exception) {
                Logger.logShutdownMessage("Failed to stop API server", exception);
            }
        }
    }

    public static List<APIEnum> getDisabledApis() {
        API.init();
        return disabledAPIs;
    }

    public static List<APITag> getDisabledApiTags() {
        API.init();
        return disabledAPITags;
    }

    public static void verifyPassword(HttpServletRequest httpServletRequest) throws ParameterException {
        if (disableAdminPassword) {
            return;
        }
        if (adminPassword.isEmpty()) {
            throw new ParameterException(JSONResponses.NO_PASSWORD_IN_CONFIG);
        }
        API.checkOrLockPassword(httpServletRequest);
    }

    public static boolean checkPassword(HttpServletRequest httpServletRequest) {
        if (disableAdminPassword) {
            return true;
        }
        if (adminPassword.isEmpty()) {
            return false;
        }
        if (Convert.emptyToNull(httpServletRequest.getParameter("adminPassword")) == null) {
            return false;
        }
        try {
            API.checkOrLockPassword(httpServletRequest);
            return true;
        }
        catch (ParameterException parameterException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkOrLockPassword(HttpServletRequest httpServletRequest) throws ParameterException {
        int n = Nxt.getEpochTime();
        String string = null;
        if (forwardedForHeader != null) {
            string = httpServletRequest.getHeader(forwardedForHeader);
        }
        if (string == null) {
            string = httpServletRequest.getRemoteHost();
        }
        Map<String, PasswordCount> map = incorrectPasswords;
        synchronized (map) {
            PasswordCount passwordCount = incorrectPasswords.get(string);
            if (passwordCount != null && passwordCount.count >= 25 && n - passwordCount.time < 3600) {
                Logger.logWarningMessage("Too many incorrect admin password attempts from " + string);
                throw new ParameterException(JSONResponses.LOCKED_ADMIN_PASSWORD);
            }
            String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("adminPassword"));
            if (!adminPassword.equals(string2)) {
                if (string2.length() > 0) {
                    if (passwordCount == null) {
                        passwordCount = new PasswordCount();
                        incorrectPasswords.put(string, passwordCount);
                        if (incorrectPasswords.size() > 1000) {
                            ArrayList<String> arrayList = new ArrayList<String>(incorrectPasswords.keySet());
                            Random random = new Random();
                            incorrectPasswords.remove(arrayList.get(random.nextInt(arrayList.size())));
                        }
                    }
                    passwordCount.count++;
                    passwordCount.time = n;
                    Logger.logWarningMessage("Incorrect adminPassword from " + string);
                    throw new ParameterException(JSONResponses.INCORRECT_ADMIN_PASSWORD);
                }
                throw new ParameterException(JSONResponses.MISSING_ADMIN_PASSWORD);
            }
            if (passwordCount != null) {
                incorrectPasswords.remove(string);
            }
        }
    }

    static boolean isAllowed(String string) {
        if (allowedBotHosts == null || allowedBotHosts.contains(string)) {
            return true;
        }
        try {
            BigInteger bigInteger = new BigInteger(InetAddress.getByName(string).getAddress());
            for (NetworkAddress networkAddress : allowedBotNets) {
                if (!networkAddress.contains(bigInteger)) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage("Unknown remote host " + string);
        }
        return false;
    }

    private static void disableHttpMethods(ServletContextHandler servletContextHandler) {
        SecurityHandler securityHandler = servletContextHandler.getSecurityHandler();
        if (securityHandler == null) {
            securityHandler = new ConstraintSecurityHandler();
            servletContextHandler.setSecurityHandler(securityHandler);
        }
        API.disableHttpMethods(securityHandler);
    }

    private static void disableHttpMethods(SecurityHandler securityHandler) {
        if (securityHandler instanceof ConstraintSecurityHandler) {
            ConstraintSecurityHandler constraintSecurityHandler = (ConstraintSecurityHandler)securityHandler;
            for (String string : DISABLED_HTTP_METHODS) {
                API.disableHttpMethod(constraintSecurityHandler, string);
            }
            ConstraintMapping constraintMapping = new ConstraintMapping();
            Constraint constraint = new Constraint();
            constraint.setName("Enable everything but TRACE");
            constraintMapping.setConstraint(constraint);
            constraintMapping.setMethodOmissions(DISABLED_HTTP_METHODS);
            constraintMapping.setPathSpec("/");
            constraintSecurityHandler.addConstraintMapping(constraintMapping);
        }
    }

    private static void disableHttpMethod(ConstraintSecurityHandler constraintSecurityHandler, String string) {
        ConstraintMapping constraintMapping = new ConstraintMapping();
        Constraint constraint = new Constraint();
        constraint.setName("Disable " + string);
        constraint.setAuthenticate(true);
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/");
        constraintMapping.setMethod(string);
        constraintSecurityHandler.addConstraintMapping(constraintMapping);
    }

    public static URI getWelcomePageUri() {
        return welcomePageUri;
    }

    public static URI getServerRootUri() {
        return serverRootUri;
    }

    private API() {
    }

    private static /* synthetic */ void lambda$static$2(SslContextFactory sslContextFactory, String string, int n, boolean bl, int n2) {
        try {
            if (enableAPIUPnP) {
                Connector[] connectorArray;
                for (Connector connector : connectorArray = apiServer.getConnectors()) {
                    if (!(connector instanceof ServerConnector)) continue;
                    UPnP.addPort(((ServerConnector)connector).getPort());
                }
            }
            APIServlet.initClass();
            APIProxyServlet.initClass();
            APITestServlet.initClass();
            apiServer.start();
            if (sslContextFactory != null) {
                Logger.logDebugMessage("API SSL Protocols: " + Arrays.toString(sslContextFactory.getSelectedProtocols()));
                Logger.logDebugMessage("API SSL Ciphers: " + Arrays.toString(sslContextFactory.getSelectedCipherSuites()));
            }
            Logger.logMessage("Started API server at " + string + ":" + n + (bl && n != n2 ? ", " + string + ":" + n2 : ""));
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Failed to start API server", exception);
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static /* synthetic */ void lambda$static$1(SslContextFactory sslContextFactory2) {
        try {
            sslContextFactory2.reload(sslContextFactory -> Logger.logInfoMessage("Reloading SSL context and keyStore"));
        }
        catch (Exception exception) {
            Logger.logWarningMessage("Couldn't reload SSLContextFactory", exception);
        }
    }

    static {
        incorrectPasswords = new HashMap<String, PasswordCount>();
        adminPassword = Nxt.getStringProperty("nxt.adminPassword", "", true);
        maxRecords = Nxt.getIntProperty("nxt.maxAPIRecords");
        enableAPIUPnP = Nxt.getBooleanProperty("nxt.enableAPIUPnP");
        apiServerIdleTimeout = Nxt.getIntProperty("nxt.apiServerIdleTimeout");
        apiServerCORS = Nxt.getBooleanProperty("nxt.apiServerCORS");
        forwardedForHeader = Nxt.getStringProperty("nxt.forwardedForHeader");
        List<String> list = Nxt.getStringListProperty("nxt.allowedBotHosts");
        if (!list.contains("*")) {
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<NetworkAddress> arrayList = new ArrayList<NetworkAddress>();
            for (String string2 : list) {
                if (string2.contains("/")) {
                    try {
                        arrayList.add(new NetworkAddress(string2));
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        Logger.logErrorMessage("Unknown network " + string2, unknownHostException);
                        throw new RuntimeException(unknownHostException.toString(), unknownHostException);
                    }
                }
                hashSet.add(string2);
            }
            allowedBotHosts = Collections.unmodifiableSet(hashSet);
            allowedBotNets = Collections.unmodifiableList(arrayList);
        } else {
            allowedBotHosts = null;
            allowedBotNets = null;
        }
        boolean bl = Nxt.getBooleanProperty("nxt.enableAPIServer");
        if (bl) {
            Object object;
            ResourceHandler resourceHandler;
            ContextHandler contextHandler;
            String string;
            Object object2;
            Object object3;
            Object object4;
            ServerConnector serverConnector;
            HttpConfiguration httpConfiguration;
            String string2;
            int n = Constants.isTestnet ? 6876 : Nxt.getIntProperty("nxt.apiServerPort");
            int n2 = Constants.isTestnet ? 6877 : Nxt.getIntProperty("nxt.apiServerSSLPort");
            string2 = Nxt.getStringProperty("nxt.apiServerHost");
            disableAdminPassword = Nxt.getBooleanProperty("nxt.disableAdminPassword") || "127.0.0.1".equals(string2) && adminPassword.isEmpty();
            apiServer = new Server();
            boolean bl2 = Nxt.getBooleanProperty("nxt.apiSSL");
            if (!bl2 || n != n2) {
                httpConfiguration = new HttpConfiguration();
                httpConfiguration.setSendDateHeader(false);
                httpConfiguration.setSendServerVersion(false);
                serverConnector = new ServerConnector(apiServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
                serverConnector.setPort(n);
                serverConnector.setHost(string2);
                serverConnector.setIdleTimeout((long)apiServerIdleTimeout);
                serverConnector.setReuseAddress(true);
                apiServer.addConnector((Connector)serverConnector);
                Logger.logMessage("API server using HTTP port " + n);
            }
            if (bl2) {
                object4 = new HttpConfiguration();
                object4.setSendDateHeader(false);
                object4.setSendServerVersion(false);
                object4.setSecureScheme("https");
                object4.setSecurePort(n2);
                object4.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                httpConfiguration = new SslContextFactory();
                object3 = Paths.get(Nxt.getUserHomeDir(), new String[0]).resolve(Paths.get(Nxt.getStringProperty("nxt.keyStorePath"), new String[0])).toString();
                Logger.logInfoMessage("Using keystore: " + (String)object3);
                httpConfiguration.setKeyStorePath((String)object3);
                httpConfiguration.setKeyStorePassword(Nxt.getStringProperty("nxt.keyStorePassword", null, true));
                httpConfiguration.addExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                httpConfiguration.addExcludeProtocols(new String[]{"SSLv3"});
                httpConfiguration.setKeyStoreType(Nxt.getStringProperty("nxt.keyStoreType"));
                object2 = Nxt.getStringListProperty("nxt.apiSSLCiphers");
                if (!object2.isEmpty()) {
                    httpConfiguration.setIncludeCipherSuites(object2.toArray(new String[object2.size()]));
                }
                ThreadPool.scheduleThread("JettySSLContextReloader", () -> API.lambda$static$1((SslContextFactory)httpConfiguration), 1, TimeUnit.DAYS);
                serverConnector = new ServerConnector(apiServer, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)httpConfiguration, "http/1.1"), new HttpConnectionFactory(object4)});
                serverConnector.setPort(n2);
                serverConnector.setHost(string2);
                serverConnector.setIdleTimeout((long)apiServerIdleTimeout);
                serverConnector.setReuseAddress(true);
                apiServer.addConnector((Connector)serverConnector);
                Logger.logMessage("API server using HTTPS port " + n2);
            } else {
                httpConfiguration = null;
            }
            object4 = "0.0.0.0".equals(string2) || "127.0.0.1".equals(string2) ? "localhost" : string2;
            try {
                welcomePageUri = new URI(bl2 ? "https" : "http", null, (String)object4, bl2 ? n2 : n, "/index.html", null, null);
                serverRootUri = new URI(bl2 ? "https" : "http", null, (String)object4, bl2 ? n2 : n, "", null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.logInfoMessage("Cannot resolve browser URI", uRISyntaxException);
            }
            openAPIPort = !Constants.isLightClient && "0.0.0.0".equals(string2) && allowedBotHosts == null && (!bl2 || n != n2) ? n : 0;
            openAPISSLPort = !Constants.isLightClient && "0.0.0.0".equals(string2) && allowedBotHosts == null && bl2 ? n2 : 0;
            isOpenAPI = openAPIPort > 0 || openAPISSLPort > 0;
            object3 = new HandlerList();
            object2 = new ServletContextHandler();
            String string3 = Nxt.getStringProperty("nxt.apiResourceBase");
            if (string3 != null) {
                string = new ServletHolder((Servlet)new DefaultServlet());
                string.setInitParameter("dirAllowed", "false");
                string.setInitParameter("resourceBase", string3);
                string.setInitParameter("welcomeServlets", "true");
                string.setInitParameter("redirectWelcome", "true");
                string.setInitParameter("gzip", "true");
                string.setInitParameter("etags", "true");
                object2.addServlet((ServletHolder)string, "/*");
                object2.setWelcomeFiles(new String[]{Nxt.getStringProperty("nxt.apiWelcomeFile")});
            }
            if ((string = Nxt.getStringProperty("nxt.javadocResourceBase")) != null) {
                contextHandler = new ContextHandler("/doc");
                resourceHandler = new ResourceHandler();
                resourceHandler.setDirectoriesListed(false);
                resourceHandler.setWelcomeFiles(new String[]{"index.html"});
                resourceHandler.setResourceBase(string);
                contextHandler.setHandler((Handler)resourceHandler);
                object3.addHandler((Handler)contextHandler);
            }
            contextHandler = object2.addServlet(APIServlet.class, "/nxt");
            contextHandler.getRegistration().setMultipartConfig(new MultipartConfigElement(null, (long)Math.max(Nxt.getIntProperty("nxt.maxUploadFileSize"), 43008), -1L, 0));
            contextHandler = object2.addServlet(APIProxyServlet.class, "/nxt-proxy");
            contextHandler.setInitParameters(Collections.singletonMap("idleTimeout", "" + Math.max(apiServerIdleTimeout - 5000, 0)));
            contextHandler.getRegistration().setMultipartConfig(new MultipartConfigElement(null, (long)Math.max(Nxt.getIntProperty("nxt.maxUploadFileSize"), 43008), -1L, 0));
            resourceHandler = new GzipHandler();
            if (!Nxt.getBooleanProperty("nxt.enableAPIServerGZIPFilter", isOpenAPI)) {
                resourceHandler.setExcludedPaths(new String[]{"/nxt", "/nxt-proxy"});
            }
            resourceHandler.setIncludedMethods(new String[]{"GET", "POST"});
            resourceHandler.setMinGzipSize(256);
            object2.setGzipHandler((GzipHandler)resourceHandler);
            object2.addServlet(APITestServlet.class, "/test");
            object2.addServlet(APITestServlet.class, "/test-proxy");
            object2.addServlet(DbShellServlet.class, "/dbshell");
            if (apiServerCORS) {
                object = object2.addFilter(CrossOriginFilter.class, "/*", null);
                object.setInitParameter("allowedHeaders", "*");
                object.setAsyncSupported(true);
            }
            if (Nxt.getBooleanProperty("nxt.apiFrameOptionsSameOrigin")) {
                object = object2.addFilter(XFrameOptionsFilter.class, "/*", null);
                object.setAsyncSupported(true);
            }
            API.disableHttpMethods((ServletContextHandler)object2);
            object = Convert.emptyToNull(Nxt.getStringProperty("nxt.apiCustomSetupImpl"));
            if (object != null) {
                try {
                    CustomAPISetup customAPISetup = (CustomAPISetup)Class.forName((String)object).newInstance();
                    customAPISetup.apply((HandlerList)object3);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Logger.logErrorMessage("Failed to load custom API setup", reflectiveOperationException);
                }
            }
            object3.addHandler((Handler)object2);
            object3.addHandler((Handler)new DefaultHandler());
            apiServer.setHandler((Handler)object3);
            apiServer.setStopAtShutdown(true);
            ThreadPool.runBeforeStart(() -> API.lambda$static$2((SslContextFactory)httpConfiguration, string2, n, bl2, n2), true);
        } else {
            apiServer = null;
            disableAdminPassword = false;
            openAPIPort = 0;
            openAPISSLPort = 0;
            isOpenAPI = false;
            Logger.logMessage("API server not enabled");
        }
    }

    public static final class XFrameOptionsFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            ((HttpServletResponse)servletResponse).setHeader("X-FRAME-OPTIONS", "SAMEORIGIN");
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }

    private static class NetworkAddress {
        private BigInteger netAddress;
        private BigInteger netMask;

        private NetworkAddress(String string) throws UnknownHostException {
            String[] stringArray = string.split("/");
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Invalid address: " + string);
            }
            InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
            byte[] byArray = inetAddress.getAddress();
            this.netAddress = new BigInteger(1, byArray);
            int n = Integer.valueOf(stringArray[1]);
            int n2 = inetAddress instanceof Inet4Address ? 32 : 128;
            this.netMask = BigInteger.ZERO.setBit(n2).subtract(BigInteger.ONE).subtract(BigInteger.ZERO.setBit(n2 - n).subtract(BigInteger.ONE));
        }

        private boolean contains(BigInteger bigInteger) {
            return bigInteger.and(this.netMask).equals(this.netAddress);
        }
    }

    private static class PasswordCount {
        private int count;
        private int time;

        private PasswordCount() {
        }
    }
}

