/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAccount
extends APIServlet.APIRequestHandler {
    static final GetAccount instance = new GetAccount();

    private GetAccount() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "includeLessors", "includeAssets", "includeCurrencies", "includeEffectiveBalance");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account;
        Object object;
        JSONArray jSONArray;
        JSONArray jSONArray2;
        Throwable throwable;
        Object object2;
        Account.AccountLease accountLease;
        Account.AccountInfo accountInfo;
        Account account2 = ParameterParser.getAccount(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeLessors"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssets"));
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencies"));
        boolean bl4 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeEffectiveBalance"));
        JSONObject jSONObject = JSONData.accountBalance(account2, bl4);
        JSONData.putAccount(jSONObject, "account", account2.getId());
        byte[] byArray = Account.getPublicKey(account2.getId());
        if (byArray != null) {
            jSONObject.put((Object)"publicKey", (Object)Convert.toHexString(byArray));
        }
        if ((accountInfo = account2.getAccountInfo()) != null) {
            jSONObject.put((Object)"name", (Object)Convert.nullToEmpty(accountInfo.getName()));
            jSONObject.put((Object)"description", (Object)Convert.nullToEmpty(accountInfo.getDescription()));
        }
        if ((accountLease = account2.getAccountLease()) != null) {
            JSONData.putAccount(jSONObject, "currentLessee", accountLease.getCurrentLesseeId());
            jSONObject.put((Object)"currentLeasingHeightFrom", (Object)accountLease.getCurrentLeasingHeightFrom());
            jSONObject.put((Object)"currentLeasingHeightTo", (Object)accountLease.getCurrentLeasingHeightTo());
            if (accountLease.getNextLesseeId() != 0L) {
                JSONData.putAccount(jSONObject, "nextLessee", accountLease.getNextLesseeId());
                jSONObject.put((Object)"nextLeasingHeightFrom", (Object)accountLease.getNextLeasingHeightFrom());
                jSONObject.put((Object)"nextLeasingHeightTo", (Object)accountLease.getNextLeasingHeightTo());
            }
        }
        if (!account2.getControls().isEmpty()) {
            object2 = new JSONArray();
            account2.getControls().forEach(arg_0 -> GetAccount.lambda$processRequest$0((JSONArray)object2, arg_0));
            jSONObject.put((Object)"accountControls", object2);
        }
        if (bl) {
            object2 = account2.getLessors();
            throwable = null;
            try {
                if (((DbIterator)object2).hasNext()) {
                    jSONArray2 = new JSONArray();
                    jSONArray = new JSONArray();
                    object = new JSONArray();
                    while (((DbIterator)object2).hasNext()) {
                        account = (Account)((DbIterator)object2).next();
                        jSONArray2.add((Object)Long.toUnsignedString(account.getId()));
                        jSONArray.add((Object)Convert.rsAccount(account.getId()));
                        object.add((Object)JSONData.lessor(account, bl4));
                    }
                    jSONObject.put((Object)"lessors", (Object)jSONArray2);
                    jSONObject.put((Object)"lessorsRS", (Object)jSONArray);
                    jSONObject.put((Object)"lessorsInfo", object);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((DbIterator)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((DbIterator)object2).close();
                    }
                }
            }
        }
        if (bl2) {
            object2 = account2.getAssets(0, -1);
            throwable = null;
            try {
                jSONArray2 = new JSONArray();
                jSONArray = new JSONArray();
                while (((DbIterator)object2).hasNext()) {
                    object = (Account.AccountAsset)((DbIterator)object2).next();
                    account = new JSONObject();
                    account.put("asset", Long.toUnsignedString(((Account.AccountAsset)object).getAssetId()));
                    account.put("balanceQNT", String.valueOf(((Account.AccountAsset)object).getQuantityQNT()));
                    jSONArray2.add((Object)account);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put((Object)"asset", (Object)Long.toUnsignedString(((Account.AccountAsset)object).getAssetId()));
                    jSONObject2.put((Object)"unconfirmedBalanceQNT", (Object)String.valueOf(((Account.AccountAsset)object).getUnconfirmedQuantityQNT()));
                    jSONArray.add((Object)jSONObject2);
                }
                if (jSONArray2.size() > 0) {
                    jSONObject.put((Object)"assetBalances", (Object)jSONArray2);
                }
                if (jSONArray.size() > 0) {
                    jSONObject.put((Object)"unconfirmedAssetBalances", (Object)jSONArray);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((DbIterator)object2).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((DbIterator)object2).close();
                    }
                }
            }
        }
        if (bl3) {
            object2 = account2.getCurrencies(0, -1);
            throwable = null;
            try {
                jSONArray2 = new JSONArray();
                while (((DbIterator)object2).hasNext()) {
                    jSONArray2.add((Object)JSONData.accountCurrency((Account.AccountCurrency)((DbIterator)object2).next(), false, true));
                }
                if (jSONArray2.size() > 0) {
                    jSONObject.put((Object)"accountCurrencies", (Object)jSONArray2);
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((DbIterator)object2).close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        ((DbIterator)object2).close();
                    }
                }
            }
        }
        return jSONObject;
    }

    private static /* synthetic */ void lambda$processRequest$0(JSONArray jSONArray, Account.ControlType controlType) {
        jSONArray.add((Object)controlType.toString());
    }
}

