/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.Trade;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetOrderTrades
extends APIServlet.APIRequestHandler {
    static final GetOrderTrades instance = new GetOrderTrades();

    private GetOrderTrades() {
        super(new APITag[]{APITag.AE}, "askOrder", "bidOrder", "includeAssetInfo", "firstIndex", "lastIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "askOrder", false);
        long l2 = ParameterParser.getUnsignedLong(httpServletRequest, "bidOrder", false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.missing("askOrder", "bidOrder");
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        if (l != 0L && l2 != 0L) {
            Trade trade = Trade.getTrade(l, l2);
            if (trade != null) {
                jSONArray.add((Object)JSONData.trade(trade, bl));
            }
        } else {
            DbIterator<Trade> dbIterator = null;
            try {
                dbIterator = l != 0L ? Trade.getAskOrderTrades(l, n, n2) : Trade.getBidOrderTrades(l2, n, n2);
                while (dbIterator.hasNext()) {
                    Trade trade = dbIterator.next();
                    jSONArray.add((Object)JSONData.trade(trade, bl));
                }
            }
            catch (Throwable throwable) {
                DbUtils.close(dbIterator);
                throw throwable;
            }
            DbUtils.close(dbIterator);
        }
        jSONObject.put((Object)"trades", (Object)jSONArray);
        return jSONObject;
    }
}

