/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.NxtException;
import nxt.Shuffling;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class ShufflingCancel
extends CreateTransaction {
    static final ShufflingCancel instance = new ShufflingCancel();

    private ShufflingCancel() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shuffling", "cancellingAccount", "shufflingStateHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Shuffling shuffling = ParameterParser.getShuffling(httpServletRequest);
        long l = ParameterParser.getAccountId(httpServletRequest, "cancellingAccount", false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingStateHash", true);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        Attachment.ShufflingCancellation shufflingCancellation = shuffling.revealKeySeeds(string, l, byArray);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        return this.createTransaction(httpServletRequest, account, shufflingCancellation);
    }
}

