/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.responses;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import nxt.Appendix;
import nxt.NxtException;
import nxt.Transaction;
import nxt.TransactionType;
import nxt.addons.JO;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;

class TransactionResponseImpl
implements TransactionResponse {
    private final JO transactionJson;
    private final long fxtTransaction;
    private final long transactionId;
    private final int confirmations;
    private TransactionType transactionType;
    private long senderId;
    private byte[] senderPublicKey;
    private long recipientId;
    private int height;
    private long blockId;
    private short index;
    private int timestamp;
    private int blockTimeStamp;
    private short deadline;
    private long amount;
    private long fee;
    private long referencedTransaction;
    private byte[] signature;
    private final byte[] signatureHash;
    private byte[] fullHash;
    private byte version;
    private int ecBlockHeight;
    private long ecBlockId;
    private boolean isPhased;
    private Appendix.PrunableEncryptedMessage encryptedAppendix;

    TransactionResponseImpl(JSONObject jSONObject) {
        this(new JO(jSONObject));
    }

    TransactionResponseImpl(JO jO) {
        this.transactionJson = jO;
        this.transactionType = TransactionType.findTransactionType(this.transactionJson.getByte("type"), this.transactionJson.getByte("subtype"));
        this.isPhased = this.transactionJson.getBoolean("phased");
        this.timestamp = this.transactionJson.getInt("timestamp");
        this.deadline = this.transactionJson.getShort("deadline");
        this.senderPublicKey = Convert.parseHexString(this.transactionJson.getString("senderPublicKey"));
        if (this.transactionJson.isExist("recipient")) {
            this.recipientId = this.transactionJson.getEntityId("recipient");
        }
        this.amount = this.transactionJson.getLong("amountNQT");
        this.fee = this.transactionJson.getLong("feeNQT");
        this.fxtTransaction = 0L;
        if (this.transactionJson.isExist("signature")) {
            this.signature = this.transactionJson.parseHexString("signature");
            this.signatureHash = this.transactionJson.parseHexString("signatureHash");
            this.fullHash = this.transactionJson.parseHexString("fullHash");
            this.transactionId = this.transactionJson.getEntityId("transaction");
        } else {
            this.signatureHash = null;
            this.transactionId = 0L;
        }
        this.senderId = this.transactionJson.getEntityId("sender");
        this.height = this.transactionJson.isExist("height") ? this.transactionJson.getInt("height") : Integer.MAX_VALUE;
        this.version = this.transactionJson.getByte("version");
        this.ecBlockId = this.transactionJson.getEntityId("ecBlockId");
        this.ecBlockHeight = this.transactionJson.getInt("ecBlockHeight");
        if (this.transactionJson.isExist("block")) {
            this.blockId = this.transactionJson.getEntityId("block");
            this.confirmations = this.transactionJson.getInt("confirmations");
            this.blockTimeStamp = this.transactionJson.getInt("blockTimestamp");
            this.index = this.transactionJson.getShort("transactionIndex");
        } else {
            this.confirmations = -1;
        }
        JO jO2 = this.transactionJson.getJo("attachment");
        if (jO2 != null && jO2.isExist("encryptedMessage") && jO2.isExist("version.PrunableEncryptedMessage")) {
            this.encryptedAppendix = new Appendix.PrunableEncryptedMessage(jO2.toJSONObject());
        }
    }

    @Override
    public long getSenderId() {
        return this.senderId;
    }

    @Override
    public String getSender() {
        return Long.toUnsignedString(this.senderId);
    }

    @Override
    public String getSenderRs() {
        if (this.senderId == 0L) {
            return null;
        }
        return Convert.rsAccount(this.senderId);
    }

    @Override
    public byte[] getSenderPublicKey() {
        return this.senderPublicKey;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public String getRecipient() {
        return Long.toUnsignedString(this.recipientId);
    }

    @Override
    public String getRecipientRs() {
        if (this.recipientId == 0L) {
            return null;
        }
        return Convert.rsAccount(this.recipientId);
    }

    @Override
    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public short getIndex() {
        return this.index;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getBlockTimestamp() {
        return this.blockTimeStamp;
    }

    @Override
    public short getDeadline() {
        return this.deadline;
    }

    @Override
    public int getExpiration() {
        return this.timestamp + this.deadline * 60;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public long getFee() {
        return this.fee;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public byte[] getFullHash() {
        return this.fullHash;
    }

    @Override
    public byte getType() {
        return this.transactionType.getType();
    }

    @Override
    public byte getSubType() {
        return this.transactionType.getType();
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public int getECBlockHeight() {
        return this.ecBlockHeight;
    }

    @Override
    public long getECBlockId() {
        return this.ecBlockId;
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public long getFxtTransaction() {
        return this.fxtTransaction;
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getUnsignedLongTransactionId() {
        return Long.toUnsignedString(this.transactionId);
    }

    @Override
    public int getConfirmations() {
        return this.confirmations;
    }

    @Override
    public int getBlockTimeStamp() {
        return this.blockTimeStamp;
    }

    @Override
    public long getReferencedTransaction() {
        return this.referencedTransaction;
    }

    @Override
    public byte[] getSignatureHash() {
        return this.signatureHash;
    }

    @Override
    public int getEcBlockHeight() {
        return this.ecBlockHeight;
    }

    @Override
    public long getEcBlockId() {
        return this.ecBlockId;
    }

    @Override
    public JO getAttachmentJson() {
        return this.transactionJson.getJo("attachment");
    }

    @Override
    public JO getJson() {
        return this.transactionJson;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return AccessController.doPrivileged(() -> {
            byte[] byArray;
            Object object2;
            Object object3;
            TransactionResponseImpl transactionResponseImpl = (TransactionResponseImpl)object;
            try {
                object3 = ParameterParser.parseTransaction(this.transactionJson.toJSONString(), null, null);
                object2 = object3.build();
                byArray = object2.getBytes();
            }
            catch (NxtException.NotValidException | ParameterException nxtException) {
                throw new IllegalStateException(nxtException);
            }
            try {
                object2 = ParameterParser.parseTransaction(transactionResponseImpl.getTransactionJson().toJSONString(), null, null);
                Transaction transaction = object2.build();
                object3 = transaction.getBytes();
            }
            catch (NxtException.NotValidException | ParameterException nxtException) {
                throw new IllegalStateException(nxtException);
            }
            return Arrays.equals(byArray, (byte[])object3);
        });
    }

    @Override
    public boolean similar(TransactionResponse transactionResponse) {
        TransactionResponseImpl transactionResponseImpl = (TransactionResponseImpl)transactionResponse;
        if (this.senderId != transactionResponseImpl.senderId) {
            this.logDiffMessage("senderId", "" + this.senderId, "" + transactionResponseImpl.senderId);
            return false;
        }
        if (this.recipientId != transactionResponseImpl.recipientId) {
            this.logDiffMessage("recipientId", "" + this.recipientId, "" + transactionResponseImpl.recipientId);
            return false;
        }
        if (this.amount != transactionResponseImpl.amount) {
            this.logDiffMessage("amount", "" + this.amount, "" + transactionResponseImpl.amount);
            return false;
        }
        if (this.fee != transactionResponseImpl.fee) {
            this.logDiffMessage("fee", "" + this.fee, "" + transactionResponseImpl.fee);
            return false;
        }
        if (this.version != transactionResponseImpl.version) {
            this.logDiffMessage("version", "" + this.version, "" + transactionResponseImpl.version);
            return false;
        }
        if (this.isPhased != transactionResponseImpl.isPhased) {
            this.logDiffMessage("isPhased", "" + this.isPhased, "" + transactionResponseImpl.isPhased);
            return false;
        }
        if (!Objects.equals(this.transactionType, transactionResponseImpl.transactionType)) {
            this.logDiffMessage("transactionType", "" + this.transactionType, "" + transactionResponseImpl.transactionType);
            return false;
        }
        if (!Arrays.equals(this.senderPublicKey, transactionResponseImpl.senderPublicKey)) {
            this.logDiffMessage("senderPublicKey", "" + Arrays.toString(this.senderPublicKey), "" + Arrays.toString(transactionResponseImpl.senderPublicKey));
            return false;
        }
        if (!Objects.equals(this.referencedTransaction, transactionResponseImpl.referencedTransaction)) {
            this.logDiffMessage("referencedTransaction", "" + this.referencedTransaction, "" + transactionResponseImpl.referencedTransaction);
            return false;
        }
        if (!this.getAttachmentJson().remove("message").equals(transactionResponseImpl.getAttachmentJson().remove("message"))) {
            this.logDiffMessage("attachmentJson", this.getAttachmentJson().toJSONString(), transactionResponseImpl.getAttachmentJson().toJSONString());
            return false;
        }
        return true;
    }

    private JO getTransactionJson() {
        return this.transactionJson;
    }

    private void logDiffMessage(String string, String string2, String string3) {
        Logger.logInfoMessage("Value %s differ this %s that %s", string, string2, string3);
    }

    public int hashCode() {
        int n = Objects.hash(this.senderId, this.recipientId, this.amount, this.fee, this.version, this.isPhased, this.transactionType, this.senderPublicKey, this.referencedTransaction);
        n = 31 * n + Arrays.hashCode(this.senderPublicKey);
        n = 31 * n + Arrays.hashCode(this.signature);
        n = 31 * n + Arrays.hashCode(this.signatureHash);
        n = 31 * n + Arrays.hashCode(this.fullHash);
        return n;
    }
}

