/*
 * Decompiled with CFR 0.152.
 */
package nxt.user;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Nxt;
import nxt.NxtException;
import nxt.user.GenerateAuthorizationToken;
import nxt.user.GetInitialData;
import nxt.user.GetNewData;
import nxt.user.JSONResponses;
import nxt.user.LockAccount;
import nxt.user.RemoveActivePeer;
import nxt.user.RemoveBlacklistedPeer;
import nxt.user.RemoveKnownPeer;
import nxt.user.SendMoney;
import nxt.user.UnlockAccount;
import nxt.user.User;
import nxt.user.Users;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class UserServlet
extends HttpServlet {
    private static final boolean enforcePost = Nxt.getBooleanProperty("nxt.uiServerEnforcePOST");
    private static final Map<String, UserRequestHandler> userRequestHandlers;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        User user = null;
        try {
            String string = httpServletRequest.getParameter("user");
            if (string == null) {
                return;
            }
            user = Users.getUser(string);
            if (Users.allowedUserHosts != null && !Users.allowedUserHosts.contains(httpServletRequest.getRemoteHost())) {
                user.enqueue(JSONResponses.DENY_ACCESS);
                return;
            }
            object = httpServletRequest.getParameter("requestType");
            if (object == null) {
                user.enqueue(JSONResponses.INCORRECT_REQUEST);
                return;
            }
            UserRequestHandler userRequestHandler = userRequestHandlers.get(object);
            if (userRequestHandler == null) {
                user.enqueue(JSONResponses.INCORRECT_REQUEST);
                return;
            }
            if (enforcePost && userRequestHandler.requirePost() && !"POST".equals(httpServletRequest.getMethod())) {
                user.enqueue(JSONResponses.POST_REQUIRED);
                return;
            }
            JSONStreamAware jSONStreamAware = userRequestHandler.processRequest(httpServletRequest, user);
            if (jSONStreamAware != null) {
                user.enqueue(jSONStreamAware);
            }
        }
        catch (RuntimeException | NxtException exception) {
            Logger.logMessage("Error processing GET request", exception);
            if (user != null) {
                object = new JSONObject();
                object.put((Object)"response", (Object)"showMessage");
                object.put((Object)"message", (Object)exception.toString());
                user.enqueue((JSONStreamAware)object);
            }
        }
        finally {
            if (user != null) {
                user.processPendingResponses(httpServletRequest, httpServletResponse);
            }
        }
    }

    static {
        HashMap<String, UserRequestHandler> hashMap = new HashMap<String, UserRequestHandler>();
        hashMap.put("generateAuthorizationToken", GenerateAuthorizationToken.instance);
        hashMap.put("getInitialData", GetInitialData.instance);
        hashMap.put("getNewData", GetNewData.instance);
        hashMap.put("lockAccount", LockAccount.instance);
        hashMap.put("removeActivePeer", RemoveActivePeer.instance);
        hashMap.put("removeBlacklistedPeer", RemoveBlacklistedPeer.instance);
        hashMap.put("removeKnownPeer", RemoveKnownPeer.instance);
        hashMap.put("sendMoney", SendMoney.instance);
        hashMap.put("unlockAccount", UnlockAccount.instance);
        userRequestHandlers = Collections.unmodifiableMap(hashMap);
    }

    static abstract class UserRequestHandler {
        UserRequestHandler() {
        }

        abstract JSONStreamAware processRequest(HttpServletRequest var1, User var2) throws NxtException, IOException;

        boolean requirePost() {
            return false;
        }
    }
}

