/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import nxt.NxtException;

public class CountingInputStream
extends FilterInputStream {
    private long count;
    private final long limit;

    public CountingInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.limit = l;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            this.incCount(1L);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 >= 0) {
            this.incCount(n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 >= 0L) {
            this.incCount(l2);
        }
        return l2;
    }

    public long getCount() {
        return this.count;
    }

    private void incCount(long l) throws NxtException.NxtIOException {
        this.count += l;
        if (this.count > this.limit) {
            throw new NxtException.NxtIOException("Maximum size exceeded: " + this.count);
        }
    }
}

