/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.LogManager;
import nxt.Nxt;
import nxt.util.BriefLogFormatter;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.NxtLogManager;
import org.slf4j.LoggerFactory;

public final class Logger {
    private static final Listeners<String, Event> messageListeners = new Listeners();
    private static final Listeners<Throwable, Event> exceptionListeners = new Listeners();
    private static final org.slf4j.Logger log;
    private static final boolean enableStackTraces;
    private static final boolean enableLogTraceback;

    private Logger() {
    }

    public static void init() {
    }

    public static void shutdown() {
        if (LogManager.getLogManager() instanceof NxtLogManager) {
            ((NxtLogManager)LogManager.getLogManager()).nxtShutdown();
        }
    }

    public static void setLevel(Level level) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(log.getName());
        switch (level) {
            case DEBUG: {
                logger.setLevel(java.util.logging.Level.FINE);
                break;
            }
            case INFO: {
                logger.setLevel(java.util.logging.Level.INFO);
                break;
            }
            case WARN: {
                logger.setLevel(java.util.logging.Level.WARNING);
                break;
            }
            case ERROR: {
                logger.setLevel(java.util.logging.Level.SEVERE);
            }
        }
    }

    public static boolean addMessageListener(Listener<String> listener, Event event) {
        return messageListeners.addListener(listener, event);
    }

    public static boolean addExceptionListener(Listener<Throwable> listener, Event event) {
        return exceptionListeners.addListener(listener, event);
    }

    public static boolean removeMessageListener(Listener<String> listener, Event event) {
        return messageListeners.removeListener(listener, event);
    }

    public static boolean removeExceptionListener(Listener<Throwable> listener, Event event) {
        return exceptionListeners.removeListener(listener, event);
    }

    public static void logMessage(String string) {
        Logger.doLog(Level.INFO, string, null);
    }

    public static void logMessage(String string, Exception exception) {
        Logger.doLog(Level.ERROR, string, exception);
    }

    public static void logShutdownMessage(String string) {
        Logger.logMessage(string);
        if (!(LogManager.getLogManager() instanceof NxtLogManager)) {
            System.out.println(string);
        }
    }

    public static void logShutdownMessage(String string, Exception exception) {
        Logger.logMessage(string, exception);
        if (!(LogManager.getLogManager() instanceof NxtLogManager)) {
            System.out.println(string);
            exception.printStackTrace();
        }
    }

    public static boolean isErrorEnabled() {
        return log.isErrorEnabled();
    }

    public static void logErrorMessage(String string) {
        Logger.doLog(Level.ERROR, string, null);
    }

    public static void logErrorMessage(String string, Object ... objectArray) {
        Logger.doLog(Level.ERROR, String.format(string, objectArray), null);
    }

    public static void logErrorMessage(String string, Throwable throwable) {
        Logger.doLog(Level.ERROR, string, throwable);
    }

    public static boolean isWarningEnabled() {
        return log.isWarnEnabled();
    }

    public static void logWarningMessage(String string) {
        Logger.doLog(Level.WARN, string, null);
    }

    public static void logWarningMessage(String string, Object ... objectArray) {
        Logger.doLog(Level.WARN, String.format(string, objectArray), null);
    }

    public static void logWarningMessage(String string, Throwable throwable) {
        Logger.doLog(Level.WARN, string, throwable);
    }

    public static boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public static void logInfoMessage(String string) {
        Logger.doLog(Level.INFO, string, null);
    }

    public static void logInfoMessage(String string, Object ... objectArray) {
        Logger.doLog(Level.INFO, String.format(string, objectArray), null);
    }

    public static void logInfoMessage(String string, Throwable throwable) {
        Logger.doLog(Level.INFO, string, throwable);
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static void logDebugMessage(String string) {
        Logger.doLog(Level.DEBUG, string, null);
    }

    public static void logDebugMessage(String string, Object ... objectArray) {
        Logger.doLog(Level.DEBUG, String.format(string, objectArray), null);
    }

    public static void logDebugMessage(String string, Throwable throwable) {
        Logger.doLog(Level.DEBUG, string, throwable);
    }

    private static void doLog(Level level, String string, Throwable throwable) {
        String string2 = string;
        Throwable throwable2 = throwable;
        if (enableLogTraceback) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
            String string3 = stackTraceElement.getClassName();
            int n = string3.lastIndexOf(46);
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
            string2 = string3 + "." + stackTraceElement.getMethodName() + ": " + string2;
        }
        if (throwable2 != null && !enableStackTraces) {
            string2 = string2 + "\n" + throwable.toString();
            throwable2 = null;
        }
        switch (level) {
            case DEBUG: {
                log.debug(string2, throwable2);
                break;
            }
            case INFO: {
                log.info(string2, throwable2);
                break;
            }
            case WARN: {
                log.warn(string2, throwable2);
                break;
            }
            case ERROR: {
                log.error(string2, throwable2);
            }
        }
        if (throwable != null) {
            exceptionListeners.notify(throwable, Event.EXCEPTION);
        } else {
            messageListeners.notify(string, Event.MESSAGE);
        }
    }

    static {
        String string = System.getProperty("java.util.logging.manager");
        System.setProperty("java.util.logging.manager", "nxt.util.NxtLogManager");
        if (!(LogManager.getLogManager() instanceof NxtLogManager)) {
            System.setProperty("java.util.logging.manager", string != null ? string : "java.util.logging.LogManager");
        }
        if (!Boolean.getBoolean("nxt.doNotConfigureLogging")) {
            try {
                Properties properties = new Properties();
                Nxt.loadProperties(properties, "logging-default.properties", true);
                Nxt.loadProperties(properties, "logging.properties", false);
                Nxt.updateLogFileHandler(properties);
                if (properties.size() > 0) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    properties.store(byteArrayOutputStream, "logging properties");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    LogManager.getLogManager().readConfiguration(byteArrayInputStream);
                    byteArrayInputStream.close();
                    byteArrayOutputStream.close();
                }
                BriefLogFormatter.init();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error loading logging properties", iOException);
            }
        }
        log = LoggerFactory.getLogger(Nxt.class);
        enableStackTraces = Nxt.getBooleanProperty("nxt.enableStackTraces");
        enableLogTraceback = Nxt.getBooleanProperty("nxt.enableLogTraceback");
        Logger.logInfoMessage("logging enabled");
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public static enum Event {
        MESSAGE,
        EXCEPTION;

    }
}

