/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import nxt.Block;
import nxt.BlockDb;
import nxt.BlockImpl;
import nxt.Blockchain;
import nxt.BlockchainProcessorImpl;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.NxtException;
import nxt.PhasingPoll;
import nxt.Transaction;
import nxt.TransactionDb;
import nxt.TransactionImpl;
import nxt.TransactionType;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.ReadWriteUpdateLock;

final class BlockchainImpl
implements Blockchain {
    private static final BlockchainImpl instance = new BlockchainImpl();
    private final ReadWriteUpdateLock lock = new ReadWriteUpdateLock();
    private final AtomicReference<BlockImpl> lastBlock = new AtomicReference();

    static BlockchainImpl getInstance() {
        return instance;
    }

    private BlockchainImpl() {
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public void updateLock() {
        this.lock.updateLock().lock();
    }

    @Override
    public void updateUnlock() {
        this.lock.updateLock().unlock();
    }

    void writeLock() {
        this.lock.writeLock().lock();
    }

    void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public BlockImpl getLastBlock() {
        return this.lastBlock.get();
    }

    void setLastBlock(BlockImpl blockImpl) {
        this.lastBlock.set(blockImpl);
    }

    @Override
    public int getHeight() {
        BlockImpl blockImpl = this.lastBlock.get();
        return blockImpl == null ? 0 : blockImpl.getHeight();
    }

    @Override
    public int getLastBlockTimestamp() {
        BlockImpl blockImpl = this.lastBlock.get();
        return blockImpl == null ? 0 : blockImpl.getTimestamp();
    }

    @Override
    public BlockImpl getLastBlock(int n) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (n >= blockImpl.getTimestamp()) {
            return blockImpl;
        }
        return BlockDb.findLastBlock(n);
    }

    @Override
    public BlockImpl getBlock(long l) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (blockImpl.getId() == l) {
            return blockImpl;
        }
        return BlockDb.findBlock(l);
    }

    @Override
    public boolean hasBlock(long l) {
        return this.lastBlock.get().getId() == l || BlockDb.hasBlock(l);
    }

    public DbIterator<BlockImpl> getAllBlocks() {
        Connection connection = null;
        this.readLock();
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block ORDER BY db_id ASC");
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    public DbIterator<BlockImpl> getBlocks(int n, int n2) {
        Connection connection = null;
        this.readLock();
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE height <= ? AND height >= ? ORDER BY height DESC");
            int n3 = this.getHeight();
            preparedStatement.setInt(1, n3 - n);
            preparedStatement.setInt(2, n3 - n2);
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    public DbIterator<BlockImpl> getBlocks(long l, int n) {
        return this.getBlocks(l, n, 0, -1);
    }

    public DbIterator<BlockImpl> getBlocks(long l, int n, int n2, int n3) {
        Connection connection = null;
        this.readLock();
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE generator_id = ? " + (n > 0 ? " AND timestamp >= ? " : " ") + "ORDER BY height DESC" + DbUtils.limitsClause(n2, n3));
            int n4 = 0;
            preparedStatement.setLong(++n4, l);
            if (n > 0) {
                preparedStatement.setInt(++n4, n);
            }
            DbUtils.setLimits(++n4, preparedStatement, n2, n3);
            DbIterator<BlockImpl> dbIterator = this.getBlocks(connection, preparedStatement);
            return dbIterator;
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getBlockCount(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<BlockImpl> getBlocks(Connection connection, PreparedStatement preparedStatement) {
        return new DbIterator<BlockImpl>(connection, preparedStatement, BlockDb::loadBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getBlockIdsAfter(long l, int n) {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        Object object2 = BlockDb.blockCache;
        synchronized (object2) {
            object = BlockDb.blockCache.get(l);
            if (object != null) {
                Collection<BlockImpl> collection = BlockDb.heightMap.tailMap(((BlockImpl)object).getHeight() + 1).values();
                for (BlockImpl blockImpl : collection) {
                    if (arrayList.size() >= n) break;
                    arrayList.add(blockImpl.getId());
                }
                return arrayList;
            }
        }
        try {
            object2 = Db.db.getConnection();
            object = null;
            try (PreparedStatement preparedStatement = object2.prepareStatement("SELECT id FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getLong("id"));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockImpl> getBlocksAfter(long l, int n) {
        Object object;
        if (n <= 0) {
            return Collections.emptyList();
        }
        ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>(10);
        Object object2 = BlockDb.blockCache;
        synchronized (object2) {
            object = BlockDb.blockCache.get(l);
            if (object != null) {
                Collection<BlockImpl> collection = BlockDb.heightMap.tailMap(((BlockImpl)object).getHeight() + 1).values();
                for (BlockImpl blockImpl : collection) {
                    if (arrayList.size() >= n) break;
                    arrayList.add(blockImpl);
                }
                return arrayList;
            }
        }
        this.readLock();
        try {
            object2 = Db.db.getConnection();
            object = null;
            try (PreparedStatement preparedStatement = object2.prepareStatement("SELECT * FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, n);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        arrayList.add(BlockDb.loadBlock((Connection)object2, resultSet, true));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockImpl> getBlocksAfter(long l, List<Long> list) {
        Object object;
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>(10);
        Object object2 = BlockDb.blockCache;
        synchronized (object2) {
            object = BlockDb.blockCache.get(l);
            if (object != null) {
                Collection<BlockImpl> collection = BlockDb.heightMap.tailMap(((BlockImpl)object).getHeight() + 1).values();
                int n = 0;
                for (BlockImpl blockImpl : collection) {
                    if (arrayList.size() >= list.size() || blockImpl.getId() != list.get(n++).longValue()) break;
                    arrayList.add(blockImpl);
                }
                return arrayList;
            }
        }
        this.readLock();
        try {
            object2 = Db.db.getConnection();
            object = null;
            try (PreparedStatement preparedStatement = object2.prepareStatement("SELECT * FROM block WHERE db_id > IFNULL ((SELECT db_id FROM block WHERE id = ?), 9223372036854775807) ORDER BY db_id ASC LIMIT ?");){
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, list.size());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    int n = 0;
                    while (resultSet.next()) {
                        BlockImpl blockImpl = BlockDb.loadBlock((Connection)object2, resultSet, true);
                        if (blockImpl.getId() != list.get(n++).longValue()) {
                            break;
                        }
                        arrayList.add(blockImpl);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }

    @Override
    public long getBlockIdAtHeight(int n) {
        Block block = this.lastBlock.get();
        if (n > block.getHeight()) {
            throw new IllegalArgumentException("Invalid height " + n + ", current blockchain is at " + block.getHeight());
        }
        if (n == block.getHeight()) {
            return block.getId();
        }
        return BlockDb.findBlockIdAtHeight(n);
    }

    @Override
    public BlockImpl getBlockAtHeight(int n) {
        BlockImpl blockImpl = this.lastBlock.get();
        if (n > blockImpl.getHeight()) {
            throw new IllegalArgumentException("Invalid height " + n + ", current blockchain is at " + blockImpl.getHeight());
        }
        if (n == blockImpl.getHeight()) {
            return blockImpl;
        }
        return BlockDb.findBlockAtHeight(n);
    }

    @Override
    public BlockImpl getECBlock(int n) {
        BlockImpl blockImpl = this.getLastBlock(n);
        if (blockImpl == null) {
            return this.getBlockAtHeight(0);
        }
        return BlockDb.findBlockAtHeight(Math.max(blockImpl.getHeight() - 720, 0));
    }

    @Override
    public TransactionImpl getTransaction(long l) {
        return TransactionDb.findTransaction(l);
    }

    @Override
    public TransactionImpl getTransactionByFullHash(String string) {
        return TransactionDb.findTransactionByFullHash(Convert.parseHexString(string));
    }

    @Override
    public boolean hasTransaction(long l) {
        return TransactionDb.hasTransaction(l);
    }

    @Override
    public boolean hasTransactionByFullHash(String string) {
        return TransactionDb.hasTransactionByFullHash(Convert.parseHexString(string));
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getTransactionCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DbIterator<TransactionImpl> getAllTransactions() {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM transaction ORDER BY db_id ASC");
            return this.getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<TransactionImpl> getTransactions(long l, byte by, byte by2, int n, boolean bl) {
        return this.getTransactions(l, 0, by, by2, n, false, false, false, 0, -1, bl, false);
    }

    public DbIterator<TransactionImpl> getTransactions(long l, int n, byte by, byte by2, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, boolean bl4, boolean bl5) {
        int n5;
        if (bl2 && bl3) {
            throw new IllegalArgumentException("At least one of phasedOnly or nonPhasedOnly must be false");
        }
        int n6 = n5 = n > 0 ? this.getHeight() - n : Integer.MAX_VALUE;
        if (n5 < 0) {
            throw new IllegalArgumentException("Number of confirmations required " + n + " exceeds current blockchain height " + this.getHeight());
        }
        Connection connection = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT transaction.* FROM transaction ");
            if (bl5 && !bl3) {
                stringBuilder.append(" LEFT JOIN phasing_poll_result ON transaction.id = phasing_poll_result.id ");
            }
            stringBuilder.append("WHERE recipient_id = ? AND sender_id <> ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by >= 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND transaction.height <= ? ");
            }
            if (bl) {
                stringBuilder.append("AND (has_message = TRUE OR has_encrypted_message = TRUE ");
                stringBuilder.append("OR ((has_prunable_message = TRUE OR has_prunable_encrypted_message = TRUE) AND timestamp > ?)) ");
            }
            if (bl2) {
                stringBuilder.append("AND phased = TRUE ");
            } else if (bl3) {
                stringBuilder.append("AND phased = FALSE ");
            }
            if (bl5 && !bl3) {
                stringBuilder.append("AND (phased = FALSE OR approved = TRUE) ");
            }
            stringBuilder.append("UNION ALL SELECT transaction.* FROM transaction ");
            if (bl5 && !bl3) {
                stringBuilder.append(" LEFT JOIN phasing_poll_result ON transaction.id = phasing_poll_result.id ");
            }
            stringBuilder.append("WHERE sender_id = ? ");
            if (n2 > 0) {
                stringBuilder.append("AND block_timestamp >= ? ");
            }
            if (by >= 0) {
                stringBuilder.append("AND type = ? ");
                if (by2 >= 0) {
                    stringBuilder.append("AND subtype = ? ");
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                stringBuilder.append("AND transaction.height <= ? ");
            }
            if (bl) {
                stringBuilder.append("AND (has_message = TRUE OR has_encrypted_message = TRUE OR has_encrypttoself_message = TRUE ");
                stringBuilder.append("OR ((has_prunable_message = TRUE OR has_prunable_encrypted_message = TRUE) AND timestamp > ?)) ");
            }
            if (bl2) {
                stringBuilder.append("AND phased = TRUE ");
            } else if (bl3) {
                stringBuilder.append("AND phased = FALSE ");
            }
            if (bl5 && !bl3) {
                stringBuilder.append("AND (phased = FALSE OR approved = TRUE) ");
            }
            stringBuilder.append("ORDER BY block_timestamp DESC, transaction_index DESC");
            stringBuilder.append(DbUtils.limitsClause(n3, n4));
            connection = Db.db.getConnection();
            int n7 = 0;
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            preparedStatement.setLong(++n7, l);
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by >= 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            int n8 = Math.max(0, Constants.INCLUDE_EXPIRED_PRUNABLE && bl4 ? Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME : Nxt.getEpochTime() - Constants.MIN_PRUNABLE_LIFETIME);
            if (bl) {
                preparedStatement.setInt(++n7, n8);
            }
            preparedStatement.setLong(++n7, l);
            if (n2 > 0) {
                preparedStatement.setInt(++n7, n2);
            }
            if (by >= 0) {
                preparedStatement.setByte(++n7, by);
                if (by2 >= 0) {
                    preparedStatement.setByte(++n7, by2);
                }
            }
            if (n5 < Integer.MAX_VALUE) {
                preparedStatement.setInt(++n7, n5);
            }
            if (bl) {
                preparedStatement.setInt(++n7, n8);
            }
            DbUtils.setLimits(++n7, preparedStatement, n3, n4);
            return this.getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<TransactionImpl> getReferencingTransactions(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = Db.db.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT transaction.* FROM transaction, referenced_transaction WHERE referenced_transaction.referenced_transaction_id = ? AND referenced_transaction.transaction_id = transaction.id ORDER BY transaction.block_timestamp DESC, transaction.transaction_index DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.getTransactions(connection, preparedStatement);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<TransactionImpl> getTransactions(Connection connection, PreparedStatement preparedStatement) {
        return new DbIterator<TransactionImpl>(connection, preparedStatement, TransactionDb::loadTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionImpl> getExpectedTransactions(Filter<Transaction> filter) {
        HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
        BlockchainProcessorImpl blockchainProcessorImpl = BlockchainProcessorImpl.getInstance();
        ArrayList<TransactionImpl> arrayList = new ArrayList<TransactionImpl>();
        this.readLock();
        try {
            if (this.getHeight() >= Constants.PHASING_BLOCK) {
                try (DbIterator<TransactionImpl> dbIterator = PhasingPoll.getFinishingTransactions(this.getHeight() + 1);){
                    for (TransactionImpl transactionImpl : dbIterator) {
                        try {
                            transactionImpl.validate();
                            if (transactionImpl.attachmentIsDuplicate(hashMap, false) || !filter.ok(transactionImpl)) continue;
                            arrayList.add(transactionImpl);
                        }
                        catch (NxtException.ValidationException validationException) {}
                    }
                }
            }
            blockchainProcessorImpl.selectUnconfirmedTransactions(hashMap, this.getLastBlock(), -1).forEach(unconfirmedTransaction -> {
                TransactionImpl transactionImpl = unconfirmedTransaction.getTransaction();
                if (transactionImpl.getPhasing() == null && filter.ok(transactionImpl)) {
                    arrayList.add(transactionImpl);
                }
            });
        }
        finally {
            this.readUnlock();
        }
        return arrayList;
    }
}

