/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import nxt.Account;
import nxt.AccountLedger;
import nxt.Attachment;
import nxt.Currency;
import nxt.CurrencyMinting;
import nxt.Nxt;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;

public final class CurrencyMint {
    private static final DbKey.LinkKeyFactory<CurrencyMint> currencyMintDbKeyFactory = new DbKey.LinkKeyFactory<CurrencyMint>("currency_id", "account_id"){

        @Override
        public DbKey newKey(CurrencyMint currencyMint) {
            return currencyMint.dbKey;
        }
    };
    private static final VersionedEntityDbTable<CurrencyMint> currencyMintTable = new VersionedEntityDbTable<CurrencyMint>("currency_mint", currencyMintDbKeyFactory){

        @Override
        protected CurrencyMint load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new CurrencyMint(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, CurrencyMint currencyMint) throws SQLException {
            currencyMint.save(connection);
        }
    };
    private static final Listeners<Mint, Event> listeners = new Listeners();
    private final DbKey dbKey;
    private final long currencyId;
    private final long accountId;
    private long counter;

    public static boolean addListener(Listener<Mint> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Mint> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    static void init() {
    }

    private CurrencyMint(long l, long l2, long l3) {
        this.currencyId = l;
        this.accountId = l2;
        this.dbKey = currencyMintDbKeyFactory.newKey(this.currencyId, this.accountId);
        this.counter = l3;
    }

    private CurrencyMint(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.currencyId = resultSet.getLong("currency_id");
        this.accountId = resultSet.getLong("account_id");
        this.dbKey = dbKey;
        this.counter = resultSet.getLong("counter");
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO currency_mint (currency_id, account_id, counter, height, latest) KEY (currency_id, account_id, height) VALUES (?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.currencyId);
            preparedStatement.setLong(++n, this.accountId);
            preparedStatement.setLong(++n, this.counter);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getCounter() {
        return this.counter;
    }

    static void mintCurrency(AccountLedger.LedgerEvent ledgerEvent, long l, Account account, Attachment.MonetarySystemCurrencyMinting monetarySystemCurrencyMinting) {
        CurrencyMint currencyMint = (CurrencyMint)currencyMintTable.get(currencyMintDbKeyFactory.newKey(monetarySystemCurrencyMinting.getCurrencyId(), account.getId()));
        if (currencyMint != null && monetarySystemCurrencyMinting.getCounter() <= currencyMint.getCounter()) {
            return;
        }
        Currency currency = Currency.getCurrency(monetarySystemCurrencyMinting.getCurrencyId());
        if (CurrencyMinting.meetsTarget(account.getId(), currency, monetarySystemCurrencyMinting)) {
            if (currencyMint == null) {
                currencyMint = new CurrencyMint(monetarySystemCurrencyMinting.getCurrencyId(), account.getId(), monetarySystemCurrencyMinting.getCounter());
            } else {
                currencyMint.counter = monetarySystemCurrencyMinting.getCounter();
            }
            currencyMintTable.insert(currencyMint);
            long l2 = Math.min(monetarySystemCurrencyMinting.getUnits(), currency.getMaxSupply() - currency.getCurrentSupply());
            account.addToCurrencyAndUnconfirmedCurrencyUnits(ledgerEvent, l, currency.getId(), l2);
            currency.increaseSupply(l2);
            listeners.notify(new Mint(account.getId(), currency.getId(), l2), Event.CURRENCY_MINT);
        } else {
            Logger.logDebugMessage("Currency mint hash no longer meets target %s", monetarySystemCurrencyMinting.getJSONObject().toJSONString());
        }
    }

    public static long getCounter(long l, long l2) {
        CurrencyMint currencyMint = (CurrencyMint)currencyMintTable.get(currencyMintDbKeyFactory.newKey(l, l2));
        if (currencyMint != null) {
            return currencyMint.getCounter();
        }
        return 0L;
    }

    static void deleteCurrency(Currency currency) {
        ArrayList arrayList = new ArrayList();
        try (DbIterator dbIterator = currencyMintTable.getManyBy(new DbClause.LongClause("currency_id", currency.getId()), 0, -1);){
            while (dbIterator.hasNext()) {
                arrayList.add(dbIterator.next());
            }
        }
        arrayList.forEach(currencyMintTable::delete);
    }

    public static class Mint {
        public final long accountId;
        public final long currencyId;
        public final long units;

        private Mint(long l, long l2, long l3) {
            this.accountId = l;
            this.currencyId = l2;
            this.units = l3;
        }
    }

    public static enum Event {
        CURRENCY_MINT;

    }
}

