/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import nxt.Appendix;
import nxt.TransactionImpl;

public interface Fee {
    public static final Fee DEFAULT_FEE = new ConstantFee(100000000L);
    public static final Fee NONE = new ConstantFee(0L);

    public long getFee(TransactionImpl var1, Appendix var2);

    public static abstract class SizeBasedFee
    implements Fee {
        private final long constantFee;
        private final long feePerSize;
        private final int unitSize;

        public SizeBasedFee(long l) {
            this(0L, l);
        }

        public SizeBasedFee(long l, long l2) {
            this(l, l2, 1024);
        }

        public SizeBasedFee(long l, long l2, int n) {
            this.constantFee = l;
            this.feePerSize = l2;
            this.unitSize = n;
        }

        @Override
        public final long getFee(TransactionImpl transactionImpl, Appendix appendix) {
            int n = this.getSize(transactionImpl, appendix) - 1;
            if (n < 0) {
                return this.constantFee;
            }
            return Math.addExact(this.constantFee, Math.multiplyExact((long)(n / this.unitSize), this.feePerSize));
        }

        public abstract int getSize(TransactionImpl var1, Appendix var2);
    }

    public static final class ConstantFee
    implements Fee {
        private final long fee;

        public ConstantFee(long l) {
            this.fee = l;
        }

        @Override
        public long getFee(TransactionImpl transactionImpl, Appendix appendix) {
            return this.fee;
        }
    }
}

