/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.Account;
import nxt.Attachment;
import nxt.Block;
import nxt.BlockchainImpl;
import nxt.Generator;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.VersionedEntityDbTable;

public class Hub {
    private static final DbKey.LongKeyFactory<Hub> hubDbKeyFactory = null;
    private static final VersionedEntityDbTable<Hub> hubTable = null;
    private static long lastBlockId;
    private static List<Hit> lastHits;
    private final long accountId;
    private final DbKey dbKey;
    private final long minFeePerByteNQT;
    private final List<String> uris;

    static void addOrUpdateHub(Transaction transaction, Attachment.MessagingHubAnnouncement messagingHubAnnouncement) {
        hubTable.insert(new Hub(transaction, messagingHubAnnouncement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Hit> getHubHits(Block block) {
        Class<Hub> clazz = Hub.class;
        synchronized (Hub.class) {
            long l;
            if (block.getId() == lastBlockId && lastHits != null) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return lastHits;
            }
            ArrayList<Hit> arrayList = new ArrayList<Hit>();
            BlockchainImpl.getInstance().readLock();
            try {
                l = BlockchainImpl.getInstance().getLastBlock().getId();
                if (l != block.getId()) {
                    List<Hit> list = Collections.emptyList();
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return list;
                }
                try (DbIterator dbIterator = hubTable.getAll(0, -1);){
                    while (dbIterator.hasNext()) {
                        long l2;
                        Hub hub = (Hub)dbIterator.next();
                        Account account = Account.getAccount(hub.getAccountId());
                        if (account == null || (l2 = account.getEffectiveBalanceNXT(block.getHeight())) < 100000L) continue;
                        arrayList.add(new Hit(hub, Generator.getHitTime(BigInteger.valueOf(l2), Generator.getHit(Account.getPublicKey(hub.getAccountId()), block), block)));
                    }
                }
            }
            finally {
                BlockchainImpl.getInstance().readUnlock();
            }
            Collections.sort(arrayList);
            lastHits = arrayList;
            lastBlockId = l;
            // ** MonitorExit[clazz] (shouldn't be in output)
            return lastHits;
        }
    }

    static void init() {
    }

    private Hub(Transaction transaction, Attachment.MessagingHubAnnouncement messagingHubAnnouncement) {
        this.accountId = transaction.getSenderId();
        this.dbKey = hubDbKeyFactory.newKey(this.accountId);
        this.minFeePerByteNQT = messagingHubAnnouncement.getMinFeePerByteNQT();
        this.uris = Collections.unmodifiableList(Arrays.asList(messagingHubAnnouncement.getUris()));
    }

    private Hub(ResultSet resultSet) throws SQLException {
        this.accountId = resultSet.getLong("account_id");
        this.dbKey = hubDbKeyFactory.newKey(this.accountId);
        this.minFeePerByteNQT = resultSet.getLong("min_fee_per_byte");
        this.uris = Collections.unmodifiableList(Arrays.asList((String[])resultSet.getObject("uris")));
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO hub (account_id, min_fee_per_byte, uris, height, latest) KEY (account_id, height) VALUES (?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.getAccountId());
            preparedStatement.setLong(++n, this.getMinFeePerByteNQT());
            preparedStatement.setObject(++n, this.getUris().toArray(new String[this.getUris().size()]));
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getMinFeePerByteNQT() {
        return this.minFeePerByteNQT;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public static class Hit
    implements Comparable<Hit> {
        public final Hub hub;
        public final long hitTime;

        private Hit(Hub hub, long l) {
            this.hub = hub;
            this.hitTime = l;
        }

        @Override
        public int compareTo(Hit hit) {
            if (this.hitTime < hit.hitTime) {
                return -1;
            }
            if (this.hitTime > hit.hitTime) {
                return 1;
            }
            return Long.compare(this.hub.accountId, hit.hub.accountId);
        }
    }
}

