/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Account;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;

public class PhasingVote {
    private static final DbKey.LinkKeyFactory<PhasingVote> phasingVoteDbKeyFactory = new DbKey.LinkKeyFactory<PhasingVote>("transaction_id", "voter_id"){

        @Override
        public DbKey newKey(PhasingVote phasingVote) {
            return phasingVote.dbKey;
        }
    };
    private static final EntityDbTable<PhasingVote> phasingVoteTable = new EntityDbTable<PhasingVote>("phasing_vote", phasingVoteDbKeyFactory){

        @Override
        protected PhasingVote load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new PhasingVote(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, PhasingVote phasingVote) throws SQLException {
            phasingVote.save(connection);
        }
    };
    private final long phasedTransactionId;
    private final long voterId;
    private final DbKey dbKey;
    private long voteId;

    public static DbIterator<PhasingVote> getVotes(long l, int n, int n2) {
        return phasingVoteTable.getManyBy(new DbClause.LongClause("transaction_id", l), n, n2);
    }

    public static PhasingVote getVote(long l, long l2) {
        return phasingVoteTable.get(phasingVoteDbKeyFactory.newKey(l, l2));
    }

    public static long getVoteCount(long l) {
        return phasingVoteTable.getCount(new DbClause.LongClause("transaction_id", l));
    }

    static void addVote(Transaction transaction, Account account, long l) {
        PhasingVote phasingVote = phasingVoteTable.get(phasingVoteDbKeyFactory.newKey(l, account.getId()));
        if (phasingVote == null) {
            phasingVote = new PhasingVote(transaction, account, l);
            phasingVoteTable.insert(phasingVote);
        }
    }

    static void init() {
    }

    private PhasingVote(Transaction transaction, Account account, long l) {
        this.phasedTransactionId = l;
        this.voterId = account.getId();
        this.dbKey = phasingVoteDbKeyFactory.newKey(this.phasedTransactionId, this.voterId);
        this.voteId = transaction.getId();
    }

    private PhasingVote(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.phasedTransactionId = resultSet.getLong("transaction_id");
        this.voterId = resultSet.getLong("voter_id");
        this.dbKey = dbKey;
        this.voteId = resultSet.getLong("vote_id");
    }

    public long getPhasedTransactionId() {
        return this.phasedTransactionId;
    }

    public long getVoterId() {
        return this.voterId;
    }

    public long getVoteId() {
        return this.voteId;
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO phasing_vote (vote_id, transaction_id, voter_id, height) VALUES (?, ?, ?, ?)");){
            int n = 0;
            preparedStatement.setLong(++n, this.voteId);
            preparedStatement.setLong(++n, this.phasedTransactionId);
            preparedStatement.setLong(++n, this.voterId);
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }
}

