/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Nxt;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class CreatePoll
extends CreateTransaction {
    static final CreatePoll instance = new CreatePoll();

    private CreatePoll() {
        super(new APITag[]{APITag.VS, APITag.CREATE_TRANSACTION}, "name", "description", "finishHeight", "votingModel", "minNumberOfOptions", "maxNumberOfOptions", "minRangeValue", "maxRangeValue", "minBalance", "minBalanceModel", "holding", "option00", "option01", "option02");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("name"));
        String string2 = httpServletRequest.getParameter("description");
        if (string == null || string.trim().isEmpty()) {
            return JSONResponses.MISSING_NAME;
        }
        if (string2 == null) {
            return JSONResponses.MISSING_DESCRIPTION;
        }
        if (string.length() > 100) {
            return JSONResponses.INCORRECT_POLL_NAME_LENGTH;
        }
        if (string2.length() > 1000) {
            return JSONResponses.INCORRECT_POLL_DESCRIPTION_LENGTH;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (arrayList.size() < 100) {
            int by = arrayList.size();
            String n = Convert.emptyToNull(httpServletRequest.getParameter("option" + (by < 10 ? "0" + by : Integer.valueOf(by))));
            if (n == null) break;
            if (n.length() > 100 || (n = n.trim()).isEmpty()) {
                return JSONResponses.INCORRECT_POLL_OPTION_LENGTH;
            }
            arrayList.add(n);
        }
        byte by = (byte)arrayList.size();
        if (arrayList.size() == 0) {
            return JSONResponses.INCORRECT_ZEROOPTIONS;
        }
        int n = Nxt.getBlockchain().getHeight();
        int n2 = ParameterParser.getInt(httpServletRequest, "finishHeight", n + 2, n + 20160 + 1, true);
        byte by2 = ParameterParser.getByte(httpServletRequest, "votingModel", (byte)0, (byte)3, true);
        byte by3 = ParameterParser.getByte(httpServletRequest, "minNumberOfOptions", (byte)1, by, true);
        byte by4 = ParameterParser.getByte(httpServletRequest, "maxNumberOfOptions", by3, by, true);
        byte by5 = ParameterParser.getByte(httpServletRequest, "minRangeValue", (byte)-92, (byte)92, true);
        byte by6 = ParameterParser.getByte(httpServletRequest, "maxRangeValue", by5, (byte)92, true);
        Attachment.MessagingPollCreation.PollBuilder pollBuilder = new Attachment.MessagingPollCreation.PollBuilder(string.trim(), string2.trim(), arrayList.toArray(new String[arrayList.size()]), n2, by2, by3, by4, by5, by6);
        long l2 = ParameterParser.getLong(httpServletRequest, "minBalance", 0L, Long.MAX_VALUE, false);
        if (l2 != 0L) {
            byte l3 = ParameterParser.getByte(httpServletRequest, "minBalanceModel", (byte)0, (byte)3, true);
            pollBuilder.minBalance(l3, l2);
        }
        if ((l = ParameterParser.getUnsignedLong(httpServletRequest, "holding", false)) != 0L) {
            pollBuilder.holdingId(l);
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MessagingPollCreation messagingPollCreation = pollBuilder.build();
        return this.createTransaction(httpServletRequest, account, messagingPollCreation);
    }
}

