/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.Attachment;
import nxt.Currency;
import nxt.NxtException;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class CurrencyReserveClaim
extends CreateTransaction {
    static final CurrencyReserveClaim instance = new CurrencyReserveClaim();

    private CurrencyReserveClaim() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "units");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "units", 0L, currency.getReserveSupply(), false);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Attachment.MonetarySystemReserveClaim monetarySystemReserveClaim = new Attachment.MonetarySystemReserveClaim(currency.getId(), l);
        return this.createTransaction(httpServletRequest, account, monetarySystemReserveClaim);
    }
}

