/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import nxt.Token;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DecodeFileToken
extends APIServlet.APIRequestHandler {
    static final DecodeFileToken instance = new DecodeFileToken();

    private DecodeFileToken() {
        super("file", new APITag[]{APITag.TOKENS}, "token");
    }

    @Override
    public JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray;
        Object object;
        String string = httpServletRequest.getParameter("token");
        if (string == null) {
            return JSONResponses.MISSING_TOKEN;
        }
        try {
            object = httpServletRequest.getPart("file");
            if (object == null) {
                throw new ParameterException(JSONResponses.INCORRECT_FILE);
            }
            ParameterParser.FileData fileData = new ParameterParser.FileData((Part)object).invoke();
            byArray = fileData.getData();
        }
        catch (IOException | ServletException throwable) {
            throw new ParameterException(JSONResponses.INCORRECT_FILE);
        }
        try {
            object = Token.parseToken(string, byArray);
            return JSONData.token((Token)object);
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TOKEN;
        }
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

