/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class EncodeQRCode
extends APIServlet.APIRequestHandler {
    static final EncodeQRCode instance = new EncodeQRCode();

    private EncodeQRCode() {
        super(new APITag[]{APITag.UTILS}, "qrCodeData", "width", "height");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        JSONObject jSONObject = new JSONObject();
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("qrCodeData"));
        int n = ParameterParser.getInt(httpServletRequest, "width", 0, 5000, false);
        int n2 = ParameterParser.getInt(httpServletRequest, "height", 0, 5000, false);
        try {
            HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
            hashMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hashMap.put(EncodeHintType.MARGIN, 0);
            hashMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(string, BarcodeFormat.QR_CODE, n, n2, hashMap);
            BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            String string2 = Base64.getEncoder().encodeToString(byArray);
            jSONObject.put((Object)"qrCodeBase64", (Object)string2);
        }
        catch (WriterException | IOException throwable) {
            String string3 = "Error creating image from qrCodeData";
            Logger.logErrorMessage(string3, throwable);
            JSONData.putException(jSONObject, (Exception)throwable, string3);
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

