/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Account;
import nxt.FundingMonitor;
import nxt.HoldingType;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetFundingMonitor
extends APIServlet.APIRequestHandler {
    static final GetFundingMonitor instance = new GetFundingMonitor();

    private GetFundingMonitor() {
        super(new APITag[]{APITag.ACCOUNTS}, "holdingType", "holding", "property", "secretPhrase", "includeMonitoredAccounts", "account", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        List<FundingMonitor> list;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        long l = ParameterParser.getAccountId(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeMonitoredAccounts"));
        if (string == null) {
            API.verifyPassword(httpServletRequest);
        }
        if (string != null || l != 0L) {
            if (string != null) {
                if (l != 0L) {
                    if (Account.getId(Crypto.getPublicKey(string)) != l) {
                        return JSONResponses.INCORRECT_ACCOUNT;
                    }
                } else {
                    l = Account.getId(Crypto.getPublicKey(string));
                }
            }
            long l2 = l;
            HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
            long l3 = ParameterParser.getHoldingId(httpServletRequest, holdingType);
            String string2 = ParameterParser.getAccountProperty(httpServletRequest, false);
            Filter<FundingMonitor> filter = string2 != null ? fundingMonitor -> fundingMonitor.getAccountId() == l2 && fundingMonitor.getProperty().equals(string2) && fundingMonitor.getHoldingType() == holdingType && fundingMonitor.getHoldingId() == l3 : fundingMonitor -> fundingMonitor.getAccountId() == l2;
            list = FundingMonitor.getMonitors(filter);
        } else {
            list = FundingMonitor.getAllMonitors();
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(fundingMonitor -> {
            JSONObject jSONObject = JSONData.accountMonitor(fundingMonitor, bl);
            jSONArray.add((Object)jSONObject);
        });
        jSONObject.put((Object)"monitors", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

