/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class GetTransaction
extends APIServlet.APIRequestHandler {
    static final GetTransaction instance = new GetTransaction();

    private GetTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transaction", "fullHash", "includePhasingResult");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        Transaction transaction;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transaction"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("fullHash"));
        if (string == null && string2 == null) {
            return JSONResponses.MISSING_TRANSACTION;
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includePhasingResult"));
        long l = 0L;
        try {
            if (string != null) {
                l = Convert.parseUnsignedLong(string);
                transaction = Nxt.getBlockchain().getTransaction(l);
            } else {
                transaction = Nxt.getBlockchain().getTransactionByFullHash(string2);
                if (transaction == null) {
                    return JSONResponses.UNKNOWN_TRANSACTION;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            return JSONResponses.INCORRECT_TRANSACTION;
        }
        if (transaction == null) {
            transaction = Nxt.getTransactionProcessor().getUnconfirmedTransaction(l);
            if (transaction == null) {
                return JSONResponses.UNKNOWN_TRANSACTION;
            }
            return JSONData.unconfirmedTransaction(transaction);
        }
        return JSONData.transaction(transaction, bl);
    }
}

