/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import nxt.Block;
import nxt.Nxt;
import nxt.peer.Peer;
import nxt.peer.PeerServlet;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

final class GetMilestoneBlockIds
extends PeerServlet.PeerRequestHandler {
    static final GetMilestoneBlockIds instance = new GetMilestoneBlockIds();

    private GetMilestoneBlockIds() {
    }

    @Override
    JSONStreamAware processRequest(JSONObject jSONObject, Peer peer) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            int n;
            int n2;
            long l;
            JSONArray jSONArray = new JSONArray();
            String string = (String)jSONObject.get((Object)"lastBlockId");
            if (string != null) {
                l = Convert.parseUnsignedLong(string);
                long l2 = Nxt.getBlockchain().getLastBlock().getId();
                if (l2 == l || Nxt.getBlockchain().hasBlock(l)) {
                    jSONArray.add((Object)string);
                    jSONObject2.put((Object)"milestoneBlockIds", (Object)jSONArray);
                    if (l2 == l) {
                        jSONObject2.put((Object)"last", (Object)Boolean.TRUE);
                    }
                    return jSONObject2;
                }
            }
            int n3 = 10;
            int n4 = Nxt.getBlockchain().getHeight();
            String string2 = (String)jSONObject.get((Object)"lastMilestoneBlockId");
            if (string2 != null) {
                Block block = Nxt.getBlockchain().getBlock(Convert.parseUnsignedLong(string2));
                if (block == null) {
                    throw new IllegalStateException("Don't have block " + string2);
                }
                n2 = block.getHeight();
                n = Math.min(1440, Math.max(n4 - n2, 1));
                n2 = Math.max(n2 - n, 0);
            } else if (string != null) {
                n2 = n4;
                n = 10;
            } else {
                peer.blacklist("Old getMilestoneBlockIds request");
                jSONObject2.put((Object)"error", (Object)"Old getMilestoneBlockIds protocol not supported, please upgrade");
                return jSONObject2;
            }
            l = Nxt.getBlockchain().getBlockIdAtHeight(n2);
            while (n2 > 0 && n3-- > 0) {
                jSONArray.add((Object)Long.toUnsignedString(l));
                l = Nxt.getBlockchain().getBlockIdAtHeight(n2);
                n2 -= n;
            }
            jSONObject2.put((Object)"milestoneBlockIds", (Object)jSONArray);
        }
        catch (RuntimeException runtimeException) {
            Logger.logDebugMessage(runtimeException.toString());
            return PeerServlet.error(runtimeException);
        }
        return jSONObject2;
    }

    @Override
    boolean rejectWhileDownloading() {
        return true;
    }
}

