/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import nxt.Account;
import nxt.Block;
import nxt.Constants;
import nxt.Db;
import nxt.Nxt;
import nxt.Transaction;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.peer.Hallmark;
import nxt.peer.Peer;
import nxt.peer.PeerDb;
import nxt.peer.PeerImpl;
import nxt.peer.PeerServlet;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.QueuedThreadPool;
import nxt.util.ThreadPool;
import nxt.util.UPnP;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.DoSFilter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class Peers {
    static final int LOGGING_MASK_EXCEPTIONS = 1;
    static final int LOGGING_MASK_NON200_RESPONSES = 2;
    static final int LOGGING_MASK_200_RESPONSES = 4;
    static volatile int communicationLoggingMask;
    private static final List<String> wellKnownPeers;
    static final Set<String> knownBlacklistedPeers;
    static final int connectTimeout;
    static final int readTimeout;
    static final int blacklistingPeriod;
    static final boolean getMorePeers;
    static final int MAX_REQUEST_SIZE = 0x100000;
    static final int MAX_RESPONSE_SIZE = 0x100000;
    static final int MAX_MESSAGE_SIZE = 0xA00000;
    public static final int MIN_COMPRESS_SIZE = 256;
    static final boolean useWebSockets;
    static final int webSocketIdleTimeout;
    static final boolean useProxy;
    static final boolean isGzipEnabled;
    private static final int DEFAULT_PEER_PORT = 7874;
    private static final int TESTNET_PEER_PORT = 6874;
    private static final String myPlatform;
    private static final String myAddress;
    private static final int myPeerServerPort;
    private static final String myHallmark;
    private static final boolean shareMyAddress;
    private static final boolean enablePeerUPnP;
    private static final int maxNumberOfInboundConnections;
    private static final int maxNumberOfOutboundConnections;
    public static final int maxNumberOfConnectedPublicPeers;
    private static final int maxNumberOfKnownPeers;
    private static final int minNumberOfKnownPeers;
    private static final boolean enableHallmarkProtection;
    private static final int pushThreshold;
    private static final int pullThreshold;
    private static final int sendToPeersLimit;
    private static final boolean usePeersDb;
    private static final boolean savePeers;
    static final boolean ignorePeerAnnouncedAddress;
    static final boolean cjdnsOnly;
    static final int MAX_VERSION_LENGTH = 10;
    static final int MAX_APPLICATION_LENGTH = 20;
    static final int MAX_PLATFORM_LENGTH = 30;
    static final int MAX_ANNOUNCED_ADDRESS_LENGTH = 100;
    static final boolean hideErrorDetails;
    private static final JSONObject myPeerInfo;
    private static final List<Peer.Service> myServices;
    private static volatile Peer.BlockchainState currentBlockchainState;
    private static volatile JSONStreamAware myPeerInfoRequest;
    private static volatile JSONStreamAware myPeerInfoResponse;
    private static final Listeners<Peer, Event> listeners;
    private static final ConcurrentMap<String, PeerImpl> peers;
    private static final ConcurrentMap<String, String> selfAnnouncedAddresses;
    static final Collection<PeerImpl> allPeers;
    static final ExecutorService peersService;
    private static final ExecutorService sendingService;
    private static volatile boolean isNetworkingEnabled;
    private static final Runnable peerUnBlacklistingThread;
    private static final Runnable peerConnectingThread;
    private static final Runnable getMorePeersThread;
    private static final int sendTransactionsBatchSize = 10;
    private static final int[] MAX_VERSION;

    public static void init() {
        Init.init();
    }

    public static void shutdown() {
        if (Init.peerServer != null) {
            try {
                Init.peerServer.stop();
                if (enablePeerUPnP) {
                    Connector[] connectorArray;
                    for (Connector connector : connectorArray = Init.peerServer.getConnectors()) {
                        if (!(connector instanceof ServerConnector)) continue;
                        UPnP.deletePort(((ServerConnector)connector).getPort());
                    }
                }
            }
            catch (Exception exception) {
                Logger.logShutdownMessage("Failed to stop peer server", exception);
            }
        }
        ThreadPool.shutdownExecutor("sendingService", sendingService, 2);
        ThreadPool.shutdownExecutor("peersService", peersService, 5);
    }

    public static void disableNetworking() {
        isNetworkingEnabled = false;
    }

    public static void enableNetworking() {
        isNetworkingEnabled = true;
    }

    public static boolean isNetworkingEnabled() {
        return isNetworkingEnabled;
    }

    public static boolean addListener(Listener<Peer> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Peer> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    static void notifyListeners(Peer peer, Event event) {
        listeners.notify(peer, event);
    }

    public static int getDefaultPeerPort() {
        return Constants.isTestnet ? 6874 : 7874;
    }

    public static Collection<? extends Peer> getAllPeers() {
        return allPeers;
    }

    public static List<Peer> getActivePeers() {
        return Peers.getPeers((Peer peer) -> peer.getState() != Peer.State.NON_CONNECTED);
    }

    public static List<Peer> getPeers(Peer.State state) {
        return Peers.getPeers((Peer peer) -> peer.getState() == state);
    }

    public static List<Peer> getPeers(Filter<Peer> filter) {
        return Peers.getPeers(filter, Integer.MAX_VALUE);
    }

    public static List<Peer> getPeers(Filter<Peer> filter, int n) {
        ArrayList<Peer> arrayList = new ArrayList<Peer>();
        for (Peer peer : peers.values()) {
            if (!filter.ok(peer)) continue;
            arrayList.add(peer);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public static Peer getPeer(String string) {
        return (Peer)peers.get(string);
    }

    public static List<Peer> getInboundPeers() {
        return Peers.getPeers(Peer::isInbound);
    }

    public static boolean hasTooManyInboundPeers() {
        return Peers.getPeers(Peer::isInbound, maxNumberOfInboundConnections).size() >= maxNumberOfInboundConnections;
    }

    public static boolean hasTooManyOutboundConnections() {
        return Peers.getPeers(peer -> !peer.isBlacklisted() && peer.getState() == Peer.State.CONNECTED && peer.getAnnouncedAddress() != null, maxNumberOfOutboundConnections).size() >= maxNumberOfOutboundConnections;
    }

    public static PeerImpl findOrCreatePeer(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        PeerImpl peerImpl = (PeerImpl)peers.get(string = string.trim().toLowerCase());
        if (peerImpl != null) {
            return peerImpl;
        }
        String string2 = (String)selfAnnouncedAddresses.get(string);
        if (string2 != null && (peerImpl = (PeerImpl)peers.get(string2)) != null) {
            return peerImpl;
        }
        try {
            URI uRI = new URI("http://" + string);
            string2 = uRI.getHost();
            if (string2 == null) {
                return null;
            }
            peerImpl = (PeerImpl)peers.get(string2);
            if (peerImpl != null) {
                return peerImpl;
            }
            String string3 = (String)selfAnnouncedAddresses.get(string2);
            if (string3 != null && (peerImpl = (PeerImpl)peers.get(string3)) != null) {
                return peerImpl;
            }
            InetAddress inetAddress = InetAddress.getByName(string2);
            return Peers.findOrCreatePeer(inetAddress, Peers.addressWithPort(string), bl);
        }
        catch (URISyntaxException | UnknownHostException exception) {
            return null;
        }
    }

    static PeerImpl findOrCreatePeer(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return Peers.findOrCreatePeer(inetAddress, null, true);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    static PeerImpl findOrCreatePeer(InetAddress inetAddress, String string, boolean bl) {
        PeerImpl peerImpl;
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) {
            return null;
        }
        String string2 = inetAddress.getHostAddress();
        if (cjdnsOnly && !string2.substring(0, 2).equals("fc")) {
            return null;
        }
        if (string2.split(":").length > 2) {
            string2 = "[" + string2 + "]";
        }
        if ((peerImpl = (PeerImpl)peers.get(string2)) != null) {
            return peerImpl;
        }
        if (!bl) {
            return null;
        }
        if (myAddress != null && myAddress.equalsIgnoreCase(string)) {
            return null;
        }
        if (string != null && string.length() > 100) {
            return null;
        }
        peerImpl = new PeerImpl(string2, string);
        if (Constants.isTestnet && peerImpl.getPort() != 6874) {
            Logger.logDebugMessage("Peer " + string2 + " on testnet is not using port " + 6874 + ", ignoring");
            return null;
        }
        if (!Constants.isTestnet && peerImpl.getPort() == 6874) {
            Logger.logDebugMessage("Peer " + string2 + " is using testnet port " + peerImpl.getPort() + ", ignoring");
            return null;
        }
        return peerImpl;
    }

    static void setAnnouncedAddress(PeerImpl peerImpl, String string) {
        String string2;
        Peer peer = (Peer)peers.get(peerImpl.getHost());
        if (peer != null && (string2 = peer.getAnnouncedAddress()) != null && !string2.equals(string)) {
            Logger.logDebugMessage("Removing old announced address " + string2 + " for peer " + peer.getHost());
            selfAnnouncedAddresses.remove(string2);
        }
        if (string != null && (string2 = selfAnnouncedAddresses.put(string, peerImpl.getHost())) != null && !peerImpl.getHost().equals(string2)) {
            Logger.logDebugMessage("Announced address " + string + " now maps to peer " + peerImpl.getHost() + ", removing old peer " + string2);
            peer = (Peer)peers.remove(string2);
            if (peer != null) {
                Peers.notifyListeners(peer, Event.REMOVE);
            }
        }
        peerImpl.setAnnouncedAddress(string);
    }

    public static boolean addPeer(Peer peer, String string) {
        Peers.setAnnouncedAddress((PeerImpl)peer, string.toLowerCase());
        return Peers.addPeer(peer);
    }

    public static boolean addPeer(Peer peer) {
        if (peers.put(peer.getHost(), (PeerImpl)peer) == null) {
            listeners.notify(peer, Event.NEW_PEER);
            return true;
        }
        return false;
    }

    public static PeerImpl removePeer(Peer peer) {
        if (peer.getAnnouncedAddress() != null) {
            selfAnnouncedAddresses.remove(peer.getAnnouncedAddress());
        }
        return (PeerImpl)peers.remove(peer.getHost());
    }

    public static void connectPeer(Peer peer) {
        peer.unBlacklist();
        ((PeerImpl)peer).connect();
    }

    public static void sendToSomePeers(Block block) {
        JSONObject jSONObject = block.getJSONObject();
        jSONObject.put((Object)"requestType", (Object)"processBlock");
        Peers.sendToSomePeers(jSONObject);
    }

    public static void sendToSomePeers(List<? extends Transaction> list) {
        for (int i = 0; i < list.size(); i += 10) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (int j = i; j < i + 10 && j < list.size(); ++j) {
                jSONArray.add((Object)list.get(j).getJSONObject());
            }
            jSONObject.put((Object)"requestType", (Object)"processTransactions");
            jSONObject.put((Object)"transactions", (Object)jSONArray);
            Peers.sendToSomePeers(jSONObject);
        }
    }

    private static void sendToSomePeers(JSONObject jSONObject) {
        sendingService.submit(() -> {
            JSONStreamAware jSONStreamAware = JSON.prepareRequest(jSONObject);
            int n = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Peer peer : peers.values()) {
                if (enableHallmarkProtection && peer.getWeight() < pushThreshold) continue;
                if (!peer.isBlacklisted() && peer.getState() == Peer.State.CONNECTED && peer.getAnnouncedAddress() != null && peer.getBlockchainState() != Peer.BlockchainState.LIGHT_CLIENT) {
                    Future<JSONObject> future = peersService.submit(() -> peer.send(jSONStreamAware));
                    arrayList.add(future);
                }
                if (arrayList.size() >= sendToPeersLimit - n) {
                    for (Future future : arrayList) {
                        try {
                            JSONObject jSONObject2 = (JSONObject)future.get();
                            if (jSONObject2 == null || jSONObject2.get((Object)"error") != null) continue;
                            ++n;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException executionException) {
                            Logger.logDebugMessage("Error in sendToSomePeers", executionException);
                        }
                    }
                    arrayList.clear();
                }
                if (n < sendToPeersLimit) continue;
                return;
            }
        });
    }

    public static Peer getAnyPeer(Peer.State state, boolean bl) {
        return Peers.getWeightedPeer(Peers.getPublicPeers(state, bl));
    }

    public static List<Peer> getPublicPeers(Peer.State state, boolean bl) {
        return Peers.getPeers((Peer peer) -> !peer.isBlacklisted() && peer.getState() == state && peer.shareAddress() && (!bl || !enableHallmarkProtection || peer.getWeight() >= pullThreshold));
    }

    public static Peer getWeightedPeer(List<Peer> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (!enableHallmarkProtection || ThreadLocalRandom.current().nextInt(3) == 0) {
            return list.get(ThreadLocalRandom.current().nextInt(list.size()));
        }
        long l = 0L;
        for (Peer peer : list) {
            long l2 = peer.getWeight();
            if (l2 == 0L) {
                l2 = 1L;
            }
            l += l2;
        }
        long l3 = ThreadLocalRandom.current().nextLong(l);
        for (Peer peer : list) {
            long l4 = peer.getWeight();
            if (l4 == 0L) {
                l4 = 1L;
            }
            if ((l3 -= l4) >= 0L) continue;
            return peer;
        }
        return null;
    }

    static String addressWithPort(String string) {
        if (string == null) {
            return null;
        }
        try {
            URI uRI = new URI("http://" + string);
            String string2 = uRI.getHost();
            int n = uRI.getPort();
            return n > 0 && n != Peers.getDefaultPeerPort() ? string2 + ":" + n : string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static boolean isOldVersion(String string, int[] nArray) {
        if (string == null) {
            return true;
        }
        if (string.endsWith("e")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < nArray.length && i < stringArray.length; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n > nArray[i]) {
                    return false;
                }
                if (n >= nArray[i]) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return stringArray.length < nArray.length;
    }

    public static boolean isNewVersion(String string) {
        if (string == null) {
            return true;
        }
        if (string.endsWith("e")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < MAX_VERSION.length && i < stringArray.length; ++i) {
            try {
                int n = Integer.parseInt(stringArray[i]);
                if (n > MAX_VERSION[i]) {
                    return true;
                }
                if (n >= MAX_VERSION[i]) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
        return stringArray.length > MAX_VERSION.length;
    }

    public static boolean hasTooFewKnownPeers() {
        return peers.size() < minNumberOfKnownPeers;
    }

    public static boolean hasTooManyKnownPeers() {
        return peers.size() > maxNumberOfKnownPeers;
    }

    private static boolean hasEnoughConnectedPublicPeers(int n) {
        return Peers.getPeers(peer -> !peer.isBlacklisted() && peer.getState() == Peer.State.CONNECTED && peer.shareAddress() && (!enableHallmarkProtection || peer.getWeight() > 0), n).size() >= n;
    }

    public static boolean setCommunicationLoggingMask(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string;
                switch (string = stringArray2[i]) {
                    case "EXCEPTION": {
                        n |= 1;
                        break;
                    }
                    case "HTTP-ERROR": {
                        n |= 2;
                        break;
                    }
                    case "HTTP-OK": {
                        n |= 4;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (!bl) break;
            }
        }
        if (bl) {
            communicationLoggingMask = n;
        }
        return bl;
    }

    public static List<Peer.Service> getServices() {
        return myServices;
    }

    private static void checkBlockchainState() {
        Peer.BlockchainState blockchainState;
        Peer.BlockchainState blockchainState2 = Constants.isLightClient ? Peer.BlockchainState.LIGHT_CLIENT : (blockchainState = Nxt.getBlockchainProcessor().isDownloading() || Nxt.getBlockchain().getLastBlockTimestamp() < Nxt.getEpochTime() - 600 ? Peer.BlockchainState.DOWNLOADING : Peer.BlockchainState.UP_TO_DATE);
        if (blockchainState != currentBlockchainState) {
            JSONObject jSONObject = new JSONObject((Map)myPeerInfo);
            jSONObject.put((Object)"blockchainState", (Object)blockchainState.ordinal());
            myPeerInfoResponse = JSON.prepare(jSONObject);
            jSONObject.put((Object)"requestType", (Object)"getInfo");
            myPeerInfoRequest = JSON.prepareRequest(jSONObject);
            currentBlockchainState = blockchainState;
        }
    }

    public static JSONStreamAware getMyPeerInfoRequest() {
        Peers.checkBlockchainState();
        return myPeerInfoRequest;
    }

    public static JSONStreamAware getMyPeerInfoResponse() {
        Peers.checkBlockchainState();
        return myPeerInfoResponse;
    }

    public static Peer.BlockchainState getMyBlockchainState() {
        Peers.checkBlockchainState();
        return currentBlockchainState;
    }

    private Peers() {
    }

    private static /* synthetic */ void lambda$static$1(List list) {
        for (Future future : list) {
            try {
                String string = (String)future.get(5L, TimeUnit.SECONDS);
                if (string == null) continue;
                Logger.logDebugMessage("Failed to resolve peer address: " + string);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                Logger.logDebugMessage("Failed to add peer", executionException);
            }
            catch (TimeoutException timeoutException) {}
        }
        Logger.logDebugMessage("Known peers: " + peers.size());
    }

    static {
        Object object;
        Object object2;
        Object object3;
        JSONObject jSONObject;
        Object object4;
        useProxy = System.getProperty("socksProxyHost") != null || System.getProperty("http.proxyHost") != null;
        hideErrorDetails = Nxt.getBooleanProperty("nxt.hideErrorDetails");
        listeners = new Listeners();
        peers = new ConcurrentHashMap<String, PeerImpl>();
        selfAnnouncedAddresses = new ConcurrentHashMap<String, String>();
        allPeers = Collections.unmodifiableCollection(peers.values());
        peersService = new QueuedThreadPool(2, 15);
        sendingService = Executors.newFixedThreadPool(10);
        isNetworkingEnabled = true;
        String string = Nxt.getStringProperty("nxt.myPlatform", System.getProperty("os.name") + " " + System.getProperty("os.arch"));
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        myPlatform = string;
        myAddress = Convert.emptyToNull(Nxt.getStringProperty("nxt.myAddress", "").trim());
        if (myAddress != null && myAddress.endsWith(":6874") && !Constants.isTestnet) {
            throw new RuntimeException("Port 6874 should only be used for testnet!!!");
        }
        String[] stringArray = null;
        int n = -1;
        if (myAddress != null) {
            try {
                Object object5;
                object4 = new URI("http://" + myAddress);
                stringArray = ((URI)object4).getHost();
                n = ((URI)object4).getPort() == -1 ? Peers.getDefaultPeerPort() : ((URI)object4).getPort();
                jSONObject = InetAddress.getAllByName((String)stringArray);
                boolean bl = false;
                object3 = NetworkInterface.getNetworkInterfaces();
                block7: while (object3.hasMoreElements()) {
                    object5 = object3.nextElement();
                    object2 = ((NetworkInterface)object5).getInterfaceAddresses();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        InterfaceAddress interfaceAddress = (InterfaceAddress)object.next();
                        InetAddress inetAddress = interfaceAddress.getAddress();
                        for (JSONObject jSONObject2 : jSONObject) {
                            if (!inetAddress.equals(jSONObject2)) continue;
                            bl = true;
                            break block7;
                        }
                    }
                }
                if (!bl && (object5 = UPnP.getExternalAddress()) != null) {
                    for (InetAddress inetAddress : jSONObject) {
                        if (!((InetAddress)object5).equals(inetAddress)) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    Logger.logWarningMessage("Your announced address does not match your external address");
                }
            }
            catch (SocketException socketException) {
                Logger.logErrorMessage("Unable to enumerate the network interfaces :" + socketException.toString());
            }
            catch (URISyntaxException | UnknownHostException exception) {
                Logger.logWarningMessage("Your announced address is not valid: " + exception.toString());
            }
        }
        if ((myPeerServerPort = Nxt.getIntProperty("nxt.peerServerPort")) == 6874 && !Constants.isTestnet) {
            throw new RuntimeException("Port 6874 should only be used for testnet!!!");
        }
        shareMyAddress = Nxt.getBooleanProperty("nxt.shareMyAddress") && !Constants.isOffline;
        enablePeerUPnP = Nxt.getBooleanProperty("nxt.enablePeerUPnP");
        myHallmark = Convert.emptyToNull(Nxt.getStringProperty("nxt.myHallmark", "").trim());
        if (myHallmark != null && myHallmark.length() > 0) {
            try {
                object4 = Hallmark.parseHallmark(myHallmark);
                if (!((Hallmark)object4).isValid()) {
                    throw new RuntimeException("Hallmark is not valid");
                }
                if (myAddress != null) {
                    if (!((Hallmark)object4).getHost().equals(stringArray)) {
                        throw new RuntimeException("Invalid hallmark host");
                    }
                    if (n != ((Hallmark)object4).getPort()) {
                        throw new RuntimeException("Invalid hallmark port");
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Your hallmark is invalid: " + myHallmark + " for your address: " + myAddress);
                throw new RuntimeException(runtimeException.toString(), runtimeException);
            }
        }
        object4 = new ArrayList();
        jSONObject = new JSONObject();
        if (myAddress != null) {
            try {
                URI uRI = new URI("http://" + myAddress);
                object3 = uRI.getHost();
                int n2 = uRI.getPort();
                object2 = !Constants.isTestnet ? (n2 >= 0 ? myAddress : (String)object3 + (myPeerServerPort != 7874 ? ":" + myPeerServerPort : "")) : object3;
                if (object2 == null || ((String)object2).length() > 100) {
                    throw new RuntimeException("Invalid announced address length: " + (String)object2);
                }
                jSONObject.put((Object)"announcedAddress", object2);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.logMessage("Your announce address is invalid: " + myAddress);
                throw new RuntimeException(uRISyntaxException.toString(), uRISyntaxException);
            }
        }
        if (myHallmark != null && myHallmark.length() > 0) {
            jSONObject.put((Object)"hallmark", (Object)myHallmark);
            object4.add(Peer.Service.HALLMARK);
        }
        jSONObject.put((Object)"application", (Object)"NRS");
        jSONObject.put((Object)"version", (Object)"1.13.1");
        jSONObject.put((Object)"platform", (Object)myPlatform);
        jSONObject.put((Object)"shareAddress", (Object)shareMyAddress);
        if (!Constants.ENABLE_PRUNING && Constants.INCLUDE_EXPIRED_PRUNABLE) {
            object4.add(Peer.Service.PRUNABLE);
        }
        if (API.openAPIPort > 0) {
            jSONObject.put((Object)"apiPort", (Object)API.openAPIPort);
            object4.add(Peer.Service.API);
        }
        if (API.openAPISSLPort > 0) {
            jSONObject.put((Object)"apiSSLPort", (Object)API.openAPISSLPort);
            object4.add(Peer.Service.API_SSL);
        }
        if (API.isOpenAPI) {
            EnumSet<APIEnum> enumSet = EnumSet.noneOf(APIEnum.class);
            enumSet.addAll(API.getDisabledApis());
            API.getDisabledApiTags().forEach(aPITag -> {
                for (APIEnum aPIEnum : APIEnum.values()) {
                    if (aPIEnum.getHandler() == null || !aPIEnum.getHandler().getAPITags().contains(aPITag)) continue;
                    enumSet.add(aPIEnum);
                }
            });
            jSONObject.put((Object)"disabledAPIs", (Object)APIEnum.enumSetToBase64String(enumSet));
            jSONObject.put((Object)"apiServerIdleTimeout", (Object)API.apiServerIdleTimeout);
            if (API.apiServerCORS) {
                object4.add(Peer.Service.CORS);
            }
        }
        long l = 0L;
        Object object6 = object4.iterator();
        while (object6.hasNext()) {
            object2 = (Peer.Service)((Object)object6.next());
            l |= ((Peer.Service)((Object)object2)).getCode();
        }
        jSONObject.put((Object)"services", (Object)Long.toUnsignedString(l));
        myServices = Collections.unmodifiableList(object4);
        Logger.logDebugMessage("My peer info:\n" + jSONObject.toJSONString());
        myPeerInfo = jSONObject;
        object6 = Constants.isTestnet ? Nxt.getStringListProperty("nxt.defaultTestnetPeers") : Nxt.getStringListProperty("nxt.defaultPeers");
        wellKnownPeers = Collections.unmodifiableList(Constants.isTestnet ? Nxt.getStringListProperty("nxt.testnetPeers") : Nxt.getStringListProperty("nxt.wellKnownPeers"));
        object2 = Nxt.getStringListProperty("nxt.knownBlacklistedPeers");
        knownBlacklistedPeers = object2.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet(object2));
        maxNumberOfInboundConnections = Nxt.getIntProperty("nxt.maxNumberOfInboundConnections");
        maxNumberOfOutboundConnections = Nxt.getIntProperty("nxt.maxNumberOfOutboundConnections");
        maxNumberOfConnectedPublicPeers = Math.min(Nxt.getIntProperty("nxt.maxNumberOfConnectedPublicPeers"), maxNumberOfOutboundConnections);
        maxNumberOfKnownPeers = Nxt.getIntProperty("nxt.maxNumberOfKnownPeers");
        minNumberOfKnownPeers = Nxt.getIntProperty("nxt.minNumberOfKnownPeers");
        connectTimeout = Nxt.getIntProperty("nxt.connectTimeout");
        readTimeout = Nxt.getIntProperty("nxt.readTimeout");
        enableHallmarkProtection = Nxt.getBooleanProperty("nxt.enableHallmarkProtection") && !Constants.isLightClient;
        pushThreshold = Nxt.getIntProperty("nxt.pushThreshold");
        pullThreshold = Nxt.getIntProperty("nxt.pullThreshold");
        useWebSockets = Nxt.getBooleanProperty("nxt.useWebSockets");
        webSocketIdleTimeout = Nxt.getIntProperty("nxt.webSocketIdleTimeout");
        isGzipEnabled = Nxt.getBooleanProperty("nxt.enablePeerServerGZIPFilter");
        blacklistingPeriod = Nxt.getIntProperty("nxt.blacklistingPeriod") / 1000;
        communicationLoggingMask = Nxt.getIntProperty("nxt.communicationLoggingMask");
        sendToPeersLimit = Nxt.getIntProperty("nxt.sendToPeersLimit");
        usePeersDb = Nxt.getBooleanProperty("nxt.usePeersDb") && !Constants.isOffline;
        savePeers = usePeersDb && Nxt.getBooleanProperty("nxt.savePeers");
        getMorePeers = Nxt.getBooleanProperty("nxt.getMorePeers");
        cjdnsOnly = Nxt.getBooleanProperty("nxt.cjdnsOnly");
        ignorePeerAnnouncedAddress = Nxt.getBooleanProperty("nxt.ignorePeerAnnouncedAddress");
        if (useWebSockets && useProxy) {
            Logger.logMessage("Using a proxy, will not create outbound websockets.");
        }
        object = Collections.synchronizedList(new ArrayList());
        if (!Constants.isOffline) {
            ThreadPool.runBeforeStart(new Runnable((List)object6, (List)object){
                private final Set<PeerDb.Entry> entries = new HashSet<PeerDb.Entry>();
                final /* synthetic */ List val$defaultPeers;
                final /* synthetic */ List val$unresolvedPeers;
                {
                    this.val$defaultPeers = list;
                    this.val$unresolvedPeers = list2;
                }

                @Override
                public void run() {
                    int n = Nxt.getEpochTime();
                    wellKnownPeers.forEach(string -> this.entries.add(new PeerDb.Entry((String)string, 0L, n)));
                    if (usePeersDb) {
                        Logger.logDebugMessage("Loading known peers from the database...");
                        this.val$defaultPeers.forEach(string -> this.entries.add(new PeerDb.Entry((String)string, 0L, n)));
                        if (savePeers) {
                            List<PeerDb.Entry> list = PeerDb.loadPeers();
                            list.forEach(entry -> {
                                if (!this.entries.add((PeerDb.Entry)entry)) {
                                    this.entries.remove(entry);
                                    this.entries.add((PeerDb.Entry)entry);
                                }
                            });
                        }
                    }
                    this.entries.forEach(entry -> {
                        Future<String> future = peersService.submit(() -> {
                            PeerImpl peerImpl = Peers.findOrCreatePeer(entry.getAddress(), true);
                            if (peerImpl != null) {
                                peerImpl.setLastUpdated(entry.getLastUpdated());
                                peerImpl.setServices(entry.getServices());
                                Peers.addPeer(peerImpl);
                                return null;
                            }
                            return entry.getAddress();
                        });
                        this.val$unresolvedPeers.add(future);
                    });
                }
            }, false);
        }
        ThreadPool.runAfterStart(() -> Peers.lambda$static$1((List)object));
        peerUnBlacklistingThread = () -> {
            try {
                try {
                    int n = Nxt.getEpochTime();
                    for (PeerImpl peerImpl : peers.values()) {
                        peerImpl.updateBlacklistedStatus(n);
                    }
                }
                catch (Exception exception) {
                    Logger.logDebugMessage("Error un-blacklisting peer", exception);
                }
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                System.exit(1);
            }
        };
        peerConnectingThread = new Runnable(){

            @Override
            public void run() {
                if (!Peers.isNetworkingEnabled()) {
                    return;
                }
                try {
                    try {
                        Object object3;
                        Object object22;
                        int n = Nxt.getEpochTime();
                        if (!Peers.hasEnoughConnectedPublicPeers(maxNumberOfConnectedPublicPeers)) {
                            ArrayList arrayList = new ArrayList();
                            object22 = Peers.getPeers(peer -> !peer.isBlacklisted() && peer.getState() != Peer.State.CONNECTED && n - peer.getLastConnectAttempt() > 600 && peer.providesService(Peer.Service.HALLMARK));
                            object3 = Peers.getPeers(peer -> !peer.isBlacklisted() && peer.getState() != Peer.State.CONNECTED && n - peer.getLastConnectAttempt() > 600 && !peer.providesService(Peer.Service.HALLMARK));
                            if (!object22.isEmpty() || !object3.isEmpty()) {
                                PriorityQueue priorityQueue;
                                HashSet<PeerImpl> hashSet = new HashSet<PeerImpl>();
                                for (int i = 0; i < 10; ++i) {
                                    priorityQueue = object22.isEmpty() ? object3 : (object3.isEmpty() ? object22 : (ThreadLocalRandom.current().nextInt(2) == 0 ? object22 : object3));
                                    hashSet.add((PeerImpl)priorityQueue.get(ThreadLocalRandom.current().nextInt(priorityQueue.size())));
                                }
                                hashSet.forEach(peerImpl -> arrayList.add(peersService.submit(() -> {
                                    peerImpl.connect();
                                    if (peerImpl.getState() == Peer.State.CONNECTED && enableHallmarkProtection && peerImpl.getWeight() == 0 && Peers.hasTooManyOutboundConnections()) {
                                        Logger.logDebugMessage("Too many outbound connections, deactivating peer " + peerImpl.getHost());
                                        peerImpl.deactivate();
                                    }
                                    return null;
                                })));
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    priorityQueue = (Future)iterator.next();
                                    priorityQueue.get();
                                }
                            }
                        }
                        peers.values().forEach(peerImpl -> {
                            if (peerImpl.getState() == Peer.State.CONNECTED && n - peerImpl.getLastUpdated() > 3600 && n - peerImpl.getLastConnectAttempt() > 600) {
                                peersService.submit(peerImpl::connect);
                            }
                            if (peerImpl.getLastInboundRequest() != 0 && n - peerImpl.getLastInboundRequest() > webSocketIdleTimeout / 1000) {
                                peerImpl.setLastInboundRequest(0);
                                Peers.notifyListeners(peerImpl, Event.REMOVE_INBOUND);
                            }
                        });
                        if (Peers.hasTooManyKnownPeers() && Peers.hasEnoughConnectedPublicPeers(maxNumberOfConnectedPublicPeers)) {
                            int n2 = peers.size();
                            for (Object object3 : peers.values()) {
                                if (n - ((PeerImpl)object3).getLastUpdated() > 86400) {
                                    ((PeerImpl)object3).remove();
                                }
                                if (!Peers.hasTooFewKnownPeers()) continue;
                                break;
                            }
                            if (Peers.hasTooManyKnownPeers()) {
                                object22 = new PriorityQueue(peers.values());
                                for (int i = 0; i < minNumberOfKnownPeers && ((PriorityQueue)object22).poll() != null; ++i) {
                                }
                                while (!((AbstractCollection)object22).isEmpty()) {
                                    ((PeerImpl)((PriorityQueue)object22).poll()).remove();
                                }
                            }
                            Logger.logDebugMessage("Reduced peer pool size from " + n2 + " to " + peers.size());
                        }
                        for (Object object22 : wellKnownPeers) {
                            object3 = Peers.findOrCreatePeer((String)object22, true);
                            if (object3 == null || n - ((PeerImpl)object3).getLastUpdated() <= 3600 || n - ((PeerImpl)object3).getLastConnectAttempt() <= 600) continue;
                            peersService.submit(() -> {
                                Peers.addPeer(object3);
                                Peers.connectPeer(object3);
                            });
                        }
                    }
                    catch (Exception exception) {
                        Logger.logDebugMessage("Error connecting to peer", exception);
                    }
                }
                catch (Throwable throwable) {
                    Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                    System.exit(1);
                }
            }
        };
        getMorePeersThread = new Runnable(){
            private final JSONStreamAware getPeersRequest;
            private volatile boolean updatedPeer;
            {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"requestType", (Object)"getPeers");
                this.getPeersRequest = JSON.prepareRequest(jSONObject);
            }

            @Override
            public void run() {
                try {
                    try {
                        JSONArray jSONArray;
                        if (Peers.hasTooManyKnownPeers()) {
                            return;
                        }
                        Peer peer = Peers.getAnyPeer(Peer.State.CONNECTED, true);
                        if (peer == null) {
                            return;
                        }
                        JSONObject jSONObject = peer.send(this.getPeersRequest, 0xA00000);
                        if (jSONObject == null) {
                            return;
                        }
                        JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"peers");
                        HashSet<String> hashSet = new HashSet<String>();
                        if (jSONArray2 != null) {
                            jSONArray = (JSONArray)jSONObject.get((Object)"services");
                            boolean bl = jSONArray != null && jSONArray.size() == jSONArray2.size();
                            int n = Nxt.getEpochTime();
                            for (int i = 0; i < jSONArray2.size(); ++i) {
                                String string = (String)jSONArray2.get(i);
                                PeerImpl peerImpl = Peers.findOrCreatePeer(string, true);
                                if (peerImpl == null) continue;
                                if (n - peerImpl.getLastUpdated() > 86400) {
                                    peerImpl.setLastUpdated(n);
                                    this.updatedPeer = true;
                                }
                                if (Peers.addPeer(peerImpl) && bl) {
                                    peerImpl.setServices(Long.parseUnsignedLong((String)jSONArray.get(i)));
                                }
                                hashSet.add(string);
                                if (Peers.hasTooManyKnownPeers()) break;
                            }
                            if (savePeers && this.updatedPeer) {
                                this.updateSavedPeers();
                                this.updatedPeer = false;
                            }
                        }
                        jSONArray = new JSONArray();
                        JSONArray jSONArray3 = new JSONArray();
                        Peers.getAllPeers().forEach(peer2 -> {
                            if (!peer2.isBlacklisted() && peer2.getAnnouncedAddress() != null && peer2.getState() == Peer.State.CONNECTED && peer2.shareAddress() && !hashSet.contains(peer2.getAnnouncedAddress()) && !peer2.getAnnouncedAddress().equals(peer.getAnnouncedAddress())) {
                                jSONArray.add((Object)peer2.getAnnouncedAddress());
                                jSONArray3.add((Object)Long.toUnsignedString(((PeerImpl)peer2).getServices()));
                            }
                        });
                        if (jSONArray.size() > 0) {
                            JSONObject jSONObject2 = new JSONObject();
                            jSONObject2.put((Object)"requestType", (Object)"addPeers");
                            jSONObject2.put((Object)"peers", (Object)jSONArray);
                            jSONObject2.put((Object)"services", (Object)jSONArray3);
                            peer.send(JSON.prepareRequest(jSONObject2), 0);
                        }
                    }
                    catch (Exception exception) {
                        Logger.logDebugMessage("Error requesting peers from a peer", exception);
                    }
                }
                catch (Throwable throwable) {
                    Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS", throwable);
                    System.exit(1);
                }
            }

            private void updateSavedPeers() {
                int n = Nxt.getEpochTime();
                List<PeerDb.Entry> list = PeerDb.loadPeers();
                HashMap hashMap = new HashMap(list.size());
                list.forEach(entry -> hashMap.put(entry.getAddress(), entry));
                HashMap hashMap2 = new HashMap();
                peers.values().forEach(peerImpl -> {
                    if (peerImpl.getAnnouncedAddress() != null && !peerImpl.isBlacklisted() && n - peerImpl.getLastUpdated() < 604800) {
                        hashMap2.put(peerImpl.getAnnouncedAddress(), new PeerDb.Entry(peerImpl.getAnnouncedAddress(), peerImpl.getServices(), peerImpl.getLastUpdated()));
                    }
                });
                ArrayList<PeerDb.Entry> arrayList = new ArrayList<PeerDb.Entry>(list.size());
                list.forEach(entry -> {
                    if (hashMap2.get(entry.getAddress()) == null) {
                        arrayList.add((PeerDb.Entry)entry);
                    }
                });
                ArrayList<PeerDb.Entry> arrayList2 = new ArrayList<PeerDb.Entry>(hashMap2.size());
                hashMap2.values().forEach(entry -> {
                    PeerDb.Entry entry2 = (PeerDb.Entry)hashMap.get(entry.getAddress());
                    if (entry2 == null || entry.getLastUpdated() - entry2.getLastUpdated() > 86400) {
                        arrayList2.add((PeerDb.Entry)entry);
                    }
                });
                if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                    return;
                }
                try {
                    Db.db.beginTransaction();
                    PeerDb.deletePeers(arrayList);
                    PeerDb.updatePeers(arrayList2);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                }
            }
        };
        Peers.addListener(peer -> peersService.submit(() -> {
            if (peer.getAnnouncedAddress() != null && !peer.isBlacklisted()) {
                try {
                    Db.db.beginTransaction();
                    PeerDb.updatePeer((PeerImpl)peer);
                    Db.db.commitTransaction();
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage("Unable to update peer database", runtimeException);
                    Db.db.rollbackTransaction();
                }
                finally {
                    Db.db.endTransaction();
                }
            }
        }), Event.CHANGED_SERVICES);
        Account.addListener((Account account) -> peers.values().forEach(peerImpl -> {
            if (peerImpl.getHallmark() != null && peerImpl.getHallmark().getAccountId() == account.getId()) {
                listeners.notify((Peer)peerImpl, Event.WEIGHT);
            }
        }), Account.Event.BALANCE);
        if (!Constants.isOffline) {
            ThreadPool.scheduleThread("PeerConnecting", peerConnectingThread, 20);
            ThreadPool.scheduleThread("PeerUnBlacklisting", peerUnBlacklistingThread, 60);
            if (getMorePeers) {
                ThreadPool.scheduleThread("GetMorePeers", getMorePeersThread, 20);
            }
        }
        if ((string = "1.13.1").endsWith("e")) {
            string = string.substring(0, string.length() - 1);
        }
        stringArray = string.split("\\.");
        MAX_VERSION = new int[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            Peers.MAX_VERSION[n] = Integer.parseInt(stringArray[n]);
        }
    }

    private static class Init {
        private static final Server peerServer;

        private static void init() {
        }

        private Init() {
        }

        static {
            if (shareMyAddress) {
                GzipHandler gzipHandler;
                peerServer = new Server();
                ServerConnector serverConnector = new ServerConnector(peerServer);
                int n = Constants.isTestnet ? 6874 : myPeerServerPort;
                serverConnector.setPort(n);
                String string = Nxt.getStringProperty("nxt.peerServerHost");
                serverConnector.setHost(string);
                serverConnector.setIdleTimeout((long)Nxt.getIntProperty("nxt.peerServerIdleTimeout"));
                serverConnector.setReuseAddress(true);
                peerServer.addConnector((Connector)serverConnector);
                ServletContextHandler servletContextHandler = new ServletContextHandler();
                servletContextHandler.setContextPath("/");
                ServletHolder servletHolder = new ServletHolder((Servlet)new PeerServlet());
                servletContextHandler.addServlet(servletHolder, "/*");
                if (Nxt.getBooleanProperty("nxt.enablePeerServerDoSFilter")) {
                    gzipHandler = servletContextHandler.addFilter(DoSFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
                    gzipHandler.setInitParameter("maxRequestsPerSec", Nxt.getStringProperty("nxt.peerServerDoSFilter.maxRequestsPerSec"));
                    gzipHandler.setInitParameter("delayMs", Nxt.getStringProperty("nxt.peerServerDoSFilter.delayMs"));
                    gzipHandler.setInitParameter("maxRequestMs", Nxt.getStringProperty("nxt.peerServerDoSFilter.maxRequestMs"));
                    gzipHandler.setInitParameter("trackSessions", "false");
                    gzipHandler.setAsyncSupported(true);
                }
                if (isGzipEnabled) {
                    gzipHandler = new GzipHandler();
                    gzipHandler.setIncludedMethods(new String[]{"GET", "POST"});
                    gzipHandler.setIncludedPaths(new String[]{"/*"});
                    gzipHandler.setMinGzipSize(256);
                    servletContextHandler.setGzipHandler(gzipHandler);
                }
                peerServer.setHandler((Handler)servletContextHandler);
                peerServer.setStopAtShutdown(true);
                ThreadPool.runBeforeStart(() -> {
                    try {
                        if (enablePeerUPnP) {
                            Connector[] connectorArray;
                            for (Connector connector : connectorArray = peerServer.getConnectors()) {
                                if (!(connector instanceof ServerConnector)) continue;
                                UPnP.addPort(((ServerConnector)connector).getPort());
                            }
                        }
                        peerServer.start();
                        Logger.logMessage("Started peer networking server at " + string + ":" + n);
                    }
                    catch (Exception exception) {
                        Logger.logErrorMessage("Failed to start peer networking server", exception);
                        throw new RuntimeException(exception.toString(), exception);
                    }
                }, true);
            } else {
                peerServer = null;
                Logger.logMessage("shareMyAddress is disabled, will not start peer networking server");
            }
        }
    }

    public static enum Event {
        BLACKLIST,
        UNBLACKLIST,
        DEACTIVATE,
        REMOVE,
        DOWNLOADED_VOLUME,
        UPLOADED_VOLUME,
        WEIGHT,
        ADDED_ACTIVE_PEER,
        CHANGED_ACTIVE_PEER,
        NEW_PEER,
        ADD_INBOUND,
        REMOVE_INBOUND,
        CHANGED_SERVICES;

    }
}

