/*
 * Decompiled with CFR 0.152.
 */
package nxt.user;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import nxt.Block;
import nxt.Nxt;
import nxt.Transaction;
import nxt.db.DbIterator;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.user.User;
import nxt.user.UserServlet;
import nxt.user.Users;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetInitialData
extends UserServlet.UserRequestHandler {
    static final GetInitialData instance = new GetInitialData();

    private GetInitialData() {
    }

    @Override
    JSONStreamAware processRequest(HttpServletRequest httpServletRequest, User user) throws IOException {
        Object object;
        Object object2;
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = new JSONArray();
        JSONArray jSONArray4 = new JSONArray();
        JSONArray jSONArray5 = new JSONArray();
        Throwable object32 = null;
        try (Iterator<Object> iterator = Nxt.getTransactionProcessor().getAllUnconfirmedTransactions();){
            while (((DbIterator)iterator).hasNext()) {
                object2 = ((DbIterator)iterator).next();
                object = new JSONObject();
                object.put((Object)"index", (Object)Users.getIndex((Transaction)object2));
                object.put((Object)"timestamp", (Object)object2.getTimestamp());
                object.put((Object)"deadline", (Object)object2.getDeadline());
                object.put((Object)"recipient", (Object)Long.toUnsignedString(object2.getRecipientId()));
                object.put((Object)"amountNQT", (Object)object2.getAmountNQT());
                object.put((Object)"feeNQT", (Object)object2.getFeeNQT());
                object.put((Object)"sender", (Object)Long.toUnsignedString(object2.getSenderId()));
                object.put((Object)"id", (Object)object2.getStringId());
                jSONArray.add(object);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        for (Peer peer : Peers.getAllPeers()) {
            if (peer.isBlacklisted()) {
                object2 = new JSONObject();
                object2.put((Object)"index", (Object)Users.getIndex(peer));
                object2.put((Object)"address", (Object)peer.getHost());
                object2.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                object2.put((Object)"software", (Object)peer.getSoftware());
                jSONArray4.add(object2);
                continue;
            }
            if (peer.getState() == Peer.State.NON_CONNECTED) {
                object2 = new JSONObject();
                object2.put((Object)"index", (Object)Users.getIndex(peer));
                object2.put((Object)"address", (Object)peer.getHost());
                object2.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
                object2.put((Object)"software", (Object)peer.getSoftware());
                jSONArray3.add(object2);
                continue;
            }
            object2 = new JSONObject();
            object2.put((Object)"index", (Object)Users.getIndex(peer));
            if (peer.getState() == Peer.State.DISCONNECTED) {
                object2.put((Object)"disconnected", (Object)true);
            }
            object2.put((Object)"address", (Object)peer.getHost());
            object2.put((Object)"announcedAddress", (Object)Convert.truncate(peer.getAnnouncedAddress(), "-", 25, true));
            object2.put((Object)"weight", (Object)peer.getWeight());
            object2.put((Object)"downloaded", (Object)peer.getDownloadedVolume());
            object2.put((Object)"uploaded", (Object)peer.getUploadedVolume());
            object2.put((Object)"software", (Object)peer.getSoftware());
            jSONArray2.add(object2);
        }
        iterator = Nxt.getBlockchain().getBlocks(0, 59);
        Throwable throwable = null;
        try {
            object2 = ((DbIterator)iterator).iterator();
            while (object2.hasNext()) {
                object = (Block)object2.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"index", (Object)Users.getIndex((Block)object));
                jSONObject.put((Object)"timestamp", (Object)object.getTimestamp());
                jSONObject.put((Object)"numberOfTransactions", (Object)object.getTransactions().size());
                jSONObject.put((Object)"totalAmountNQT", (Object)object.getTotalAmountNQT());
                jSONObject.put((Object)"totalFeeNQT", (Object)object.getTotalFeeNQT());
                jSONObject.put((Object)"payloadLength", (Object)object.getPayloadLength());
                jSONObject.put((Object)"generator", (Object)Long.toUnsignedString(object.getGeneratorId()));
                jSONObject.put((Object)"height", (Object)object.getHeight());
                jSONObject.put((Object)"version", (Object)object.getVersion());
                jSONObject.put((Object)"block", (Object)object.getStringId());
                jSONObject.put((Object)"baseTarget", (Object)BigInteger.valueOf(object.getBaseTarget()).multiply(BigInteger.valueOf(100000L)).divide(BigInteger.valueOf(153722867L)));
                jSONArray5.add((Object)jSONObject);
            }
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
        finally {
            if (iterator != null) {
                if (throwable != null) {
                    try {
                        ((DbIterator)iterator).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((DbIterator)iterator).close();
                }
            }
        }
        iterator = new JSONObject();
        iterator.put("response", "processInitialData");
        iterator.put("version", "1.13.1");
        if (jSONArray.size() > 0) {
            iterator.put("unconfirmedTransactions", jSONArray);
        }
        if (jSONArray2.size() > 0) {
            iterator.put("activePeers", jSONArray2);
        }
        if (jSONArray3.size() > 0) {
            iterator.put("knownPeers", jSONArray3);
        }
        if (jSONArray4.size() > 0) {
            iterator.put("blacklistedPeers", jSONArray4);
        }
        if (jSONArray5.size() > 0) {
            iterator.put("recentBlocks", jSONArray5);
        }
        return iterator;
    }
}

