/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import nxt.Nxt;
import nxt.util.Logger;

public final class ThreadPool {
    private static volatile ScheduledExecutorService scheduledThreadPool;
    private static Map<Runnable, Long> backgroundJobs;
    private static List<Runnable> beforeStartJobs;
    private static List<Runnable> lastBeforeStartJobs;
    private static List<Runnable> afterStartJobs;

    public static synchronized void runBeforeStart(Runnable runnable, boolean bl) {
        if (scheduledThreadPool != null) {
            throw new IllegalStateException("Executor service already started");
        }
        if (bl) {
            lastBeforeStartJobs.add(runnable);
        } else {
            beforeStartJobs.add(runnable);
        }
    }

    public static synchronized void runAfterStart(Runnable runnable) {
        afterStartJobs.add(runnable);
    }

    public static synchronized void scheduleThread(String string, Runnable runnable, int n) {
        ThreadPool.scheduleThread(string, runnable, n, TimeUnit.SECONDS);
    }

    public static synchronized void scheduleThread(String string, Runnable runnable, int n, TimeUnit timeUnit) {
        if (scheduledThreadPool != null) {
            throw new IllegalStateException("Executor service already started, no new jobs accepted");
        }
        if (!Nxt.getBooleanProperty("nxt.disable" + string + "Thread")) {
            backgroundJobs.put(runnable, timeUnit.toMillis(n));
        } else {
            Logger.logMessage("Will not run " + string + " thread");
        }
    }

    public static synchronized void start(int n) {
        if (scheduledThreadPool != null) {
            throw new IllegalStateException("Executor service already started");
        }
        Logger.logDebugMessage("Running " + beforeStartJobs.size() + " tasks...");
        ThreadPool.runAll(beforeStartJobs);
        beforeStartJobs = null;
        Logger.logDebugMessage("Running " + lastBeforeStartJobs.size() + " final tasks...");
        ThreadPool.runAll(lastBeforeStartJobs);
        lastBeforeStartJobs = null;
        Logger.logDebugMessage("Starting " + backgroundJobs.size() + " background jobs");
        scheduledThreadPool = Executors.newScheduledThreadPool(backgroundJobs.size());
        for (Map.Entry<Runnable, Long> entry : backgroundJobs.entrySet()) {
            scheduledThreadPool.scheduleWithFixedDelay(entry.getKey(), 0L, Math.max(entry.getValue() / (long)n, 1L), TimeUnit.MILLISECONDS);
        }
        backgroundJobs = null;
        Logger.logDebugMessage("Starting " + afterStartJobs.size() + " delayed tasks");
        Thread thread = new Thread(() -> {
            ThreadPool.runAll(afterStartJobs);
            afterStartJobs = null;
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void shutdown() {
        if (scheduledThreadPool != null) {
            Logger.logShutdownMessage("Stopping background jobs...");
            ThreadPool.shutdownExecutor("scheduledThreadPool", scheduledThreadPool, 10);
            scheduledThreadPool = null;
            Logger.logShutdownMessage("...Done");
        }
    }

    public static void shutdownExecutor(String string, ExecutorService executorService, int n) {
        Logger.logShutdownMessage("shutting down " + string);
        executorService.shutdown();
        try {
            executorService.awaitTermination(n, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (!executorService.isTerminated()) {
            Logger.logShutdownMessage("some threads in " + string + " didn't terminate, forcing shutdown");
            executorService.shutdownNow();
        }
    }

    private static void runAll(List<Runnable> list) {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        StringBuffer stringBuffer = new StringBuffer();
        for (Runnable runnable : list) {
            Thread thread = new Thread(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    stringBuffer.append(throwable.getMessage()).append('\n');
                    throw throwable;
                }
            });
            thread.setDaemon(true);
            thread.start();
            arrayList.add(thread);
        }
        for (Thread thread : arrayList) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (stringBuffer.length() > 0) {
            throw new RuntimeException("Errors running startup tasks:\n" + stringBuffer.toString());
        }
    }

    private ThreadPool() {
    }

    static {
        backgroundJobs = new HashMap<Runnable, Long>();
        beforeStartJobs = new ArrayList<Runnable>();
        lastBeforeStartJobs = new ArrayList<Runnable>();
        afterStartJobs = new ArrayList<Runnable>();
    }
}

