/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.net.InetAddress;
import java.util.Map;
import nxt.Nxt;
import nxt.util.Logger;
import org.bitlet.weupnp.GatewayDevice;
import org.bitlet.weupnp.GatewayDiscover;

public class UPnP {
    private static boolean initDone = false;
    private static GatewayDevice gateway = null;
    private static InetAddress localAddress;
    private static InetAddress externalAddress;

    public static synchronized void addPort(int n) {
        if (!initDone) {
            UPnP.init();
        }
        if (gateway == null) {
            return;
        }
        try {
            if (gateway.addPortMapping(n, n, localAddress.getHostAddress(), "TCP", "NRS 1.13.1")) {
                Logger.logDebugMessage("Mapped port [" + externalAddress.getHostAddress() + "]:" + n);
            } else {
                Logger.logDebugMessage("Unable to map port " + n);
            }
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to map port " + n + ": " + exception.toString());
        }
    }

    public static synchronized void deletePort(int n) {
        if (!initDone || gateway == null) {
            return;
        }
        try {
            if (gateway.deletePortMapping(n, "TCP")) {
                Logger.logDebugMessage("Mapping deleted for port " + n);
            } else {
                Logger.logDebugMessage("Unable to delete mapping for port " + n);
            }
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to delete mapping for port " + n + ": " + exception.toString());
        }
    }

    public static synchronized InetAddress getLocalAddress() {
        if (!initDone) {
            UPnP.init();
        }
        return localAddress;
    }

    public static synchronized InetAddress getExternalAddress() {
        if (!initDone) {
            UPnP.init();
        }
        return externalAddress;
    }

    private static void init() {
        initDone = true;
        try {
            Logger.logInfoMessage("Looking for UPnP gateway device...");
            GatewayDevice.setHttpReadTimeout((int)Nxt.getIntProperty("nxt.upnpGatewayTimeout", GatewayDevice.getHttpReadTimeout()));
            GatewayDiscover gatewayDiscover = new GatewayDiscover();
            gatewayDiscover.setTimeout(Nxt.getIntProperty("nxt.upnpDiscoverTimeout", gatewayDiscover.getTimeout()));
            Map map = gatewayDiscover.discover();
            if (map == null || map.isEmpty()) {
                Logger.logDebugMessage("There are no UPnP gateway devices");
            } else {
                map.forEach((inetAddress, gatewayDevice) -> Logger.logDebugMessage("UPnP gateway device found on " + inetAddress.getHostAddress()));
                gateway = gatewayDiscover.getValidGateway();
                if (gateway == null) {
                    Logger.logDebugMessage("There is no connected UPnP gateway device");
                } else {
                    localAddress = gateway.getLocalAddress();
                    externalAddress = InetAddress.getByName(gateway.getExternalIPAddress());
                    Logger.logDebugMessage("Using UPnP gateway device on " + localAddress.getHostAddress());
                    Logger.logInfoMessage("External IP address is " + externalAddress.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to discover UPnP gateway devices: " + exception.toString());
        }
    }
}

